/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mcreator.redev.init.RedevModBlocks;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class MoobloomEntity
extends Cow
implements Shearable,
IForgeShearable {
    private static final EntityDataAccessor<String> FLOWER = SynchedEntityData.m_135353_(MoobloomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> HAS_FLOWERS = SynchedEntityData.m_135353_(MoobloomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private long flowerCooldownEndTime = 0L;

    public MoobloomEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<? extends MoobloomEntity>)((EntityType)RedevModEntities.MOOBLOOM.get()), world);
    }

    public MoobloomEntity(EntityType<? extends MoobloomEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLOWER, (Object)BuiltInRegistries.f_256975_.m_7981_((Object)((Block)RedevModBlocks.BUTTERCUP.get())).toString());
        this.f_19804_.m_135372_(HAS_FLOWERS, (Object)true);
    }

    public boolean hasFlowers() {
        return (Boolean)this.f_19804_.m_135370_(HAS_FLOWERS);
    }

    public void setHasFlowers(boolean hasFlowers) {
        this.f_19804_.m_135381_(HAS_FLOWERS, (Object)hasFlowers);
    }

    public void setFlower(Block flower) {
        if (flower != null) {
            this.f_19804_.m_135381_(FLOWER, (Object)BuiltInRegistries.f_256975_.m_7981_((Object)flower).toString());
        }
    }

    public Block getFlower() {
        String flowerId = (String)this.f_19804_.m_135370_(FLOWER);
        return (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(flowerId));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public MoobloomEntity getBreedOffspring(ServerLevel level, AgeableMob ageable) {
        return (MoobloomEntity)((EntityType)RedevModEntities.MOOBLOOM.get()).m_20615_((Level)level);
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.m_6162_() && this.hasFlowers();
    }

    public boolean isShearable(ItemStack stack, Level level, BlockPos pos) {
        return this.m_6220_();
    }

    public List<ItemStack> onSheared(Player player, ItemStack item, Level world, BlockPos pos, int fortune) {
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        return this.shearInternal(player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS);
    }

    public void m_5851_(SoundSource sound) {
        this.shearInternal(sound).forEach(s -> this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), s)));
    }

    private List<ItemStack> shearInternal(SoundSource sound) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12075_, sound, 1.0f, 1.0f);
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < 3; ++i) {
                items.add(new ItemStack((ItemLike)this.getFlower()));
            }
            this.setHasFlowers(false);
            this.flowerCooldownEndTime = this.m_9236_().m_46467_() + 3600L;
            return items;
        }
        return Collections.emptyList();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Level world = this.m_9236_();
        Block currentFlower = this.getFlower();
        if (itemstack.m_150930_(Items.f_42592_)) {
            if (!world.f_46443_) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (int i = 0; i < 3; ++i) {
                    items.add(new ItemStack((ItemLike)this.getFlower()));
                }
                items.forEach(stack -> world.m_7967_((Entity)new ItemEntity(world, this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), stack)));
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                world.m_6269_(null, (Entity)this, SoundEvents.f_12075_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.m_21406_(EntityType.f_20557_, false);
                itemstack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (Block.m_49814_((Item)itemstack.m_41720_()).m_49966_().m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("redev", "moobloom_flowers")))) {
            Block heldFlower = Block.m_49814_((Item)itemstack.m_41720_());
            if (heldFlower != null && heldFlower != currentFlower) {
                if (!world.f_46443_) {
                    this.setFlower(heldFlower);
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    itemstack.m_41774_(1);
                    world.m_6269_(null, (Entity)this, SoundEvents.f_144074_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        if (itemstack.m_150930_(Items.f_42399_)) {
            if (this.hasFlowers()) {
                if (!world.f_46443_) {
                    Block flowerBlock = this.getFlower();
                    ItemStack suspiciousStew = this.createSuspiciousStew(flowerBlock);
                    if (!player.m_150109_().m_36054_(suspiciousStew)) {
                        world.m_7967_((Entity)new ItemEntity(world, this.m_20185_(), this.m_20186_(), this.m_20189_(), suspiciousStew));
                    }
                    itemstack.m_41774_(1);
                    world.m_6269_(null, (Entity)this, SoundEvents.f_12073_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 5, 0.2, 0.2, 0.2, 0.0);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        if (itemstack.m_150930_(Items.f_42499_)) {
            if (!this.hasFlowers()) {
                if (!world.f_46443_) {
                    this.setHasFlowers(true);
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 10, 0.2, 0.2, 0.2, 0.0);
                    world.m_6269_(null, (Entity)this, SoundEvents.f_144074_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    itemstack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        return super.m_6071_(player, hand);
    }

    private ItemStack createSuspiciousStew(Block flowerBlock) {
        ItemStack stew = new ItemStack((ItemLike)Items.f_42718_);
        if (flowerBlock == Blocks.f_50112_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19611_, (int)100);
        } else if (flowerBlock == Blocks.f_50111_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19618_, (int)7);
        } else if (flowerBlock == Blocks.f_50113_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19618_, (int)7);
        } else if (flowerBlock == Blocks.f_50114_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19607_, (int)60);
        } else if (flowerBlock == Blocks.f_50115_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19607_, (int)220);
        } else if (flowerBlock == Blocks.f_50116_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19613_, (int)140);
        } else if (flowerBlock == Blocks.f_50117_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19613_, (int)140);
        } else if (flowerBlock == Blocks.f_50118_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19613_, (int)140);
        } else if (flowerBlock == Blocks.f_50119_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19613_, (int)140);
        } else if (flowerBlock == Blocks.f_50120_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19605_, (int)140);
        } else if (flowerBlock == Blocks.f_50121_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19603_, (int)100);
        } else if (flowerBlock == Blocks.f_50071_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19614_, (int)220);
        } else if (flowerBlock == Blocks.f_50070_) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19615_, (int)140);
        } else if (flowerBlock == RedevModBlocks.PINK_DAISY.get()) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19617_, (int)100);
        } else if (flowerBlock == RedevModBlocks.ROSE.get()) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19596_, (int)100);
        } else if (flowerBlock == RedevModBlocks.CYAN_ROSE.get()) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19596_, (int)100);
        } else if (flowerBlock == RedevModBlocks.BURSTBLOSSOM.get()) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19619_, (int)100);
        } else if (flowerBlock == RedevModBlocks.PAEONIA.get()) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19606_, (int)100);
        } else if (flowerBlock == RedevModBlocks.BUTTERCUP.get()) {
            SuspiciousStewItem.m_43258_((ItemStack)stew, (MobEffect)MobEffects.f_19605_, (int)100);
        }
        return stew;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_27593_()) {
            ServerLevel serverLevel;
            BlockPos pos = this.m_20183_();
            Level level = this.m_9236_();
            if (level instanceof ServerLevel && this.applyBonemealEffect(serverLevel = (ServerLevel)level, pos)) {
                this.m_9236_().m_5594_(null, pos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (!this.m_9236_().m_5776_() && !this.hasFlowers() && this.flowerCooldownEndTime <= this.m_9236_().m_46467_()) {
            this.setHasFlowers(true);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 5, 0.2, 0.2, 0.2, 0.0);
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private boolean applyBonemealEffect(ServerLevel level, BlockPos pos) {
        boolean effectApplied = false;
        BlockPos abovePos = pos.m_7494_();
        effectApplied = this.tryApplyBonemeal(level, abovePos);
        if (!effectApplied) {
            effectApplied = this.tryApplyBonemeal(level, pos);
        }
        if (!effectApplied) {
            BlockPos belowPos = pos.m_7495_();
            effectApplied = this.tryApplyBonemeal(level, belowPos);
        }
        return effectApplied;
    }

    private boolean tryApplyBonemeal(ServerLevel level, BlockPos pos) {
        Block block;
        BonemealableBlock bonemealable;
        BlockState blockState = level.m_8055_(pos);
        if (blockState.m_60734_() instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)blockState.m_60734_()).m_7370_((LevelReader)level, pos, blockState, level.f_46443_)) {
            bonemealable.m_214148_(level, level.f_46441_, pos, blockState);
            return true;
        }
        if (blockState.m_204336_(BlockTags.f_13073_) && (block = blockState.m_60734_()) instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block).m_7370_((LevelReader)level, pos, blockState, level.f_46443_)) {
            bonemealable.m_214148_(level, level.f_46441_, pos, blockState);
            return true;
        }
        return false;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Flower", BuiltInRegistries.f_256975_.m_7981_((Object)this.getFlower()).toString());
        compound.m_128379_("HasFlowers", this.hasFlowers());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Flower")) {
            Block flower = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(compound.m_128461_("Flower")));
            this.setFlower(flower);
        }
        if (compound.m_128441_("HasFlowers")) {
            this.setHasFlowers(compound.m_128471_("HasFlowers"));
        }
    }

    public static void init() {
    }
}

