/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.mcreator.redev.init.RedevModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class MossyGolemEntity
extends TamableAnimal {
    public boolean isPerformingEffect = false;
    private int effectCooldown = 0;
    private static final EntityDataAccessor<Boolean> PERFORMING_EFFECT = SynchedEntityData.m_135353_(MossyGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public MossyGolemEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<MossyGolemEntity>)((EntityType)RedevModEntities.MOSSY_GOLEM.get()), world);
    }

    public MossyGolemEntity(EntityType<MossyGolemEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FollowInjuredTamedMobsGoal(this, 1.25, 10.0f, 3.0f));
        this.f_21345_.m_25352_(2, (Goal)new FollowTamedMobsGoal(this, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowMobGoal((Mob)this, 1.0, 12.0f, 3.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(7, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(8, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.effectCooldown > 0) {
            --this.effectCooldown;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PERFORMING_EFFECT, (Object)false);
    }

    public boolean isPerformingEffect() {
        return (Boolean)this.f_19804_.m_135370_(PERFORMING_EFFECT);
    }

    public void setPerformingEffect(boolean value) {
        this.f_19804_.m_135381_(PERFORMING_EFFECT, (Object)value);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:mossy_golem.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:mossy_golem.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:mossy_golem.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:mossy_golem.death"));
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        Item item = itemstack.m_41720_();
        if (this.m_6898_(itemstack)) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)sourceentity)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
            } else if (!this.m_21824_()) {
                this.m_142075_(sourceentity, hand, itemstack);
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(sourceentity);
                    this.m_21530_();
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
        }
        return super.m_6071_(sourceentity, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_151016_);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    public static class FollowInjuredTamedMobsGoal
    extends Goal {
        private final MossyGolemEntity golem;
        private LivingEntity target;
        private final double speed;
        private final float followDistance;
        private final float stopDistance;
        private int waitTime = 0;
        private int healingTimer = 0;

        public FollowInjuredTamedMobsGoal(MossyGolemEntity golem, double speed, float followDistance, float stopDistance) {
            this.golem = golem;
            this.speed = speed;
            this.followDistance = followDistance;
            this.stopDistance = stopDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.golem.m_269323_() == null || this.golem.effectCooldown > 0) {
                return false;
            }
            List nearbyMobs = this.golem.m_9236_().m_45976_(LivingEntity.class, this.golem.m_20191_().m_82400_((double)this.followDistance));
            for (LivingEntity mob : nearbyMobs) {
                TamableAnimal tamedMob;
                if (!(mob instanceof TamableAnimal) || !(tamedMob = (TamableAnimal)mob).m_21824_() || tamedMob.m_269323_() != this.golem.m_269323_() || !(tamedMob.m_21223_() < tamedMob.m_21233_()) || tamedMob == this.golem) continue;
                this.target = tamedMob;
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.waitTime = 0;
            this.healingTimer = 0;
        }

        public void m_8037_() {
            if (this.target == null || !this.target.m_6084_() || this.golem.m_20270_((Entity)this.target) > this.followDistance) {
                this.resetGolemState();
                return;
            }
            if (this.golem.m_20270_((Entity)this.target) > this.stopDistance) {
                this.golem.m_21573_().m_5624_((Entity)this.target, this.speed);
            } else {
                this.golem.m_21573_().m_26573_();
                ++this.waitTime;
                if (this.waitTime == 1) {
                    this.golem.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("redev:mossy_golem.water")), 1.0f, 1.0f);
                    this.golem.setPerformingEffect(true);
                }
                this.spawnAuraParticles(this.golem);
                ++this.healingTimer;
                if (this.healingTimer >= 600) {
                    this.resetGolemState();
                    return;
                }
                if (this.waitTime >= 15) {
                    this.spawnEffectCloud(this.golem, this.target);
                    this.golem.effectCooldown = 200;
                    this.resetGolemState();
                }
            }
        }

        private void resetGolemState() {
            this.golem.setPerformingEffect(false);
            this.target = null;
            this.waitTime = 0;
            this.healingTimer = 0;
            this.golem.m_21573_().m_26573_();
        }

        private void spawnEffectCloud(MossyGolemEntity golem, LivingEntity target) {
            Level level = golem.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            List activeEffects = List.copyOf(golem.m_21220_());
            MobEffectInstance chosenEffect = activeEffects.isEmpty() ? new MobEffectInstance(MobEffects.f_19605_, 160, 1) : (MobEffectInstance)activeEffects.get(new Random().nextInt(activeEffects.size()));
            AreaEffectCloud cloud = new AreaEffectCloud((Level)serverLevel, target.m_20185_(), target.m_20186_(), target.m_20189_());
            cloud.m_19712_(2.5f);
            cloud.m_19734_(100);
            cloud.m_19716_(new MobEffectInstance(chosenEffect));
            cloud.m_19714_(chosenEffect.m_19544_().m_19484_());
            cloud.m_19724_((ParticleOptions)ParticleTypes.f_123811_);
            serverLevel.m_7967_((Entity)cloud);
            List nearbyMobs = serverLevel.m_45976_(LivingEntity.class, golem.m_20191_().m_82400_(14.0));
            for (LivingEntity mob : nearbyMobs) {
                TamableAnimal tamedMob;
                if (!(mob instanceof TamableAnimal) || !(tamedMob = (TamableAnimal)mob).m_21824_() || tamedMob.m_269323_() != golem.m_269323_() || tamedMob.m_21573_().m_26524_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1) == null) continue;
                tamedMob.m_21573_().m_26519_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.2);
            }
        }

        private void spawnAuraParticles(MossyGolemEntity golem) {
            Level level = golem.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            double x = golem.m_20185_();
            double y = golem.m_20186_();
            double z = golem.m_20189_();
            for (int i = 0; i < 15; ++i) {
                double offsetX = (golem.m_217043_().m_188500_() - 0.5) * (double)golem.m_20205_() * 1.5;
                double offsetY = golem.m_217043_().m_188500_() * (double)golem.m_20206_();
                double offsetZ = (golem.m_217043_().m_188500_() - 0.5) * (double)golem.m_20205_() * 1.5;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123803_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class FollowTamedMobsGoal
    extends Goal {
        private final TamableAnimal golem;
        private LivingEntity target;
        private final double speed;
        private final float followDistance;
        private final float stopDistance;
        private int followCooldown = 0;

        public FollowTamedMobsGoal(TamableAnimal golem, double speed, float followDistance, float stopDistance) {
            this.golem = golem;
            this.speed = speed;
            this.followDistance = followDistance;
            this.stopDistance = stopDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.followCooldown > 0) {
                --this.followCooldown;
                return false;
            }
            if (this.golem.m_269323_() == null) {
                return false;
            }
            List nearbyMobs = this.golem.m_9236_().m_45976_(LivingEntity.class, this.golem.m_20191_().m_82400_((double)this.followDistance));
            for (LivingEntity mob : nearbyMobs) {
                TamableAnimal tamedMob;
                if (!(mob instanceof TamableAnimal) || !(tamedMob = (TamableAnimal)mob).m_21824_() || tamedMob.m_269323_() != this.golem.m_269323_() || tamedMob.m_21223_() != tamedMob.m_21233_()) continue;
                this.target = tamedMob;
                this.followCooldown = 200 + this.golem.m_217043_().m_188503_(100);
                return true;
            }
            return false;
        }
    }
}

