/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.config;

import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.config.ModConfig;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import folk.sisby.kaleido.lib.quiltconfig.api.values.TrackedValue;
import java.util.LinkedHashMap;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class YetAnotherConfigFactory {
    private static ConfigCategory.Builder createCategory(String section, LinkedHashMap<String, ConfigCategory.Builder> categories) {
        if (categories.containsKey(section)) {
            return categories.get(section);
        }
        Object sectionKey = section;
        sectionKey = section == null ? "" : (String)sectionKey + "_";
        ConfigCategory.Builder category = ConfigCategory.createBuilder().name((Component)Component.translatable((String)"config.item-descriptions.%stitle".formatted(sectionKey)));
        categories.put(section, category);
        return category;
    }

    public static Screen create(Screen parent) {
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder().title((Component)Component.translatable((String)"modmenu.nameTranslation.item-descriptions"));
        LinkedHashMap<String, ConfigCategory.Builder> categories = new LinkedHashMap<String, ConfigCategory.Builder>();
        YetAnotherConfigFactory.addEntries(ModClient.CONFIG.values(), categories);
        for (ConfigCategory.Builder s : categories.values()) {
            builder.category(s.build());
        }
        builder.save(() -> ((ModConfig)ModClient.CONFIG).save());
        return builder.build().generateScreen(parent);
    }

    private static void addEntries(Iterable<TrackedValue<?>> fields, LinkedHashMap<String, ConfigCategory.Builder> categories) {
        for (TrackedValue<?> field : fields) {
            String categoryName = field.key().toString();
            categoryName = categoryName.contains(".") ? ModHelpers.toSnakeCase(categoryName.split("\\.")[0]) : null;
            ConfigCategory.Builder category = YetAnotherConfigFactory.createCategory(categoryName, categories);
            if (field.value().getClass() == Boolean.class) {
                category.option(Option.createBuilder().name(ModHelpers.fieldName(field)).description(OptionDescription.of((Component[])ModHelpers.fieldTooltip(field))).binding((Object)((Boolean)field.getDefaultValue()), () -> (Boolean)field.value(), value -> ModHelpers.fieldSetter(value, (TrackedValue<Boolean>)field)).controller(TickBoxControllerBuilder::create).build());
                continue;
            }
            if (field.value().getClass() == String.class) {
                category.option(Option.createBuilder().name(ModHelpers.fieldName(field)).description(OptionDescription.of((Component[])ModHelpers.fieldTooltip(field))).binding((Object)((String)field.getDefaultValue()), () -> (String)field.value(), value -> ModHelpers.fieldSetter(value, (TrackedValue<String>)field)).controller(StringControllerBuilder::create).build());
                continue;
            }
            if (field.value().getClass() != Integer.class) continue;
            category.option(Option.createBuilder().name(ModHelpers.fieldName(field)).description(OptionDescription.of((Component[])ModHelpers.fieldTooltip(field))).binding((Object)((Integer)field.getDefaultValue()), () -> (Integer)field.value(), value -> ModHelpers.fieldSetter(value, (TrackedValue<Integer>)field)).controller(IntegerFieldControllerBuilder::create).build());
        }
    }
}

