/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.neoforge;

import cc.cassian.item_descriptions.client.Platform;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;
import org.apache.commons.lang3.text.WordUtils;

public class NeoforgePlatformImpl
implements Platform {
    @Override
    public boolean isLoaded(String mod) {
        return ModList.get().isLoaded(mod);
    }

    @Override
    public boolean isLoadingLoaded(String mod) {
        return LoadingModList.get().getModFileById(mod) != null;
    }

    @Override
    public String loader() {
        return "neoforge";
    }

    @Override
    public File getMissingTranslationsPath() {
        Path savePath = FMLPaths.getOrCreateGameRelativePath((Path)Path.of("data", new String[0]).resolve("item-descriptions").resolve("missing"));
        return savePath.toFile();
    }

    @Override
    public Path configPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public String getModName(ItemStack stack) {
        String namespace = "minecraft";
        if (Minecraft.getInstance().level != null) {
            namespace = stack.getItem().getCreatorModId(stack);
        }
        String key = "modmenu.nameTranslation." + namespace;
        Optional modContainer = ModList.get().getModContainerById(namespace);
        if (modContainer.isPresent()) {
            return ((ModContainer)modContainer.get()).getModInfo().getDisplayName();
        }
        if (I18n.exists((String)key)) {
            return I18n.get((String)key, (Object[])new Object[0]);
        }
        return WordUtils.capitalize((String)namespace);
    }
}

