package cc.cassian.item_descriptions.client.helpers;

import cc.cassian.item_descriptions.client.DescriptionKey;
import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.NamespacedKey;
import cc.cassian.item_descriptions.client.Platform;
import cc.cassian.item_descriptions.client.helpers.compat.FastItemFramesHelpers;
//? if fabric
import cc.cassian.item_descriptions.client.helpers.compat.GlowcaseHelpers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import folk.sisby.kaleido.lib.quiltconfig.api.values.TrackedValue;
//? if fabric
import cc.cassian.item_descriptions.client.helpers.compat.PolymerHelpers;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.network.chat.*;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

import static cc.cassian.item_descriptions.client.ModClient.LOGGER;
import static cc.cassian.item_descriptions.client.ModClient.MOD_ID;

public class ModHelpers {

    public static final
    //? if >1.21.10 {
    /*Identifier
     *///?} else {
    class_2960
    //?}
    FABRIC_EVENT_PHASE = NamespacedKey.of("description_tooltip");

    /**
     * Check if ToolTipFix is installed and its wrapper should be used.
     */
    public static boolean useInternalWrapper() {
        return !isLoaded("tooltipfix");
    }

    /**
     * Check if another Enchantment Descriptions is installed and our descriptions should be disabled.
     */
    public static boolean useInternalEnchantmentDescriptions() {
        if (ModClient.CONFIG.developerOptions.forceEnableEnchantmentDescriptions.value())
            return true;
        else return !(isLoaded("idwtialsimmoedm") || isLoaded("enchdesc"));
    }

    /**
     * Check if another Enchantment Descriptions is installed and our descriptions should be disabled.
     */
    public static boolean useInternalEffectDescriptions() {
        if (ModClient.CONFIG.developerOptions.forceEnableEffectDescriptions.value())
            return true;
        else return !(isLoaded("potiondescriptions") || isLoaded("effectdescriptions"));
    }

    /**
     * Check if a mod is loaded
     */
    public static boolean isLoaded(String mod) {
        return Platform.INSTANCE.isLoaded(mod);
    }

    /**
     * Used in Config to change the tooltip's formatting.
     */
    public static class_2583 getStyle(String colour) {
        return class_2583.field_24360.method_27703(getColour(colour)).method_10978(ModClient.CONFIG.style.italics.value()).method_10982(ModClient.CONFIG.style.bold.getDefaultValue());
    }

    /**
     * Used in Config to change the tooltip's formatting.
     */
    public static class_5250 getHintText() {
        var sb = new StringBuilder();
        var config = ModClient.CONFIG;
        var shift = config.keybinds.displayWhenShiftIsHeld.value();
        var ctrl = config.keybinds.displayWhenCtrlIsHeld.value();
        var alt = config.keybinds.displayWhenAltIsHeld.value();
        if (config.hint.showKeybinds.value()) {
            if (ctrl) {
                var ctrlText = class_1074.method_4662("key.keyboard.ctrl");
                if (ModClient.CONFIG.hint.uppercase.value()) ctrlText = ctrlText.toUpperCase(Locale.ROOT);
                sb.append(ctrlText);
                if (shift || alt) sb.append("/");
            }
            if (alt) {
                var altText = class_1074.method_4662("key.keyboard.alt");
                if (ModClient.CONFIG.hint.uppercase.value()) altText = altText.toUpperCase(Locale.ROOT);
                sb.append(altText);
                if (shift) sb.append("/");
            }
            if (shift) {
                var shiftText = class_1074.method_4662("key.keyboard.shift");
                if (ModClient.CONFIG.hint.uppercase.value()) shiftText = shiftText.toUpperCase(Locale.ROOT);
                sb.append(shiftText);
            }
            sb.append(": ");
        }
        if (config.keybinds.invert.value())
            sb.append(class_1074.method_4662("hint.item-descriptions.hint_inverted"));
        else
            sb.append(class_1074.method_4662("hint.item-descriptions.hint"));
        return class_2561.method_43470(sb.toString());
    }

    /**
     * Used to check what colour a tooltip should be.
     */
    public static class_5251 getColour(String colour) {
        int length = colour.length();
        if (length == 1) {
            return class_5251.method_27718(class_124.method_544(colour.charAt(0)));
        }
        else {
            try {
                return class_5251.method_27717(Integer.parseInt(colour));
            } catch (NumberFormatException ignored) {}
            String replacedColour = colour.toLowerCase().replace(" ", "_");
            return switch (replacedColour) {
                case "black", "dark_blue", "dark_green", "dark_red", "dark_purple",
                     "blue", "green", "aqua", "red", "yellow", "white" ->
                        class_5251.method_27718(class_124.method_533(colour));
                case "pink", "light_purple" ->
                        class_5251.method_27718(class_124.method_533("light_purple"));
                case "dark_gray", "dark_grey" ->
                        class_5251.method_27718(class_124.method_533("dark_gray"));
                case "cyan", "dark_aqua" ->
                        class_5251.method_27718(class_124.method_533("dark_aqua"));
                case "orange", "gold", "dark_yellow" ->
                        class_5251.method_27718(class_124.method_533("gold"));
                default -> class_5251.method_27718(class_124.method_533("gray"));
            };
        }
    }

    /**
     * Handles detection of when a line break should be added in a tooltip.
     */
    public static int getIndex(String translatedKey, int maxLength) {
        String subKey = translatedKey.substring(0, maxLength);
        int index;
        //Find the last space character in the substring, if not, default to the length of the substring.
        if (subKey.contains(" ")) {
            index = subKey.lastIndexOf(" ");
        }
        else index = maxLength;
        return index;
    }

    /**
     * Check if a keybind is pressed and a tooltip should be displayed.
     */
    public static boolean tooltipKeyPressed() {
        var ctrl =
            //? if >1.21.8 {
            class_310.method_1551()
            //?} else {
            /*Screen
            *///?}
            .method_74188();
        var alt =
            //? if >1.21.8 {
            class_310.method_1551()
            //?} else {
            /*Screen
            *///?}
            .method_74189();
        var shift =
            //? if >1.21.8 {
            class_310.method_1551()
            //?} else {
            /*Screen
            *///?}
            .method_74187();
        if (ModClient.CONFIG.keybinds.displayWhenCtrlIsHeld.value() && ctrl) return checkKey(ctrl);
        else if (ModClient.CONFIG.keybinds.displayWhenShiftIsHeld.value() && shift) return checkKey(shift);
        else if (ModClient.CONFIG.keybinds.displayWhenAltIsHeld.value() && alt) return checkKey(alt);
        else return false;
    }

    /**
     * Check if a keybind is pressed. Contains the handling for if the key is inverted.
     */
    @SuppressWarnings({"DuplicateCondition", "ConstantValue"})
    public static boolean checkKey(boolean key) {
        boolean invert = ModClient.CONFIG.keybinds.invert.value();
        //If key is pressed, display the tooltip unless inverted.
        if (key) return !invert;
        //If key is not pressed, don't display the tooltip unless inverted.
        else if (!key) return invert;
        else return false;
    }

    /**
     * Create an item's lore key based off data from its Item Stack.
     */
    public static DescriptionKey findLoreKey(class_1799 stack) {
        // Disable Item Descriptions on Enchanted Books
        if (ModClient.CONFIG.enchantmentDescriptions.onlyEnchantmentDescriptionsOnBooks.value() && stack.method_31574(class_1802.field_8598)) {
            return DescriptionKey.empty();
        }
        //Ensure items from Polymer get the correct key instead of a vanilla one.
        //? if >1.21 && fabric {
        if (PolymerHelpers.getServerResourceLocation(stack) != null) {
            return new DescriptionKey(PolymerHelpers.getServerResourceLocation(stack));
        }
        //?}
        //? if >1.20.5 {
            //Ensure items with Custom Models get a custom key instead of a vanilla one.
            //? if >1.21.2 {
            if (hasComponent(stack, class_9334.field_54199))  {
                var data = Objects.requireNonNull(stack.method_57353().method_58694(class_9334.field_54199));
                DescriptionKey modelKey = new DescriptionKey(data);
                if (modelKey.hasTranslation()) {
                    return modelKey;
                }
            } else
            //?}
            //Ensure items with Custom Model Data get a custom key instead of a vanilla one.
            if (hasComponent(stack, class_9334.field_49637)) {
                var data = Objects.requireNonNull(stack.method_57353().method_58694(class_9334.field_49637));
                //? if <1.21.4 {
                 /*var dataValue = data.value();
                *///?} else {
                var dataValue = data.method_65366(0);
                //?}
                DescriptionKey key = getDescriptionKey(stack);
                DescriptionKey modelKey = key.hasTranslation() ? key : TagHelpers.checkGenericTagList(stack);
                modelKey.setSuffix(".custommodeldata." + dataValue);
                if (modelKey.hasTranslation()) {
                    return modelKey;
                }
            }
            //Ensure Paintings get a custom key instead of a vanilla one.
            else if (stack.method_31574(class_1802.field_8892) && hasComponent(stack, class_9334.field_49609)) {
                var data = Objects.requireNonNull(stack.method_57353().method_58694(class_9334.field_49609));
                //? if >1.21.8 {
                var variant = toTranslationKey(data.method_72540().method_68564("variant", ""));
                //?} else if >=1.21.5 {
                /*var variant = toTranslationKey(data.copyTag().getString("variant").orElse(""));
                *///?} else {
                /*var variant = toTranslationKey(data.copyTag().getString("variant"));
                *///?}
                var paintingKey = new DescriptionKey("lore", "minecraft", "painting", variant);
                if (paintingKey.hasTranslation() || ModClient.CONFIG.developerOptions.showAllPotentialKeys.value()) return paintingKey;
            }
            //Ensure player heads with Profile components get a custom key instead of a vanilla one.
            else if (hasComponent(stack, class_9334.field_49617)) {
                DescriptionKey profileKey = getProfile(stack);
                if (profileKey.hasTranslation()) {
                    return profileKey;
                }
            }
        //?} else {
        /*CompoundTag s = stack.getTag();
            if (s != null) {
                if (s.contains("CUSTOM_MODEL_DATA", Tag.TAG_ANY_NUMERIC)) {
                    DescriptionKey descKey = getDescriptionKey(stack);
                    DescriptionKey key = descKey.hasTranslation() ? descKey : TagHelpers.checkGenericTagList(stack);
                    key.setSuffix("custommodeldata." + Objects.requireNonNull(s.get("CUSTOM_MODEL_DATA")));
                }
                else if (s.contains("SkullOwner", Tag.STRING_SIZE)) {
                    DescriptionKey profileKey = getProfile(stack);
                    if (profileKey.hasTranslation()) {
                        return profileKey;
                    }
                }
            }
        *///?}
        DescriptionKey name = getModdedNameMatch(stack);
        if (name.hasTranslation()) {
            return name;
        }
        //Find the tooltip translation key for the provided item stack.
        DescriptionKey key = getDescriptionKey(stack);
        return checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(stack));
    }

    public static DescriptionKey getModdedNameMatch(class_1799 stack) {
        var key = getDescriptionKey(stack);
        key.setSuffix(toTranslationKey(stack.method_7909().method_7864(stack).getString()));
        return key;
    }

    public static String toTranslationKey(String string) {
        return string.toLowerCase().replaceAll("\"", "").replaceAll(" ", "_").replaceAll("[/:]", ".");
    }

    public static boolean hasTranslation(String key) {
        if (ModClient.CONFIG.developerOptions.showUntranslated.value()) return true;
        return class_1074.method_4663(key);
    }

    /**
     * Create a block's lore key based off data from WAILA-based Block Accessors like Jade/WTHIT/HYWLA.
     */
    public static DescriptionKey createBlockDescription(class_2248 block, class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        //Convert block translation key to lore translation key.
        DescriptionKey loreKey = findLoreKey(block);
        //? if >1.21 && fabric {
        if (isLoaded("polymer-bundled"))
            if (pos != null && PolymerHelpers.isPolymerBlock(pos)) {
                loreKey = new DescriptionKey(PolymerHelpers.findPolymerBlockResourceLocation(pos));
            }
        //?}
        //Custom handling of Player Heads so custom profiles give custom descriptions.
        if (blockEntity instanceof class_2631) {
            DescriptionKey profileKey = getProfile(blockEntity, loreKey);
            //Only show custom descriptions if a translation is present.
            if (profileKey.hasTranslation()) {
                return profileKey;
            }
        }
        if (isLoaded("fastitemframes")) {
            if (FastItemFramesHelpers.isFastItemFrame(blockEntity)) {
                var contents = FastItemFramesHelpers.getFastItemFrameContents(blockEntity);
                if (contents != null)
                    return findLoreKey(contents);
            }
        }
        //? if fabric {
        if (isLoaded("glowcase")) {
            if (GlowcaseHelpers.isItemDisplay(blockEntity)) {
                var contents = GlowcaseHelpers.getItemDisplayContents(blockEntity);
                if (contents != null)
                    return findLoreKey(contents);
            }
        }
        //?}
        //Check if translation exists. If not, see if an item exists for it - e.g. seeds.
        if (!loreKey.hasTranslation()) {
            if (pos == null) return findLoreKey(block.method_8389().method_7854());
            //? if <1.21.2 {
            /*return findLoreKey(block.getCloneItemStack(world, pos, state));
            *///?} else
            return findLoreKey(state.method_65171(world, pos, true));
        }
        return loreKey;
    }

    /**
     * Create an entity's lore key based off its entity data.
     */
    public static List<class_2561> createEntityDescription(class_1297 entity) {
        //Create and add tooltip.
        class_2561 name = entity.method_5477();
        if (entity instanceof class_1533 itemFrameEntity && !itemFrameEntity.method_6940().method_7960()) {
            return createTooltip(name, findLoreKey(itemFrameEntity.method_6940()));
        }
        //? if >1.21 {
        else if (entity instanceof class_1534 painting && painting.method_43404().method_40227()) {
            var loreKey = new DescriptionKey("lore", "minecraft", "painting", toTranslationKey(painting.method_43404().method_55840()));
            if (loreKey.hasTranslation())
                return createTooltip(name, loreKey);
        }
        //?}
        return createTooltip(name, findLoreKey(entity));
    }

    public static boolean createEnchantmentDescription(class_1799 stack, List<class_2561> lines) {
        boolean descriptionFound = false;
        if (ModClient.CONFIG.enchantmentDescriptions.enable.value() && showEnchantmentDescriptions()) {
            if (ModClient.CONFIG.enchantmentDescriptions.onlyShowOnBooks.value() && !stack.method_7909().equals(class_1802.field_8598))
                return false;
            //? if >1.21 {
            final var enchantments = new HashSet<>(class_1890.method_57532(stack).method_57534());
             //?} else if >1.20.5 {
            /*final var enchantments = new HashSet<>(EnchantmentHelper.getEnchantmentsForCrafting(stack).entrySet());
            *///?} else {
            /*final var enchantments = EnchantmentHelper.getEnchantments(stack).keySet();
            *///?}
            if (enchantments.isEmpty()) return false;
            for (var enchantmentEntry : enchantments) {
                //? if >1.21 {
                     var enchantment = enchantmentEntry.comp_349();
                //?} else {
                /*var enchantment = enchantmentEntry;
                *///?}
                for (int i = 0; i < lines.size(); i++) {
                    //? if >1.21 {
                    if (!lines.get(i).method_10851().equals(enchantment.comp_2686().method_10851())) continue;
                     //?} else if >1.20.5 {
                    /*if (!(lines.get(i).getContent() instanceof TranslatableContents text)) continue;
                    if (!text.getKey().equals(enchantment.value().getTranslationKey())) continue;
                    *///?} else {
                    /*if (!(lines.get(i).getContents() instanceof TranslatableContents text)) continue;
                    if (!text.getKey().equals(enchantment.getDescriptionId())) continue;
                    *///?}
                    class_7417 description = lines.get(i).method_10851();
                    if (description instanceof class_2588 translatableTextContent) {
                        var descriptionKey = new DescriptionKey(translatableTextContent.method_11022());
                        lines.add(i+1, descriptionKey.toText().method_10862(ModStyle.ENCHANTMENT_DESCRIPTIONS));
                    }
                }
            }
        }
        return descriptionFound;
    }

    private static boolean checkTranslatableText(class_2561 text, Predicate<class_2588> predicate) {
        class_7417 contents = null;
        if (text instanceof class_5250 mutable) {
            if (mutable.method_10855().stream().anyMatch(c -> checkTranslatableText(c, predicate))) {
                return true;
            }
            contents = mutable.method_10851();
        }
        if (contents == null)
            return false;
        return contents instanceof class_2588 translatable && predicate.test(translatable);
    }

    public static void fixEnchantmentDescription(class_1799 stack, List<class_2561> lines) {
        if (ModClient.CONFIG.enchantmentDescriptions.enable.value() && useInternalEnchantmentDescriptions()) {
            if (ModClient.CONFIG.enchantmentDescriptions.onlyShowOnBooks.value() && !stack.method_7909().equals(class_1802.field_8598))
                return;

            //? if >1.20.5 {
            final var enchantments = new HashSet<>(class_1890.method_57532(stack).method_57534());
            //?} else {
            /*final var enchantments = EnchantmentHelper.getEnchantments(stack).keySet();
             *///?}

            if (enchantments.isEmpty())
                return;

            for (int i = 0; i < lines.size(); ++i) {
                if (isEnchantmentDescription(lines.get(i), (Set)enchantments)) {
                    // Create the tooltip.
                    var newLines = createTooltip(stack.method_7954(), lines.get(i), useInternalWrapper());
                    if (newLines.isEmpty())
                        continue;
                    // To avoid warnings, we don't remove from lines and instead modify the initial line to the first line.
                    lines.set(i, newLines.get(0));
                    // Add the remaining lines.
                    if (newLines.size() > 1) {
                        lines.addAll(i+1, newLines.subList(1, newLines.size()));
                    }
                }
            }
        }
    }

    private static boolean isEnchantmentDescription(class_2561 text, Set<Object> enchantments) {
        // If the Minecraft world is null, we cannot check if this is an enchantment key.
        if (class_310.method_1551().field_1687 == null)
            return false;
        return checkTranslatableText(text, content -> {
            // Split the lang key of this translatable content.
            String[] split = content.method_11022().split("\\.");
            // The split key array should always be at least 3 in length, so return false if that's not the case.
            if (split.length < 3)
                return false;
            String namespace = split[1];
            String path = split[2];
            // Check whether the translation exists, and if the key is either an enchantment.*.*.description/desc or lore.*.* key.
            if (hasTranslation(content.method_11022()) && (split.length == 4 && split[0].equals("enchantment") && (split[3].equals("description") || split[3].equals("desc")) || split.length == 3 && split[0].equals("lore"))) {
                // Whether the namespace and path maps to an enchantment on this item. If so, return true.
                //? if >1.21 {
                return enchantments.stream().anyMatch(entry -> ((class_6880<class_1887>)(Object)entry).method_40226(NamespacedKey.of(namespace, path)));
                //?} else if >1.20 {
                /*return enchantments.stream().anyMatch(entry -> BuiltInRegistries.ENCHANTMENT.getKey((Enchantment)(Object)entry).equals(NamespacedKey.of(namespace, path)));
                 *///?} else {
                /*return enchantments.stream().anyMatch(entry -> Registry.ENCHANTMENT.getKey((Enchantment)(Object)entry).equals(NamespacedKey.of(namespace, path)));
                 *///?}
            }
            return false;
        });
    }

    public static List<class_2561> createEffectDescription(List<class_2561> text) {
        ArrayList<class_2561> lines = new ArrayList<>(text);
        if (ModClient.CONFIG.effectDescriptions.enable.value()) {
            for (class_2561 text1 : text) {
                if (text1.method_10851() instanceof class_2588 translatableTextContent) {
                    if (!translatableTextContent.method_11022().startsWith("effect.duration")) {
                        var key = new DescriptionKey(translatableTextContent.method_11022());
                        List<class_2561> tooltip = ModHelpers.createTooltip(text1, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
                        if (showEffectDescriptions()) {
                            lines.addAll(tooltip);
                        }
                        else if (ModClient.CONFIG.hint.enabled.value() && (key.hasTranslation())) {
                            addHint(lines);
                        }
                    }
                }
            }
        }
        return lines;
    }

    public static void createEffectDescription(class_2561 name, Consumer<class_2561> textConsumer, class_1293 statusEffectInstance) {
        if (ModClient.CONFIG.effectDescriptions.enable.value() && showEffectDescriptions()) {
            var key = new DescriptionKey(statusEffectInstance.method_5586());
            List<class_2561> tooltip = ModHelpers.createTooltip(name, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
            if (showEffectDescriptions()) {
                for (class_2561 line : tooltip) {
                 textConsumer.accept(line);
                }
            }
        }
    }

    public static void createEffectDescription(class_2561 name, List<class_2561> textConsumer, class_1293 statusEffectInstance) {
        if (ModClient.CONFIG.effectDescriptions.enable.value() && showEffectDescriptions()) {
            var key = new DescriptionKey(statusEffectInstance.method_5586());
            List<class_2561> tooltip = ModHelpers.createTooltip(name, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
            if (showEffectDescriptions()) {
                textConsumer.addAll(tooltip);
            }
        }
    }

    public static void addHint(List<class_2561> lines) {
        lines.add(1, getHintText().method_10862(ModStyle.HINT));
    }

    public static boolean createItemDescription(class_1799 stack, List<class_2561> lines) {
        if (ModClient.CONFIG.itemDescriptions.value()) {
            //Create and add tooltip.
            List<class_2561> tooltip;
            DescriptionKey descriptionKey = findLoreKey(stack);
            if (ModClient.CONFIG.developerOptions.showAllPotentialKeys.value()) {
                tooltip = TagHelpers.findAllPotentialKeys(stack);
            } else if (descriptionKey.hasTranslation()) {
                tooltip = List.of(descriptionKey.toText());
            }
            else return false;
            tooltip = tooltip.stream().map(text -> (class_2561)text.method_27661().method_10862(ModStyle.ITEM_DESCRIPTIONS)).toList();
            if (showItemDescriptions())
                lines.addAll(tooltip);
            else return descriptionKey.hasTranslation();
        }
        return false;
    }

    public static void fixItemDescription(class_1799 stack, List<class_2561> lines) {
        if (ModClient.CONFIG.itemDescriptions.value() && showItemDescriptions()) {
            //Find and wrap tooltip. Will be disabled if TooltipFix is installed.
            List<class_2561> tooltip;
            DescriptionKey descriptionKey = findLoreKey(stack);
            if (ModClient.CONFIG.developerOptions.showAllPotentialKeys.value()) {
                tooltip = TagHelpers.findAllPotentialKeys(stack);
            } else {
                tooltip = List.of(descriptionKey.toText());
            }
            for (int i = 0; i < lines.size(); ++i) {
                // Required for lambda comparison.
                int finalI = i;
                // Check if any of the tooltips' content matches the current line's content.
                if (tooltip.stream().anyMatch(text -> text.method_10851().equals(lines.get(finalI).method_10851()))) {
                    var newLines = createTooltip(stack.method_7954(), lines.get(i), useInternalWrapper());
                    lines.set(i, newLines.get(0));
                    if (newLines.size() > 1) {
                        lines.addAll(i+1, newLines.subList(1, newLines.size()));
                    }
                }
            }

        }
    }

    /**
     * Check if an Item Stack has a particular component.
     */
    //? if =1.20.6 {
    /*public static boolean hasComponent(ItemStack stack, DataComponentType<?> type) {
        return stack.getComponents().contains(type);
    }
    *///?}

    /**
     * Check if an Item Stack has a particular component.
     */
    //? if >1.21 {
    public static boolean hasComponent(class_1799 stack, class_9331<?> type) {
        return stack.method_57353().method_57832(type);
    }
    //?}

    /**
     * Find a profile name in a Player Head Item Stack.
     */
    public static DescriptionKey getProfile(class_1799 stack) {
        //? if >1.20.5 {
        var optionalProfileName = Objects.requireNonNull(Objects.requireNonNull(stack.method_57353().method_58694(class_9334.field_49617)).method_73317()).orElse("");
        //?} else {
        /*var optionalProfileName = Objects.requireNonNull(stack.getTag().get("CUSTOM_MODEL_DATA")).toString();
         *///?}
        if (!optionalProfileName.isEmpty()) {
            DescriptionKey key = getDescriptionKey(stack);
            DescriptionKey profileKey = key.hasTranslation() ? key : TagHelpers.checkGenericTagList(stack);
            profileKey.setSuffix("profile." + optionalProfileName);
            if (profileKey.hasTranslation()) {
                return profileKey;
            }
        }
        return DescriptionKey.empty();
    }

    /**
     * Find a profile name in a Player Head block.
     */
    public static DescriptionKey getProfile(class_2586 blockEntity, DescriptionKey loreKey) {
        String optionalProfileName;
        try {
            //? if >1.20.5 {
            optionalProfileName = Objects.requireNonNull(((class_2631) blockEntity).method_11334()).method_73317().orElse("");
            //?} else
            /*optionalProfileName = Objects.requireNonNull(((SkullBlockEntity) blockEntity).getOwnerProfile()).getName();*/
        }
        catch (NullPointerException nullPointerException) {
            return loreKey;
        }
        loreKey.setSuffix("profile." + optionalProfileName);
        return loreKey;
    }

    /**
     * Check if block descriptions should be shown based off configuration.
     */
    public static boolean showBlockDescriptions() {
        return ModClient.CONFIG.blockDescriptions.enable.value() && (tooltipKeyPressed() || ModClient.CONFIG.blockDescriptions.showAlways.value());
    }

    /**
     * Check if item descriptions should be shown based off configuration.
     */
    public static boolean showItemDescriptions() {
        return ModClient.CONFIG.itemDescriptions.value() && (tooltipKeyPressed() || ModClient.CONFIG.displayAlways.value());
    }
    /**
     * Check if enchantment descriptions should be shown based off configuration.
     */
    public static boolean showEnchantmentDescriptions() {
        return ModClient.CONFIG.enchantmentDescriptions.enable.value() && useInternalEnchantmentDescriptions() && (tooltipKeyPressed() || ModClient.CONFIG.enchantmentDescriptions.displayAlways.value());
    }
    /**
     * Check if entity descriptions should be shown based off configuration.
     */
    public static boolean showEntityDescriptions() {
        return ModClient.CONFIG.entityDescriptions.enable.value() && (tooltipKeyPressed() || ModClient.CONFIG.entityDescriptions.showAlways.value());
    }
    /**
     * Check if effect descriptions should be shown based off configuration.
     */
    public static boolean showEffectDescriptions() {
        return ModClient.CONFIG.effectDescriptions.enable.value() && useInternalEffectDescriptions() && (tooltipKeyPressed() || ModClient.CONFIG.effectDescriptions.displayAlways.value());
    }

    public static void createDescriptionsFromItemStack(class_1799 stack, List<class_2561> lines) {
        if (ModClient.CONFIG.developerOptions.hideOtherTooltips.value() || ModLists.hidden_items.contains(stack.method_7909())) {
            var first = lines.get(0);
            lines.clear();
            lines.add(first);
        }
        boolean enchant = createEnchantmentDescription(stack, lines);
        boolean effect = checkForEffectDescription(stack);
        if (ModClient.CONFIG.effectDescriptions.onlyShowEffectDescriptions.value() && effect) return;
        boolean item = createItemDescription(stack, lines);
        if (ModClient.CONFIG.hint.enabled.value() && (item || enchant)) {
            addHint(lines);
        }
        if ((tooltipKeyPressed() || ModClient.CONFIG.displayAlways.value()) && ModClient.CONFIG.showModName.value()) {
            addModName(stack, lines);
        }
    }

    private static void addModName(class_1799 stack, List<class_2561> lines) {
        String namespace = Platform.INSTANCE.getModName(stack);
        class_5250 text = class_2561.method_43470(namespace);
        lines.add(text.method_10862(ModStyle.MOD_NAME));
    }

    public static String getModName(class_1799 stack) {
        return Platform.INSTANCE.getModName(stack);
    }

    public static class_5250 translatableWithFallback(String translatable, String fallback) {
        //? if >1.20 {
        return class_2561.method_48321(translatable, fallback);
         //?} else {
        /*if (ModHelpers.hasTranslation(translatable)) {
            return Component.translatable(translatable);
        }
        return Component.literal(fallback);
        *///?}
    }

    private static boolean checkForEffectDescription(class_1799 stack) {
        //? if >1.20.5 {
        if (hasComponent(stack, class_9334.field_49651)) {
            var contents = stack.method_57353().method_58694(class_9334.field_49651);
            if (contents == null) return false;
            for (class_1293 effect : contents.method_57397()) {
                var key = new DescriptionKey(effect.method_5586());
                if (key.hasTranslation()) {
                    return true;
                }
            }
        }
        //?} else {
        /*if (stack.hasTag()) {
            assert stack.getTag() != null;
            String potion = stack.getTag().getString("Potion");
            return new DescriptionKey("effect", new ResourceLocation(potion)).hasTranslation();
        }
        *///?}
        return false;
    }

    public static void fixItemStackDescriptionTooltip(class_1799 stack, List<class_2561> lines) {
        if (!useInternalWrapper())
            return;
        fixEnchantmentDescription(stack, lines);
        if (useInternalWrapper())
            fixItemDescription(stack, lines);
    }

    /**
     * Find a profile name
     */
    public static String getProfileName(Optional<String> optionalProfileName) {
        String profileName;
        if (optionalProfileName.isPresent()) {
            profileName = optionalProfileName.get();
            return profileName;
        } else {
            return "";
        }
    }

    /**
     * Consistency feature for 1.20.
     */
    public static String getProfileName(String optionalProfileName) {
        return optionalProfileName;
    }

    /**
     * Shorthand to check a block's lore key.
     */
    public static DescriptionKey findLoreKey(class_2248 block) {
        DescriptionKey key = getDescriptionKey(block);
        return checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(block));
    }

    /**
     * Shorthand to check a blockstate's lore key.
     */
    public static DescriptionKey findLoreKey(class_2680 state) {
        DescriptionKey key = getDescriptionKey(state);
        return checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(state));
    }

    /**
     * Shorthand to check an entity's lore key.
     */
    public static DescriptionKey findLoreKey(class_1297 entity) {
        return findLoreKey(entity.method_5864());
    }

    /**
     * Shorthand to check an entity's lore key.
     */
    public static DescriptionKey findLoreKey(class_1299<?> entity) {
        DescriptionKey key = getDescriptionKey(entity);
        return checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(entity));
    }

    /**
     * Check if a lore key exists or if a generic tooltip should be used.
     */
    public static DescriptionKey checkLoreKey(DescriptionKey loreKey) {
        //Check if the tooltip translation key exists. If so, use the provided tooltip.
        if (loreKey != null && loreKey.hasTranslation()) return loreKey;
        else return DescriptionKey.empty();
    }

    /**
     * Convert block/item/entity translation keys to lore translation keys.
     */
    public static @NotNull DescriptionKey convertToLoreKey(String translationKey) {
        DescriptionKey loreKey;
        //Find the translation key for blocks.
        if (translationKey.contains("block.")) loreKey = new DescriptionKey(translationKey);
        //Find the translation key for items.
        else if ((translationKey.contains("item."))) loreKey = new DescriptionKey(translationKey);
        //Find the translation key for entities.
        else if ((translationKey.contains("entity."))) {
            //Entity descriptions use a different format as to avoiding colliding with items of the same name.
            loreKey = new DescriptionKey(translationKey);
            //Tropical fish have 20 different variants and their description should be the same.
            if (translationKey.contains("tropical_fish")) {
                loreKey = new DescriptionKey("entity", "minecraft", "tropical_fish");
            }
            //In case an entity tooltip is misconfigured, try checking for an "old style" key.
            else if (loreKey.hasTranslation()) return loreKey;
        }
        else return DescriptionKey.empty();
        return loreKey;
    }

    public static @NotNull DescriptionKey getDescriptionKey(class_1799 stack) {
        return getDescriptionKey(stack.method_7909());
    }

    public static @NotNull DescriptionKey getDescriptionKey(class_1792 item) {
        return convertToLoreKey(item.method_7876());
    }

    public static @NotNull DescriptionKey getDescriptionKey(class_2680 blockState) {
        return getDescriptionKey(blockState.method_26204());
    }

    public static @NotNull DescriptionKey getDescriptionKey(class_2248 block) {
        return convertToLoreKey(block.method_63499());
    }

    public static @NotNull DescriptionKey getDescriptionKey(class_1299<?> entityType) {
        return convertToLoreKey(entityType.method_5882());
    }

    public static @NotNull DescriptionKey getDescriptionKey(class_1297 entity) {
        return convertToLoreKey(getEntityTranslationKey(entity));
    }

    public static @NotNull DescriptionKey getDescriptionKey(class_1291 effect) {
        return new DescriptionKey(effect.method_5567());
    }

    public static @NotNull DescriptionKey getDescriptionKey(class_1887 enchantment) {
        return getEnchantmentDescriptionKey(enchantment);
    }

    public static DescriptionKey getEnchantmentDescriptionKey(class_1887 enchantment) {
        //? if >1.21 {
        return enchantment.comp_2686().method_10851() instanceof class_2588 translatable ? new DescriptionKey(translatable.method_11022()) : DescriptionKey.empty();
         //?} else
        /*return new DescriptionKey(enchantment.getDescriptionId());*/
    }

    /**
     * Find an entity's translation key
     */
    public static String getEntityTranslationKey(class_1297 entity) {
        //Allow for custom player descriptions
        if (entity instanceof class_1657) {
            //? if >1.21 {
            String playerKey = "entity.minecraft.player.%s".formatted(entity.method_5477().method_54160());
            //?} else
            /*String playerKey = "entity.minecraft.player." + entity.getName().getString();;*/
            //Check if a custom player description exists.
            if (hasTranslation(playerKey)) return playerKey;
            //If not, use the default one.
            else return "entity.minecraft.player";
        } else {
            return entity.method_5864().method_5882();
        }
    }

    /**
     * Create a custom multi-line tooltip.
     *
     * @param loreKey The translation key that will be translated and wrapped.
     */
    public static List<class_2561> createTooltip(class_2561 name, DescriptionKey loreKey) {
        return createTooltip(name, loreKey.toString(), true);
    }

    /**
     * Create a custom multi-line tooltip.
     *
     * @param loreKey The translation key that will be translated and wrapped.
     */
    public static List<class_2561> createTooltip(class_2561 name, String loreKey) {
        return createTooltip(name, loreKey, true);
    }

    /**
     * Create a custom, potentially multi-line tooltip.
     * @param loreKey The translation key that will be translated.
     * @param wrap Whether to use the built-in wrapper.
     */
    public static List<class_2561> createTooltip(class_2561 name, String loreKey, boolean wrap) {
        return createTooltip(name, loreKey, wrap, ModStyle.ITEM_DESCRIPTIONS);
    }


    public static List<class_2561> createTooltip(class_2561 name, class_2561 text, boolean wrap) {
        if (!wrap || text.getString().isEmpty())
            return List.of(text);
        //Setup list to store (potentially multi-line) tooltip.
        ArrayList<class_2561> lines = new ArrayList<>();
        //Check if the key exists.
        wrapTooltip(name, lines, List.of(text));
        resetWrapValues();
        return lines;
    }

    /**
     * Create a custom, potentially multi-line tooltip.
     *
     * @param loreKey The translation key that will be translated.
     * @param wrap    Whether to use the built-in wrapper.
     * @param style   How to style the text content
     */
    public static List<class_2561> createTooltip(class_2561 name, String loreKey, boolean wrap, class_2583 style) {
        //Setup list to store (potentially multi-line) tooltip.
        ArrayList<class_2561> lines = new ArrayList<>();
        //Check if the key exists.
        if (!loreKey.isBlank()) {
            //Translate the lore key.
            String translatedKey = class_1074.method_4662(loreKey);
            //Check if the translated key exists.
            if (hasTranslation(loreKey)) {
                if (!wrap) {
                    if (!translatedKey.isBlank()) lines.add(class_2561.method_43471(loreKey).method_10862(style));
                }
                else {
                    wrapTooltip(name, lines, List.of(class_2561.method_43470(translatedKey).method_10862(style)));
                    resetWrapValues();
                }
            }
        }
        return lines;
    }

    // Store this outside of the method to make sure that it can be carried over to other calls of wrapTooltip.
    private static int lineTextWidth = 0;
    // This is a hook for any mod that wishes to indent the description text while it is translatable.
    private static boolean shouldIndent = false;
    private static class_2561 indentationText = null;

    private static void resetWrapValues() {
        lineTextWidth = 0;
        shouldIndent = true;
        indentationText = null;
    }

    /**
     * An internal method for wrapping this tooltip.
     * @param lines The lines for the final tooltip.
     * @param keys Any contents that make up this text object. Obtained through {@link class_2561#method_10855()}.
     */
    private static void wrapTooltip(class_2561 name, List<class_2561> lines, List<class_2561> keys) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (textRenderer != null && ModClient.CONFIG.style.length.value() != 0) {
            int maxLength = Math.max(ModClient.CONFIG.style.length.value(), textRenderer.method_27525(name));
            for (class_2561 originalText : keys) {
                // Get the text without siblings, as they're individually handled after the initial content.
                class_2561 translated = originalText.method_27662().method_10862(originalText.method_10866());
                if (translated.method_10851() instanceof class_2588 translatable)
                    translated = class_2561.method_43470(class_1074.method_4662(translatable.method_11022())).method_10862(translated.method_10866());

                if (shouldIndent && translated.getString().isBlank() && !translated.getString().isEmpty()) {
                    indentationText = originalText.method_27662();
                    // Before moving onto the next bit of text, handle any siblings of the original text.
                    wrapTooltip(name, lines, originalText.method_10855());
                    shouldIndent = false;
                    continue;
                }
                shouldIndent = false;
                //Any tooltip longer than XX pixels should be shortened.
                while (lineTextWidth + textRenderer.method_27525(translated) >= maxLength && translated.getString().contains(" ")) {
                    // Reset the line width.
                    lineTextWidth = 0;
                    // Remove the line substring from the start of the remaining string. Repeat.
                    translated = createNewLine(lines, translated, textRenderer, maxLength);
                }
                //Add the remainder of this tooltip text.
                if (!translated.getString().isEmpty()) {
                    //Any additional tooltip less than XX pixels should be merged and shortened.
                    if (!lines.isEmpty() && lines.size() > 1 && textRenderer.method_27525(lines.get(lines.size() - 1)) + textRenderer.method_27525(translated) < maxLength && translated.getString().contains(" ")) {
                        // Remove the previous text...
                        class_2561 oldText = lines.remove(lines.size() - 1);
                        // And merge it into the new one.
                        class_2561 newText = oldText.method_27661().method_10852(translated);
                        // Create a new line with the merged text object.
                        createNewLine(lines, newText, textRenderer, maxLength);
                        // Set the text line width
                        lineTextWidth = 0;
                    } else {
                        // Set the text line width
                        lineTextWidth = textRenderer.method_27525(translated);
                        createNewLine(lines, translated, textRenderer, maxLength);
                    }
                }

                // Before moving onto the next bit of text, handle any siblings of the original text.
                wrapTooltip(name, lines, originalText.method_10855());
            }
        }
    }

    private static class_2561 createNewLine(List<class_2561> lines, class_2561 text, class_327 textRenderer, int maxLength) {
        int lineLength = text.getString().length();
        // Find where to end this line, starting from the remaining string.
        if (text.getString().contains("\n")) {
            lineLength = text.getString().indexOf("\n");
        } else {
            while (text.getString().substring(0, lineLength).contains(" ") && textRenderer.method_27525(class_2561.method_43470(text.getString().substring(0, lineLength))) >= maxLength) {
                lineLength = getIndex(text.getString(), lineLength);
            }
        }
        class_2561 newLine = subText(text, 0, lineLength);
        if (indentationText != null) {
            newLine = indentationText.method_27661().method_10852(newLine);
        }
        // Add the line.
        lines.add(newLine);
        // Return a new literal that removes the operated characters.
        return subText(text, lineLength + 1);
    }

    private static class_2561 subText(class_2561 text, int beginIndex) {
        return subText(text, beginIndex, text.getString().length());
    }

    private static class_2561 subText(class_2561 text, int beginIndex, int endIndex) {
        return subText(text, beginIndex, endIndex, 0);
    }

    private static class_2561 subText(class_2561 text, int beginIndex, int endIndex, int currentIndex) {
        class_5250 mutable = text.method_27662();

        if (beginIndex > mutable.getString().length()) {
            beginIndex -= mutable.getString().length();
            currentIndex += mutable.getString().length();
        } else {
            // Substring the beginning index.
            String string = mutable.getString();
            string = string.substring(beginIndex, Math.min(endIndex - currentIndex, string.length()));
            mutable = class_2561.method_43470(string).method_10862(text.method_10866());
            currentIndex += string.length();
        }

        if (currentIndex >= endIndex)
            return mutable;

        for (class_2561 sibling : text.method_10855()) {
            if (currentIndex >= endIndex)
                break;
            class_2561 subTextSibling = subText(sibling, beginIndex, endIndex, currentIndex);
            currentIndex += subTextSibling.getString().length();
            mutable.method_10852(subTextSibling);
        }

        return mutable;

    }

    /**
     * Automatically generate translation keys for config options.
     */
    public static class_2561 fieldName(TrackedValue<?> field) {
        return class_2561.method_43471("config.%s.%s".formatted(MOD_ID, toSnakeCase(field.key().toString())));
    }

    public static String toSnakeCase(String field) {
        return field.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }
    
    /**
     * Automatically generate translation keys for config tooltips. Relies on custom tooltip wrapping.
     */

    public static class_2561[] fieldTooltip(TrackedValue<?> field, boolean wrap) {
        String tooltipKey = "config.%s.%s.tooltip".formatted(MOD_ID, toSnakeCase(field.key().toString()));
        if (wrap)
            return createTooltip(class_2561.method_43473(), tooltipKey).toArray(new class_2561[0]);
        else return List.of(ModHelpers.translatableWithFallback(tooltipKey, "")).toArray(new class_2561[0]);
    }

    /**
     * Set a config field.
     */
    public static void fieldSetter(boolean instance, TrackedValue<Boolean> field) {
        field.setValue(instance);
    }
    public static void fieldSetter(Integer instance, TrackedValue<Integer> field) {
        field.setValue(instance);
    }
    public static void fieldSetter(String instance, TrackedValue<String> field) {
        field.setValue(instance);
    }

    private static <T, V> void addMissingTranslations(class_2378<T> registry, Map<String, Map<String, String>> namespaces, Function<T, V> valueTransform, Function<V, DescriptionKey> descGetter, Function<V, List<class_2561>> potentialKeys) {
        for (class_5321<T> key : registry.method_42021()) {
            V value = valueTransform.apply
            //? if >=1.21.2 {
            (registry.method_29107(key));
            //?} else {
            /*(registry.get(key));
            *///?}
            DescriptionKey description = descGetter.apply(value);
            List<String> keys = new ArrayList<>(potentialKeys.apply(value).stream().map(class_2561::getString).toList());
            if (description.isEmpty()) {
                //? if >1.21.10 {
                /*LOGGER.warn("[Item Descriptions] Couldn't get lore key for {}: {}!", registry.getAny().get(), key.identifier());
                *///?} else if >=1.21 {
                 LOGGER.warn("[Item Descriptions] Couldn't get lore key for {}: {}!", registry.method_60385().get(), key.method_29177());
                 //?} else {
                /*LOGGER.warn("[Item Descriptions] Couldn't get lore key for: {}!", key.location());
                *///?}
            } else if (keys.stream().noneMatch(class_1074::method_4663)) {
                keys.remove(description.asLoreTranslation());
                if (value instanceof class_1799 stack) keys.remove(getModdedNameMatch(stack).asLoreTranslation()); // Ugly
                namespaces.computeIfAbsent(key.
                        //? if >1.21.10 {
                        /*identifier
                        *///?} else {
                        method_29177
                        //?}
                        ().method_12836(), k -> new TreeMap<>()).compute(value instanceof class_2248 || value instanceof class_1792 ? description.asLoreTranslation() : description.asDescriptionTranslation(), (k, v) -> Objects.requireNonNullElse(v, " ??? ") + String.join(", ", keys));
            }
        }
    }
    
    public interface RegistryGetter {
        <E> Optional<? extends class_2378<E>> get(class_5321<? extends class_2378<? extends E>> key);
    }

    @SuppressWarnings("unchecked")
    public static void generateMissingTranslations(RegistryGetter registryGetter) {
        ModClient.LOGGER.info("[Item Descriptions] Creating missing translations files");
        File folder = Platform.INSTANCE.getMissingTranslationsPath();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Map<String, Map<String, String>> namespaces = new HashMap<>();
        addMissingTranslations((class_2378<class_1299<?>>) (Object) registryGetter.get(class_5321.method_29180(NamespacedKey.ofVanillaId("entity_type"))).orElse(null), namespaces, Function.identity(), ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        addMissingTranslations((class_2378<class_1792>) (Object) registryGetter.get(class_5321.method_29180(NamespacedKey.ofVanillaId("item"))).orElse(null), namespaces, class_1792::method_7854, ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        addMissingTranslations((class_2378<class_1887>) (Object) registryGetter.get(class_5321.method_29180(NamespacedKey.ofVanillaId("enchantment"))).orElse(null), namespaces, Function.identity(), ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        addMissingTranslations((class_2378<class_2248>) (Object) registryGetter.get(class_5321.method_29180(NamespacedKey.ofVanillaId("block"))).orElse(null), namespaces, class_2248::method_9564, ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys); // Blocks will overwrite items
        addMissingTranslations((class_2378<class_1291>) (Object) registryGetter.get(class_5321.method_29180(NamespacedKey.ofVanillaId("mob_effect"))).orElse(null), namespaces, Function.identity(), ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        Map<String, String> combined = new TreeMap<>();
        namespaces.values().forEach(combined::putAll);
        namespaces.put(ModClient.MOD_ID_NEO, combined);
        for (Map.Entry<String, Map<String, String>> entry : namespaces.entrySet()) {
            String namespace = entry.getKey();
            Map<String, String> map = entry.getValue();
            Path namespacePath = folder.toPath().resolve("assets").resolve(namespace).resolve("lang");
            namespacePath.toFile().mkdirs();
            try (FileWriter writer = new FileWriter(namespacePath.resolve("en_us.json").toFile())) {
                gson.toJson(map, writer);
            } catch (IOException e) {
                ModClient.LOGGER.error("[Item Descriptions] Failed to write missing descriptions file", e);
            }
        }
    }
}
