/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client;

import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class DescriptionKey {
    private final String namespace;
    private final String path;
    private final String type;
    private String suffix;

    public DescriptionKey(String type, String namespace, String path) {
        this.type = type;
        this.namespace = namespace;
        this.path = path;
        this.suffix = "";
    }

    public DescriptionKey(String type, String namespace, String path, String suffix) {
        this.type = type;
        this.namespace = namespace;
        this.path = path;
        this.suffix = suffix;
    }

    public DescriptionKey(class_2960 id) {
        this.type = "lore";
        this.namespace = id.method_12836();
        this.path = id.method_12832();
        this.suffix = "";
    }

    public DescriptionKey(String resourceLocation) {
        String[] id = resourceLocation.split("\\.");
        if (id.length > 2) {
            this.type = id[0];
            this.namespace = id[1];
            this.path = id[2];
        } else {
            this.type = id[0];
            this.namespace = "minecraft";
            this.path = id[1];
        }
        this.suffix = "";
    }

    public DescriptionKey(String type, class_2960 resourceLocation) {
        this.type = type;
        this.namespace = resourceLocation.method_12836();
        this.path = resourceLocation.method_12832();
        this.suffix = "";
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getNamespacePrecision() {
        return switch (this.namespace) {
            case "c", "forge" -> 0;
            case "minecraft" -> 1;
            case "item-descriptions", "item_descriptions" -> 3;
            default -> 2;
        };
    }

    public String getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setSafeSuffix(String suffix) {
        String oldSuffix = this.suffix;
        this.suffix = suffix;
        if (!this.hasTranslation()) {
            this.suffix = oldSuffix;
        }
    }

    public static DescriptionKey empty() {
        return new DescriptionKey("", "", "");
    }

    public DescriptionKey orElse(DescriptionKey other) {
        return this.isEmpty() ? other : this;
    }

    public static boolean isMorePrecise(DescriptionKey currentKey, DescriptionKey newKey) {
        if (currentKey.getNamespace().equals(newKey.getNamespace())) {
            return currentKey.toString().length() < newKey.toString().length();
        }
        return currentKey.getNamespacePrecision() < newKey.getNamespacePrecision();
    }

    public boolean isEmpty() {
        return this.type.isEmpty() && this.namespace.isEmpty() && this.path.isEmpty() && this.suffix.isEmpty();
    }

    public String combineDotSeperated(List<String> args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            if ((arg = ModHelpers.toTranslationKey(arg)).isEmpty()) continue;
            sb.append(".").append(arg);
        }
        return sb.toString().replaceFirst(".", "");
    }

    public String asDescriptionTranslation() {
        return this.combineDotSeperated(List.of(this.type, this.namespace, this.path, "description", this.suffix));
    }

    public String asDescTranslation() {
        return this.combineDotSeperated(List.of(this.type, this.namespace, this.path, "desc", this.suffix));
    }

    public String asLoreTranslation() {
        return this.combineDotSeperated(List.of("lore", this.namespace, this.path, this.suffix));
    }

    public String toString() {
        if (this.type.equals("tag") || ModHelpers.hasTranslation(this.asDescriptionTranslation())) {
            return this.asDescriptionTranslation();
        }
        if (this.type.equals("item") && ModHelpers.hasTranslation(this.asLoreTranslation())) {
            return this.asLoreTranslation();
        }
        if (!this.type.equals("item") && ModHelpers.hasTranslation(this.asDescTranslation())) {
            return this.asDescTranslation();
        }
        return this.asLoreTranslation();
    }

    public class_5250 toText() {
        String newAdd = this.toString();
        return ModHelpers.translatableWithFallback(newAdd, newAdd);
    }

    public boolean hasTranslation() {
        if (((Boolean)ModClient.CONFIG.developerOptions.showUntranslated.value()).booleanValue()) {
            return true;
        }
        return class_1074.method_4663((String)this.toString());
    }
}

