/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.forge;

import cc.cassian.item_descriptions.client.Platform;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import org.apache.commons.lang3.text.WordUtils;

public class ForgePlatformImpl
implements Platform {
    @Override
    public boolean isLoaded(String mod) {
        return ModList.get().isLoaded(mod);
    }

    @Override
    public boolean isLoadingLoaded(String mod) {
        return LoadingModList.get().getModFileById(mod) != null;
    }

    @Override
    public String loader() {
        return "forge";
    }

    @Override
    public File getMissingTranslationsPath() {
        Path savePath = FMLPaths.GAMEDIR.get().resolve("data").resolve("item-descriptions").resolve("missing");
        return savePath.toFile();
    }

    @Override
    public Path configPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public String getModName(ItemStack stack) {
        String namespace = "minecraft";
        if (Minecraft.m_91087_().f_91073_ != null) {
            namespace = stack.m_41720_().getCreatorModId(stack);
        }
        String key = "modmenu.nameTranslation." + namespace;
        Optional modContainer = ModList.get().getModContainerById(namespace);
        if (modContainer.isPresent()) {
            return ((ModContainer)modContainer.get()).getModInfo().getDisplayName();
        }
        if (I18n.m_118936_((String)key)) {
            return I18n.m_118938_((String)key, (Object[])new Object[0]);
        }
        return WordUtils.capitalize((String)namespace);
    }
}

