/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.forge;

import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.Platform;
import cc.cassian.item_descriptions.client.config.ModConfigFactory;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import cc.cassian.item_descriptions.client.helpers.ModLists;
import cc.cassian.item_descriptions.client.helpers.compat.UsefulSpyglassHelpers;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="item_descriptions")
public final class ItemDescriptionsForge {
    public ItemDescriptionsForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModClient.init();
        this.addTooltips();
        this.registerModsPage();
        eventBus.addListener(ItemDescriptionsForge::loadComplete);
        if (Platform.INSTANCE.isLoaded("usefulspyglass")) {
            MinecraftForge.EVENT_BUS.addListener(UsefulSpyglassHelpers::registerBlockEvent);
            MinecraftForge.EVENT_BUS.addListener(UsefulSpyglassHelpers::registerEntityEvent);
        }
    }

    @SubscribeEvent
    public static void loadComplete(FMLClientSetupEvent event) {
        ModLists.loadLists();
    }

    public void addTooltips() {
        MinecraftForge.EVENT_BUS.addListener(this::onItemTooltipEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onItemTooltipEventLowestPriority);
    }

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        ModHelpers.createDescriptionsFromItemStack(event.getItemStack(), event.getToolTip());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemTooltipEventLowestPriority(ItemTooltipEvent event) {
        ModHelpers.fixItemStackDescriptionTooltip(event.getItemStack(), event.getToolTip());
    }

    public void registerModsPage() {
        if (ModList.get().isLoaded("cloth_config") && !ModClient.CONFIG.developerOptions.configScreen.equals((Object)"yacl")) {
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> ModConfigFactory.createScreen(mc, screen, "cloth-config")));
        } else if (ModList.get().isLoaded("yet_another_config_lib_v3")) {
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> ModConfigFactory.createScreen(mc, screen, "yacl")));
        }
    }
}

