package cc.cassian.item_descriptions.client.helpers;

import cc.cassian.item_descriptions.client.DescriptionKey;
import cc.cassian.item_descriptions.client.ModClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_6862;

import static cc.cassian.item_descriptions.client.helpers.ModHelpers.*;

public class TagHelpers {

    private static boolean checkMatch(DescriptionKey[] currentKey, DescriptionKey newKey) {
        return newKey.hasTranslation() && (currentKey[0] == null || DescriptionKey.isMorePrecise(currentKey[0], newKey));
    }

    public static DescriptionKey checkGenericTagList(class_1799 stack) {
        if (ModClient.CONFIG.developerOptions.disableTagDescriptions.value()) return DescriptionKey.empty();
        final class_1792 item = stack.method_7909();
        //Temporary - Spawn Eggs do not yet have a tag.
        if (item instanceof class_1826 spawnEggItem) {
            if (ModClient.CONFIG.spawnEggsShowEntity.value()) {
                //? if >1.21.1 && <=1.21.8 {
                /*var level = Minecraft.getInstance().level;
                if (level == null)
                    return new DescriptionKey("tag", "c", "spawn_egg");
                *///?}
                class_1299<?> entityType = spawnEggItem.method_8015(
                        //? if >1.21.8 {
                        stack
                         //?} else if >1.21.1 {
                        /*level.registryAccess(), stack
                        *///?} else if >1.20.1 {
                        /*stack
                         *///?} else {
                        /*stack.getTag()
                         *///?}
                );
                var key = ModHelpers.getDescriptionKey(entityType);
                if (key.hasTranslation()) return key;
            }
            return new DescriptionKey("tag", "c", "spawn_egg");
        }
        final DescriptionKey[] returnedKey = new DescriptionKey[1];
        stack.method_40133().forEach(itemTagKey -> {
            DescriptionKey loreKey = tagKeyToGenericKey(itemTagKey);
            if (checkMatch(returnedKey, loreKey)) {
                returnedKey[0] = loreKey;
            }
        });
        // If untagged, check if it is a Block Item and if a Block Tag matches.
        if (returnedKey[0] == null) {
            if ((item instanceof class_1747 blockItem)) {
                blockItem.method_7711().method_9564().method_40144().forEach(itemTagKey -> {
                    DescriptionKey loreKey = tagKeyToGenericKey(itemTagKey);
                    if (checkMatch(returnedKey, loreKey)) {
                        returnedKey[0] = loreKey;
                    }
                });
            }
        }
        return Objects.requireNonNullElse(returnedKey[0], DescriptionKey.empty());
    }

    public static DescriptionKey checkGenericTagList(class_2680 state) {
        final DescriptionKey[] returnedKey = new DescriptionKey[1];
        state.method_40144().forEach(tagKey -> {
            DescriptionKey loreKey = tagKeyToGenericKey(tagKey);
            if (checkMatch(returnedKey, loreKey)) {
                returnedKey[0] = loreKey;
            }
        });
        return Objects.requireNonNullElse(returnedKey[0], DescriptionKey.empty());
    }

    public static DescriptionKey checkGenericTagList(class_2248 block) {
        return checkGenericTagList(block.method_9564());
    }

    public static DescriptionKey checkGenericTagList(class_1297 entity) {
        return checkGenericTagList(entity.method_5864());
    }

    public static DescriptionKey checkGenericTagList(class_1299<?> type) {
        final DescriptionKey[] returnedKey = new DescriptionKey[1];
        type.method_40124().method_40228().forEach(tagKey -> {
            DescriptionKey loreKey = tagKeyToGenericKey(tagKey);
            if (checkMatch(returnedKey, loreKey)) {
                returnedKey[0] = loreKey;
            }
        });
        return Objects.requireNonNullElse(returnedKey[0], DescriptionKey.empty());
    }

    private static void addSafe(ArrayList<class_2561> tags, DescriptionKey newAdd) {
        class_2561 newText;
        if (
        //? if >1.21.8 {
        class_310.method_1551()
        //?} else {
        /*Screen
        *///?}
        .method_74189())
            newText = newAdd.toText();
        else {
            newText = class_2561.method_43470(newAdd.toString());
        }
        if (!tags.contains(newText))
            tags.add(newText);
    }

    public static List<class_2561> findAllPotentialKeys(class_1799 itemStack) {
        ArrayList<class_2561> tags = new ArrayList<>(); // Create an ArrayList object
        addSafe(tags, ModHelpers.findLoreKey(itemStack));
        addSafe(tags, getDescriptionKey(itemStack));
        addSafe(tags, getModdedNameMatch(itemStack));
        final class_1792 item = itemStack.method_7909();
        //Temporary - Spawn Eggs do not yet have a tag.
        if (item instanceof class_1826) {
            addSafe(tags, new DescriptionKey("tag", "c", "spawn_egg"));
        }
        itemStack.method_40133().forEach(itemTagKey -> {
            DescriptionKey loreKey = tagKeyToGenericKey(itemTagKey);
            addSafe(tags, loreKey);
        });
        // If untagged, check if it is a Block Item and if a Block Tag matches.
        if ((item instanceof class_1747 blockItem)) {
            blockItem.method_7711().method_9564().method_40144().forEach(itemTagKey -> {
                DescriptionKey loreKey = tagKeyToGenericKey(itemTagKey);
                addSafe(tags, loreKey);
            });
        }
        return tags;
    }

    public static List<class_2561> findAllPotentialKeys(class_2680 state) {
        ArrayList<class_2561> tags = new ArrayList<>(); // Create an ArrayList object
        addSafe(tags, getDescriptionKey(state));
        addSafe(tags, findLoreKey(state));
        state.method_40144().forEach(itemTagKey -> {
            DescriptionKey loreKey = tagKeyToGenericKey(itemTagKey);
            addSafe(tags, loreKey);
        });
        return tags;
    }

    public static List<class_2561> findAllPotentialKeys(class_2248 block) {
        return findAllPotentialKeys(block.method_9564());
    }

    public static List<class_2561> findAllPotentialKeys(class_1297 entity) {
        return findAllPotentialKeys(entity.method_5864());
    }

    public static List<class_2561> findAllPotentialKeys(class_1299<?> type) {
        ArrayList<class_2561> tags = new ArrayList<>(); // Create an ArrayList object
        addSafe(tags, getDescriptionKey(type));
        addSafe(tags, findLoreKey(type));
        type.method_40124().method_40228().forEach(itemTagKey -> {
            DescriptionKey loreKey = tagKeyToGenericKey(itemTagKey);
            addSafe(tags, loreKey);
        });
        return tags;
    }

    public static List<class_2561> findAllPotentialKeys(class_1887 enchantment) {
        ArrayList<class_2561> tags = new ArrayList<>(); // Create an ArrayList object
        addSafe(tags, getDescriptionKey(enchantment));
        return tags;
    }

    public static List<class_2561> findAllPotentialKeys(class_1291 mobEffect) {
        ArrayList<class_2561> tags = new ArrayList<>(); // Create an ArrayList object
        addSafe(tags, getDescriptionKey(mobEffect));
        return tags;
    }

    /**
     * Convert a TagKey into a translation key.
     */
    private static DescriptionKey tagKeyToGenericKey(class_6862<?> key) {
        return new DescriptionKey("tag", key.comp_327());
    }
}
