package cc.cassian.item_descriptions.client.limelight;

//? if fabric {
//? if 1.21.1 || 1.21.5 {
import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import io.wispforest.limelight.api.entry.InvokeResultEntry;
import io.wispforest.limelight.api.extension.LimelightExtension;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

import static cc.cassian.item_descriptions.client.helpers.ModHelpers.*;

public class DescriptionsResultEntry implements InvokeResultEntry {
    class_2561 searchKey;

    public DescriptionsResultEntry(String s) {
        super();
        searchKey = findTranslationKey(s);
    }

    public static class_2561 createMultilineTranslation(String loreKey) {
        // Setup list to store (potentially multi-line) tooltip.
        StringBuilder lines = new StringBuilder();
        //Check if the key exists.
        if (!loreKey.isEmpty()) {
            // Translate the lore key.
            String translatedKey = class_1074.method_4662(loreKey);
            // Check if the translated key exists.
            if (hasTranslation(loreKey)) {
                // Add the final tooltip.
                lines.append(translatedKey);
            }
        }
        return class_2561.method_43470(String.valueOf(lines));
    }

    private class_2561 findTranslationKey(String s) {
        String lowerS = s.toLowerCase();
        // Take in user input, remove the #, and remove any spaces.
        String trimmedS = lowerS.replace(" ", "_");
        // Set up a default namespace and item, in case namespace isn't specified, e.g. minecraft:user_input
        String namespace = "minecraft";
        String item = trimmedS;
        // If a namespace is provided, change the namespace, e.g. user:input
        if (trimmedS.contains(":")) {
            String[] splitS = trimmedS.split(":");
            namespace = splitS[0];
            item = splitS[1];
        }
        //Check to see if that namespaced ResourceLocation matches an item. If so, return that item's lore key.
        if (ModClient.CONFIG.itemDescriptions.value()) {
            var itemStack = createMultilineTranslation(findLoreKey(class_7923.field_41178
                    //? if >=1.21.2 {
                    /*.getValue
                     *///?} else {
                    .method_10223
                    //?}
                    (ModHelpers.of(namespace, item)).method_7854()).toString());
            if (!Objects.requireNonNull(itemStack.method_54160()).isEmpty()) return itemStack;
        }
        //Check to see if that namespaced ResourceLocation matches a mob. If so, return that item's lore key.
        //This seems to return a Pig if it isn't matched correctly, so that is ignored if "pig" isn't actually typed in.
        if (ModClient.CONFIG.entityDescriptions.enable.value()) {
            var mobRegistry = class_7923.field_41177
                    //? if >=1.21.2 {
                    /*.getValue
                     *///?} else {
                    .method_10223
                    //?}
                    (ModHelpers.of(namespace, item)).method_5882();
            if (Objects.equals(mobRegistry, "entity.minecraft.pig") ) {
                if (item.equals("pig")) return createMultilineTranslation(convertToLoreKey(mobRegistry).toString());
            }
            else
                return createMultilineTranslation(convertToLoreKey(mobRegistry).toString());
        }
        // If a namespace match is not found, iterate through block and item registries for a name match.
        if (ModClient.CONFIG.itemDescriptions.value()) {
            class_2561 itemRegistry = iterateRegistry(class_7923.field_41178, lowerS);
            if (itemRegistry != null)
                return itemRegistry;
        }
        if (ModClient.CONFIG.blockDescriptions.enable.value()) {
            class_2561 blockRegistry = iterateRegistry(class_7923.field_41175, lowerS);
            if (blockRegistry != null)
                return blockRegistry;
        }
        //If no match is found, return an empty string.
        return class_2561.method_43470("");


    }

    public class_2561 iterateRegistry(class_7922<?> registries, String lowerS) {
        final class_2561[] returnedKey = new class_2561[1];
        registries.method_10220().forEach(registryEntry -> {
            String registryKey;
            if (registryEntry instanceof class_2248 block) {
                registryKey = block.method_9539();
            }
            else if (registryEntry instanceof class_1792 item) {
                registryKey = item.method_7876();
            }
            else return;
            if (lowerS.equals(class_1074.method_4662(registryKey).toLowerCase())) {
                returnedKey[0] = createMultilineTranslation(convertToLoreKey(registryKey).toString());
            }
        });
        return returnedKey[0];
    }

    @Override
    public void run() {
        class_310.method_1551().field_1774.method_1455(searchKey.getString());
    }

    @Override
    public boolean closesScreen() {
        return false; //
    }

    public LimelightExtension extension() {
        return DescriptionsExtension.INSTANCE;
    }

    public String entryId() {
        return "item-descriptions:item_descriptions";
    }

    @Override
    public class_2561 text() {
        return searchKey;
    }
}
//?}
//?}