/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.config;

import cc.cassian.item_descriptions.client.config.ModConfig;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClothConfigFactory {
    private static final ModConfig DEFAULT_VALUES = new ModConfig();

    private static ConfigCategory createCategory(String section, ConfigBuilder builder) {
        section = section == null ? "" : (String)section + "_";
        return builder.getOrCreateCategory((Component)Component.translatable((String)"config.item-descriptions.%stitle".formatted(section)));
    }

    private static boolean is(Field field, String name) {
        return field.getName().toLowerCase(Locale.ROOT).contains(name);
    }

    public static Screen create(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.translatable((String)"modmenu.nameTranslation.item-descriptions"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ModConfig configInstance = ModConfig.get();
        ConfigCategory generalCategory = ClothConfigFactory.createCategory(null, builder);
        ConfigCategory styleCategory = ClothConfigFactory.createCategory("style", builder);
        ConfigCategory enchantmentCategory = ClothConfigFactory.createCategory("enchantment_descriptions", builder);
        ConfigCategory effectCategory = ClothConfigFactory.createCategory("effect_descriptions", builder);
        ConfigCategory pluginsCategory = ClothConfigFactory.createCategory("plugins", builder);
        ConfigCategory hintCategory = ClothConfigFactory.createCategory("hint", builder);
        ConfigCategory keyBindsCategory = ClothConfigFactory.createCategory("keybinds", builder);
        ConfigCategory developerCategory = ClothConfigFactory.createCategory("developer_options", builder);
        for (Field field : ModConfig.class.getFields()) {
            ConfigCategory category = ClothConfigFactory.is(field, "keybind_") ? keyBindsCategory : (ClothConfigFactory.is(field, "block") ? pluginsCategory : (ClothConfigFactory.is(field, "entitydescriptions") ? pluginsCategory : (ClothConfigFactory.is(field, "developer") ? developerCategory : (ClothConfigFactory.is(field, "style") ? styleCategory : (ClothConfigFactory.is(field, "hint_") ? hintCategory : (ClothConfigFactory.is(field, "enchantment") ? enchantmentCategory : (ClothConfigFactory.is(field, "effect") ? effectCategory : generalCategory)))))));
            if (field.getType() == Boolean.TYPE) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ModHelpers.fieldName(field), ((Boolean)ModHelpers.fieldGet(configInstance, field)).booleanValue()).setSaveConsumer(ModHelpers.fieldSetter(configInstance, field)).setTooltip(ModHelpers.fieldTooltip(field)).setDefaultValue(((Boolean)ModHelpers.fieldGet(DEFAULT_VALUES, field)).booleanValue()).build());
                continue;
            }
            if (field.getType() == String.class) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startStrField(ModHelpers.fieldName(field), (String)ModHelpers.fieldGet(configInstance, field)).setSaveConsumer(ModHelpers.fieldSetter(configInstance, field)).setTooltip(ModHelpers.fieldTooltip(field)).setDefaultValue((String)ModHelpers.fieldGet(DEFAULT_VALUES, field)).build());
                continue;
            }
            if (field.getType() == Integer.TYPE) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startIntField(ModHelpers.fieldName(field), ((Integer)ModHelpers.fieldGet(configInstance, field)).intValue()).setSaveConsumer(ModHelpers.fieldSetter(configInstance, field)).setTooltip(ModHelpers.fieldTooltip(field)).setDefaultValue(((Integer)ModHelpers.fieldGet(DEFAULT_VALUES, field)).intValue()).build());
                continue;
            }
            if (field.getType() != List.class) continue;
            category.addEntry((AbstractConfigListEntry)entryBuilder.startStrList(ModHelpers.fieldName(field), (List)ModHelpers.fieldGet(configInstance, field)).setSaveConsumer(ModHelpers.fieldSetter(configInstance, field)).setTooltip(ModHelpers.fieldTooltip(field)).setDefaultValue((List)ModHelpers.fieldGet(DEFAULT_VALUES, field)).build());
        }
        builder.setSavingRunnable(ModConfig::save);
        return builder.build();
    }
}

