/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.config;

import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.config.neoforge.ModConfigImpl;
import cc.cassian.item_descriptions.client.helpers.ModLists;
import cc.cassian.item_descriptions.client.helpers.ModStyle;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static ModConfig INSTANCE = new ModConfig();
    public boolean itemDescriptions = true;
    public boolean displayAlways = false;
    public boolean spawnEggsShowEntity = true;
    public boolean showModName = false;
    public boolean hint_enabled = false;
    public boolean hint_showKeybind = true;
    public String hint_color = "Gray";
    public boolean hint_italics = false;
    public String style_color = "Gray";
    public boolean style_italics = false;
    public boolean style_bold = false;
    public int style_length = 160;
    public String style_modNameColor = "Blue";
    public boolean keybind_displayWhenControlIsHeld = true;
    public boolean keybind_displayWhenShiftIsHeld = false;
    public boolean keybind_displayWhenAltIsHeld = false;
    public boolean keybind_invert = false;
    public boolean blockDescriptions = true;
    public boolean displayBlockDescriptionsAlways = false;
    public boolean entityDescriptions = true;
    public boolean displayEntityDescriptionsAlways = false;
    public boolean enchantmentDescriptions = true;
    public boolean displayEnchantmentDescriptionsAlways = false;
    public boolean displayEnchantmentDescriptionsOnlyOnBooks = false;
    public String enchantmentDescriptions_color = "Dark Gray";
    public boolean enchantmentDescriptions_italics = false;
    public boolean developer_showAllPotentialKeys = false;
    public List<String> developer_items_with_tooltips_to_hide = List.of("");
    public boolean developer_showUntranslated = false;
    public boolean developer_disableTagDescriptions = false;
    public boolean developer_forceEnableEnchantmentDescriptions = false;
    public boolean developer_generateMissing = false;
    public boolean effectDescriptions = true;
    public boolean display_effect_descriptions_always = false;
    public String effect_descriptions_color = "Dark Gray";
    public boolean display_effect_descriptions_only = false;
    public boolean developer_force_enable_effect_descriptions = false;
    public boolean developer_hide_other_tooltips = false;

    public static void load() {
        if (!Files.exists(ModConfig.configPath(), new LinkOption[0])) {
            ModConfig.save();
            return;
        }
        try (InputStream input = Files.newInputStream(ModConfig.configPath(), new OpenOption[0]);){
            INSTANCE = (ModConfig)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), ModConfig.class);
        }
        catch (IOException e) {
            ModClient.LOGGER.warn("Unable to load config file!");
        }
    }

    public static void save() {
        try (OutputStream output = Files.newOutputStream(ModConfig.configPath(), new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            ModClient.LOGGER.warn("Unable to save config file!");
        }
        ModLists.loadLists();
        ModStyle.updateStyles();
    }

    public static ModConfig get() {
        if (INSTANCE == null) {
            INSTANCE = new ModConfig();
        }
        return INSTANCE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    static Path configPath() {
        return ModConfigImpl.configPath();
    }
}

