/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.helpers;

import cc.cassian.item_descriptions.client.DescriptionKey;
import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.compat.EmiCompat;
import cc.cassian.item_descriptions.client.config.ModConfig;
import cc.cassian.item_descriptions.client.helpers.ModLists;
import cc.cassian.item_descriptions.client.helpers.ModStyle;
import cc.cassian.item_descriptions.client.helpers.TagHelpers;
import cc.cassian.item_descriptions.client.helpers.compat.FastItemFramesHelpers;
import cc.cassian.item_descriptions.client.helpers.compat.GlowcaseHelpers;
import cc.cassian.item_descriptions.client.helpers.compat.PolymerHelpers;
import cc.cassian.item_descriptions.client.helpers.neoforge.ModHelpersImpl;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public class ModHelpers {
    public static final ResourceLocation FABRIC_EVENT_PHASE = ResourceLocation.fromNamespaceAndPath((String)"item-descriptions", (String)"description_tooltip");
    private static int lineTextWidth = 0;
    private static boolean shouldIndent = false;
    private static Component indentationText = null;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean clothConfigInstalled() {
        return ModHelpersImpl.clothConfigInstalled();
    }

    public static boolean useInternalWrapper() {
        return true;
    }

    public static boolean useInternalEnchantmentDescriptions() {
        if (ModConfig.get().developer_forceEnableEnchantmentDescriptions) {
            return true;
        }
        return !ModHelpers.isLoaded("idwtialsimmoedm") && !ModHelpers.isLoaded("enchdesc");
    }

    public static boolean useInternalEffectDescriptions() {
        if (ModConfig.get().developer_force_enable_effect_descriptions) {
            return true;
        }
        return !ModHelpers.isLoaded("potiondescriptions") && !ModHelpers.isLoaded("effectdescriptions");
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isLoaded(String mod) {
        return ModHelpersImpl.isLoaded(mod);
    }

    public static Style getStyle(String colour) {
        return Style.EMPTY.withColor(ModHelpers.getColour(colour)).withItalic(Boolean.valueOf(ModConfig.get().style_italics)).withBold(Boolean.valueOf(ModConfig.get().style_bold));
    }

    public static Component getHintText() {
        StringBuilder sb = new StringBuilder();
        ModConfig config = ModConfig.get();
        boolean shift = config.keybind_displayWhenShiftIsHeld;
        boolean ctrl = config.keybind_displayWhenControlIsHeld;
        boolean alt = config.keybind_displayWhenAltIsHeld;
        if (config.hint_showKeybind) {
            if (ctrl) {
                sb.append(I18n.get((String)"key.keyboard.ctrl", (Object[])new Object[0]));
                if (shift || alt) {
                    sb.append("/");
                }
            }
            if (alt) {
                sb.append(I18n.get((String)"key.keyboard.alt", (Object[])new Object[0]));
                if (shift) {
                    sb.append("/");
                }
            }
            if (shift) {
                sb.append(I18n.get((String)"key.keyboard.shift", (Object[])new Object[0]));
            }
            sb.append(": ");
        }
        if (config.keybind_invert) {
            sb.append(I18n.get((String)"hint.item-descriptions.hint_inverted", (Object[])new Object[0]));
        } else {
            sb.append(I18n.get((String)"hint.item-descriptions.hint", (Object[])new Object[0]));
        }
        return Component.nullToEmpty((String)sb.toString());
    }

    public static TextColor getColour(String colour) {
        int length = colour.length();
        if (length == 1) {
            return TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByCode((char)colour.charAt(0)));
        }
        try {
            return TextColor.fromRgb((int)Integer.parseInt(colour));
        }
        catch (NumberFormatException numberFormatException) {
            String replacedColour;
            return switch (replacedColour = colour.toLowerCase().replace(" ", "_")) {
                case "black", "dark_blue", "dark_green", "dark_red", "dark_purple", "blue", "green", "aqua", "red", "yellow", "white" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)colour));
                case "pink", "light_purple" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"light_purple"));
                case "dark_gray", "dark_grey" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"dark_gray"));
                case "cyan", "dark_aqua" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"dark_aqua"));
                case "orange", "gold", "dark_yellow" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"gold"));
                default -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"gray"));
            };
        }
    }

    public static int getIndex(String translatedKey, int maxLength) {
        String subKey = translatedKey.substring(0, maxLength);
        int index = subKey.contains(" ") ? subKey.lastIndexOf(" ") : maxLength;
        return index;
    }

    public static boolean tooltipKeyPressed() {
        if (ModConfig.get().keybind_displayWhenControlIsHeld && Screen.hasControlDown()) {
            return ModHelpers.checkKey(Screen.hasControlDown());
        }
        if (ModConfig.get().keybind_displayWhenShiftIsHeld && Screen.hasShiftDown()) {
            return ModHelpers.checkKey(Screen.hasShiftDown());
        }
        if (ModConfig.get().keybind_displayWhenAltIsHeld && Screen.hasAltDown()) {
            return ModHelpers.checkKey(Screen.hasAltDown());
        }
        return false;
    }

    public static boolean checkKey(boolean key) {
        boolean invert = ModConfig.get().keybind_invert;
        if (key) {
            return !invert;
        }
        if (!key) {
            return invert;
        }
        return false;
    }

    public static DescriptionKey findItemLoreKey(ItemStack stack) {
        DescriptionKey name;
        DescriptionKey profileKey;
        if (PolymerHelpers.getServerIdentifier(stack) != null) {
            return new DescriptionKey(PolymerHelpers.getServerIdentifier(stack));
        }
        if (ModHelpers.hasComponent(stack, DataComponents.CUSTOM_MODEL_DATA)) {
            data = Objects.requireNonNull((CustomModelData)stack.getComponents().get(DataComponents.CUSTOM_MODEL_DATA));
            String dataValue = data.getString(0);
            DescriptionKey modelKey = ModHelpers.getLoreKey(stack);
            modelKey.setSuffix(".custommodeldata." + dataValue);
            if (modelKey.hasTranslation()) {
                return modelKey;
            }
        } else if (stack.is(Items.PAINTING) && ModHelpers.hasComponent(stack, DataComponents.ENTITY_DATA)) {
            data = Objects.requireNonNull((CustomData)stack.getComponents().get(DataComponents.ENTITY_DATA));
            String variant = ModHelpers.toTranslationKey(data.copyTag().getString("variant"));
            DescriptionKey paintingKey = new DescriptionKey("lore", "minecraft", "painting", variant);
            if (paintingKey.hasTranslation() || ModConfig.get().developer_showAllPotentialKeys) {
                return paintingKey;
            }
        } else if (ModHelpers.hasComponent(stack, DataComponents.PROFILE) && (profileKey = ModHelpers.getProfile(stack)).hasTranslation()) {
            return profileKey;
        }
        if ((name = ModHelpers.getModdedNameMatch(stack)).hasTranslation()) {
            return name;
        }
        return ModHelpers.checkLoreKey(ModHelpers.getLoreKey(stack));
    }

    public static DescriptionKey getModdedNameMatch(ItemStack stack) {
        DescriptionKey key = ModHelpers.getDescriptionKey(stack);
        key.setSuffix(ModHelpers.toTranslationKey(stack.getItem().getName(stack).getString()));
        return key;
    }

    public static String toTranslationKey(String string) {
        return string.toLowerCase().replaceAll("\"", "").replaceAll(" ", "_").replaceAll("[/:]", ".");
    }

    public static boolean hasTranslation(String key) {
        if (ModConfig.get().developer_showUntranslated) {
            return true;
        }
        return I18n.exists((String)key);
    }

    public static DescriptionKey createBlockDescription(Block block, Level world, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        ItemStack contents;
        DescriptionKey profileKey;
        DescriptionKey loreKey = ModHelpers.findBlockLoreKey(block);
        if (ModHelpers.isLoaded("polymer-bundled") && PolymerHelpers.isPolymerBlock(pos)) {
            loreKey = new DescriptionKey(PolymerHelpers.findPolymerBlockIdentifier(pos));
        }
        if (blockEntity instanceof SkullBlockEntity && (profileKey = ModHelpers.getProfile(blockEntity, loreKey)).hasTranslation()) {
            return profileKey;
        }
        if (ModHelpers.isLoaded("fastitemframes") && FastItemFramesHelpers.isFastItemFrame(blockEntity) && (contents = FastItemFramesHelpers.getFastItemFrameContents(blockEntity)) != null) {
            return ModHelpers.findItemLoreKey(contents);
        }
        if (ModHelpers.isLoaded("glowcase") && GlowcaseHelpers.isItemDisplay(blockEntity) && (contents = GlowcaseHelpers.getItemDisplayContents(blockEntity)) != null) {
            return ModHelpers.findItemLoreKey(contents);
        }
        if (!loreKey.hasTranslation()) {
            return ModHelpers.findItemLoreKey(block.defaultBlockState().getCloneItemStack((LevelReader)world, pos, true));
        }
        return loreKey;
    }

    public static List<Component> createEntityDescription(Entity entity) {
        DescriptionKey loreKey;
        Painting painting;
        ItemFrame itemFrameEntity;
        Component name = entity.getName();
        if (entity instanceof ItemFrame && !(itemFrameEntity = (ItemFrame)entity).getItem().isEmpty()) {
            return ModHelpers.createTooltip(name, ModHelpers.findItemLoreKey(itemFrameEntity.getItem()));
        }
        if (entity instanceof Painting && (painting = (Painting)entity).getVariant().isBound() && (loreKey = new DescriptionKey("lore", "minecraft", "painting", ModHelpers.toTranslationKey(painting.getVariant().getRegisteredName()))).hasTranslation()) {
            return ModHelpers.createTooltip(name, loreKey);
        }
        return ModHelpers.createTooltip(name, ModHelpers.findEntityLoreKey(entity));
    }

    public static boolean createEnchantmentDescription(ItemStack stack, List<Component> lines) {
        boolean descriptionFound = false;
        if (ModConfig.get().enchantmentDescriptions && ModHelpers.showEnchantmentDescriptions()) {
            if (ModConfig.get().displayEnchantmentDescriptionsOnlyOnBooks && !stack.getItem().equals(Items.ENCHANTED_BOOK)) {
                return false;
            }
            HashSet enchantments = new HashSet(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).keySet());
            if (enchantments.isEmpty()) {
                return false;
            }
            for (Holder enchantmentEntry : enchantments) {
                Enchantment enchantment = (Enchantment)enchantmentEntry.value();
                for (int i = 0; i < lines.size(); ++i) {
                    ComponentContents description;
                    if (!lines.get(i).getContents().equals((Object)enchantment.description().getContents()) || !((description = lines.get(i).getContents()) instanceof TranslatableContents)) continue;
                    TranslatableContents translatableTextContent = (TranslatableContents)description;
                    DescriptionKey descriptionKey = new DescriptionKey(translatableTextContent.getKey());
                    lines.add(i + 1, (Component)descriptionKey.toText().setStyle(ModStyle.ENCHANTMENT_DESCRIPTIONS));
                }
            }
        }
        return descriptionFound;
    }

    private static boolean checkTranslatableText(Component text, Predicate<TranslatableContents> predicate) {
        TranslatableContents translatable;
        ComponentContents contents = null;
        if (text instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)text;
            if (mutable.getSiblings().stream().anyMatch(c -> ModHelpers.checkTranslatableText(c, predicate))) {
                return true;
            }
            contents = mutable.getContents();
        }
        if (contents == null) {
            return false;
        }
        return contents instanceof TranslatableContents && predicate.test(translatable = (TranslatableContents)contents);
    }

    public static void fixEnchantmentDescription(ItemStack stack, List<Component> lines) {
        if (ModConfig.get().enchantmentDescriptions && ModHelpers.useInternalEnchantmentDescriptions()) {
            if (ModConfig.get().displayEnchantmentDescriptionsOnlyOnBooks && !stack.getItem().equals(Items.ENCHANTED_BOOK)) {
                return;
            }
            HashSet<Object> enchantments = new HashSet<Object>(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).keySet());
            if (enchantments.isEmpty()) {
                return;
            }
            for (int i = 0; i < lines.size(); ++i) {
                List<Component> newLines;
                if (!ModHelpers.isEnchantmentDescription(lines.get(i), enchantments) || (newLines = ModHelpers.createTooltip(stack.getHoverName(), lines.get(i), ModHelpers.useInternalWrapper())).isEmpty()) continue;
                lines.set(i, newLines.get(0));
                if (newLines.size() <= 1) continue;
                lines.addAll(i + 1, newLines.subList(1, newLines.size()));
            }
        }
    }

    private static boolean isEnchantmentDescription(Component text, Set<Object> enchantments) {
        if (Minecraft.getInstance().level == null) {
            return false;
        }
        return ModHelpers.checkTranslatableText(text, content -> {
            String[] split = content.getKey().split("\\.");
            if (split.length < 3) {
                return false;
            }
            String namespace = split[1];
            String path = split[2];
            if (ModHelpers.hasTranslation(content.getKey()) && (split.length == 4 && split[0].equals("enchantment") && (split[3].equals("description") || split[3].equals("desc")) || split.length == 3 && split[0].equals("lore"))) {
                return enchantments.stream().anyMatch(entry -> ((Holder)entry).is(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path)));
            }
            return false;
        });
    }

    public static List<Component> createEffectDescription(List<Component> text) {
        ArrayList<Component> lines = new ArrayList<Component>(text);
        if (ModConfig.get().effectDescriptions) {
            for (Component text1 : text) {
                TranslatableContents translatableTextContent;
                ComponentContents componentContents = text1.getContents();
                if (!(componentContents instanceof TranslatableContents) || (translatableTextContent = (TranslatableContents)componentContents).getKey().startsWith("effect.duration")) continue;
                DescriptionKey key = new DescriptionKey(translatableTextContent.getKey());
                List<Component> tooltip = ModHelpers.createTooltip(text1, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
                if (ModHelpers.showEffectDescriptions()) {
                    lines.addAll(tooltip);
                    continue;
                }
                if (!ModConfig.get().hint_enabled || !key.hasTranslation()) continue;
                ModHelpers.addHint(lines);
            }
        }
        return lines;
    }

    public static void createEffectDescription(Component name, Consumer<Component> textConsumer, MobEffectInstance statusEffectInstance) {
        if (ModConfig.get().effectDescriptions && ModHelpers.showEffectDescriptions()) {
            DescriptionKey key = new DescriptionKey(statusEffectInstance.getDescriptionId());
            List<Component> tooltip = ModHelpers.createTooltip(name, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
            if (ModHelpers.showEffectDescriptions()) {
                for (Component line : tooltip) {
                    textConsumer.accept(line);
                }
            }
        }
    }

    public static void createEffectDescription(Component name, List<Component> textConsumer, MobEffectInstance statusEffectInstance) {
        if (ModConfig.get().effectDescriptions && ModHelpers.showEffectDescriptions()) {
            DescriptionKey key = new DescriptionKey(statusEffectInstance.getDescriptionId());
            List<Component> tooltip = ModHelpers.createTooltip(name, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
            if (ModHelpers.showEffectDescriptions()) {
                textConsumer.addAll(tooltip);
            }
        }
    }

    public static void addHint(List<Component> lines) {
        lines.add(1, (Component)ModHelpers.getHintText().toFlatList(ModStyle.HINT).get(0));
    }

    public static boolean createItemDescription(ItemStack stack, List<Component> lines) {
        if (ModConfig.get().itemDescriptions) {
            List<Component> tooltip;
            DescriptionKey descriptionKey = ModHelpers.findItemLoreKey(stack);
            if (ModConfig.get().developer_showAllPotentialKeys) {
                tooltip = TagHelpers.findAllPotentialKeys(stack);
            } else if (descriptionKey.hasTranslation()) {
                tooltip = List.of(descriptionKey.toText());
            } else {
                return false;
            }
            tooltip = tooltip.stream().map(text -> text.copy().setStyle(ModStyle.ITEM_DESCRIPTIONS)).toList();
            if (ModHelpers.showItemDescriptions()) {
                lines.addAll(tooltip);
            } else {
                return descriptionKey.hasTranslation();
            }
        }
        return false;
    }

    public static void fixItemDescription(ItemStack stack, List<Component> lines) {
        if (ModConfig.get().itemDescriptions && ModHelpers.showItemDescriptions()) {
            DescriptionKey descriptionKey = ModHelpers.findItemLoreKey(stack);
            List<Object> tooltip = ModConfig.get().developer_showAllPotentialKeys ? TagHelpers.findAllPotentialKeys(stack) : List.of(descriptionKey.toText());
            for (int i = 0; i < lines.size(); ++i) {
                int finalI = i;
                if (!tooltip.stream().anyMatch(text -> text.getContents().equals((Object)((Component)lines.get(finalI)).getContents()))) continue;
                List<Component> newLines = ModHelpers.createTooltip(stack.getHoverName(), lines.get(i), ModHelpers.useInternalWrapper());
                lines.set(i, newLines.get(0));
                if (newLines.size() <= 1) continue;
                lines.addAll(i + 1, newLines.subList(1, newLines.size()));
            }
        }
    }

    public static boolean hasComponent(ItemStack stack, DataComponentType<?> type) {
        return stack.getComponents().has(type);
    }

    public static DescriptionKey getProfile(ItemStack stack) {
        String optionalProfileName = Objects.requireNonNull(Objects.requireNonNull((ResolvableProfile)stack.getComponents().get(DataComponents.PROFILE)).name()).orElse("");
        if (!optionalProfileName.isEmpty()) {
            DescriptionKey profileKey = ModHelpers.getLoreKey(stack);
            profileKey.setSuffix("profile." + optionalProfileName);
            if (profileKey.hasTranslation()) {
                return profileKey;
            }
        }
        return DescriptionKey.empty();
    }

    public static DescriptionKey getProfile(BlockEntity blockEntity, DescriptionKey loreKey) {
        String optionalProfileName;
        try {
            optionalProfileName = Objects.requireNonNull(((SkullBlockEntity)blockEntity).getOwnerProfile()).name().orElse("");
        }
        catch (NullPointerException nullPointerException) {
            return loreKey;
        }
        loreKey.setSuffix("profile." + optionalProfileName);
        return loreKey;
    }

    public static boolean showBlockDescriptions() {
        return ModConfig.get().blockDescriptions && (ModHelpers.tooltipKeyPressed() || ModConfig.get().displayBlockDescriptionsAlways);
    }

    public static boolean showItemDescriptions() {
        return ModConfig.get().itemDescriptions && (ModHelpers.tooltipKeyPressed() || ModConfig.get().displayAlways);
    }

    public static boolean showEnchantmentDescriptions() {
        return ModConfig.get().enchantmentDescriptions && ModHelpers.useInternalEnchantmentDescriptions() && (ModHelpers.tooltipKeyPressed() || ModConfig.get().displayEnchantmentDescriptionsAlways);
    }

    public static boolean showEntityDescriptions() {
        return ModConfig.get().entityDescriptions && (ModHelpers.tooltipKeyPressed() || ModConfig.get().displayEntityDescriptionsAlways);
    }

    public static boolean showEffectDescriptions() {
        return ModConfig.get().effectDescriptions && ModHelpers.useInternalEffectDescriptions() && (ModHelpers.tooltipKeyPressed() || ModConfig.get().display_effect_descriptions_always);
    }

    public static void createDescriptionsFromItemStack(ItemStack stack, List<Component> lines) {
        if (ModConfig.get().developer_hide_other_tooltips || ModLists.hidden_items.contains(stack.getItem())) {
            Component first = lines.get(0);
            lines.clear();
            lines.add(first);
        }
        boolean enchant = ModHelpers.createEnchantmentDescription(stack, lines);
        boolean effect = ModHelpers.checkForEffectDescription(stack);
        if (ModConfig.get().display_effect_descriptions_only && effect) {
            return;
        }
        boolean item = ModHelpers.createItemDescription(stack, lines);
        if (ModConfig.get().hint_enabled && (item || enchant)) {
            ModHelpers.addHint(lines);
        }
        if ((ModHelpers.tooltipKeyPressed() || ModConfig.get().displayAlways) && ModConfig.get().showModName) {
            DefaultedRegistry registry = BuiltInRegistries.ITEM;
            ResourceLocation id = registry.getKey((Object)stack.getItem());
            String namespace = id.getNamespace();
            String key = "modmenu.nameTranslation." + namespace;
            MutableComponent text = I18n.exists((String)key) ? Component.translatable((String)key) : (ModHelpers.isLoaded("emi") ? Component.literal((String)EmiCompat.getModName(namespace)) : Component.literal((String)WordUtils.capitalize((String)namespace)));
            lines.add((Component)text.toFlatList(ModStyle.MOD_NAME).get(0));
        }
    }

    public static MutableComponent translatableWithFallback(String translatable, String fallback) {
        return Component.translatableWithFallback((String)translatable, (String)fallback);
    }

    private static boolean checkForEffectDescription(ItemStack stack) {
        if (stack.getComponents().has(DataComponents.POTION_CONTENTS)) {
            PotionContents contents = (PotionContents)stack.getComponents().get(DataComponents.POTION_CONTENTS);
            if (contents == null) {
                return false;
            }
            for (MobEffectInstance effect : contents.getAllEffects()) {
                DescriptionKey key = new DescriptionKey(effect.getDescriptionId());
                if (!key.hasTranslation()) continue;
                return true;
            }
        }
        return false;
    }

    public static void fixItemStackDescriptionTooltip(ItemStack stack, List<Component> lines) {
        if (!ModHelpers.useInternalWrapper()) {
            return;
        }
        ModHelpers.fixEnchantmentDescription(stack, lines);
        if (ModHelpers.useInternalWrapper()) {
            ModHelpers.fixItemDescription(stack, lines);
        }
    }

    public static String getProfileName(Optional<String> optionalProfileName) {
        if (optionalProfileName.isPresent()) {
            String profileName = optionalProfileName.get();
            return profileName;
        }
        return "";
    }

    public static String getProfileName(String optionalProfileName) {
        return optionalProfileName;
    }

    public static DescriptionKey findBlockLoreKey(Block block) {
        return ModHelpers.checkLoreKey(ModHelpers.getLoreKey(block));
    }

    public static DescriptionKey findEntityLoreKey(Entity entity) {
        return ModHelpers.checkLoreKey(ModHelpers.getLoreKey(entity));
    }

    public static DescriptionKey checkLoreKey(DescriptionKey loreKey) {
        if (loreKey.hasTranslation()) {
            return loreKey;
        }
        return DescriptionKey.empty();
    }

    @NotNull
    private static DescriptionKey getLoreKey(Object object) {
        @NotNull DescriptionKey key = ModHelpers.getDescriptionKey(object);
        if (key.hasTranslation()) {
            return key;
        }
        return TagHelpers.getGenericKey(object);
    }

    @NotNull
    public static DescriptionKey convertToLoreKey(String translationKey) {
        DescriptionKey loreKey;
        if (translationKey.contains("block.")) {
            loreKey = new DescriptionKey(translationKey);
        } else if (translationKey.contains("item.")) {
            loreKey = new DescriptionKey(translationKey);
        } else if (translationKey.contains("entity.")) {
            loreKey = new DescriptionKey(translationKey);
            if (translationKey.contains("tropical_fish")) {
                loreKey = new DescriptionKey("entity", "minecraft", "tropical_fish");
            } else if (loreKey.hasTranslation()) {
                return loreKey;
            }
        } else {
            return DescriptionKey.empty();
        }
        return loreKey;
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(Object object) {
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            return ModHelpers.convertToLoreKey(stack.getItem().getDescriptionId());
        }
        if (object instanceof BlockState) {
            BlockState blockState = (BlockState)object;
            return ModHelpers.convertToLoreKey(blockState.getBlock().getDescriptionId());
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            return ModHelpers.convertToLoreKey(block.getDescriptionId());
        }
        if (object instanceof EntityType) {
            EntityType entityType = (EntityType)object;
            return ModHelpers.convertToLoreKey(entityType.getDescriptionId());
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            return ModHelpers.convertToLoreKey(ModHelpers.getEntityTranslationKey(entity));
        }
        if (object instanceof MobEffect) {
            MobEffect effect = (MobEffect)object;
            return new DescriptionKey(effect.getDescriptionId());
        }
        if (object instanceof Enchantment) {
            Enchantment enchantment = (Enchantment)object;
            return ModHelpers.getEnchantmentDescriptionKey(enchantment);
        }
        return DescriptionKey.empty();
    }

    public static DescriptionKey getEnchantmentDescriptionKey(Enchantment enchantment) {
        DescriptionKey descriptionKey;
        ComponentContents componentContents = enchantment.description().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            descriptionKey = new DescriptionKey(translatable.getKey());
        } else {
            descriptionKey = DescriptionKey.empty();
        }
        return descriptionKey;
    }

    public static String getEntityTranslationKey(Entity entity) {
        if (entity.isAlwaysTicking()) {
            String playerKey = "entity.minecraft.player.%s".formatted(entity.getName().tryCollapseToString());
            if (ModHelpers.hasTranslation(playerKey)) {
                return playerKey;
            }
            return "entity.minecraft.player";
        }
        return entity.getType().getDescriptionId();
    }

    public static List<Component> createTooltip(Component name, DescriptionKey loreKey) {
        return ModHelpers.createTooltip(name, loreKey.toString(), true);
    }

    public static List<Component> createTooltip(Component name, String loreKey) {
        return ModHelpers.createTooltip(name, loreKey, true);
    }

    public static List<Component> createTooltip(Component name, String loreKey, boolean wrap) {
        return ModHelpers.createTooltip(name, loreKey, wrap, ModStyle.ITEM_DESCRIPTIONS);
    }

    public static List<Component> createTooltip(Component name, Component text, boolean wrap) {
        if (!wrap || text.getString().isEmpty()) {
            return List.of(text);
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        ModHelpers.wrapTooltip(name, lines, List.of(text));
        ModHelpers.resetWrapValues();
        return lines;
    }

    public static List<Component> createTooltip(Component name, String loreKey, boolean wrap, Style style) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (!loreKey.isBlank()) {
            String translatedKey = I18n.get((String)loreKey, (Object[])new Object[0]);
            if (ModHelpers.hasTranslation(loreKey)) {
                if (!wrap) {
                    if (!translatedKey.isBlank()) {
                        lines.add((Component)Component.translatable((String)loreKey).setStyle(style));
                    }
                } else {
                    ModHelpers.wrapTooltip(name, lines, List.of(Component.literal((String)translatedKey).setStyle(style)));
                    ModHelpers.resetWrapValues();
                }
            }
        }
        return lines;
    }

    private static void resetWrapValues() {
        lineTextWidth = 0;
        shouldIndent = true;
        indentationText = null;
    }

    private static void wrapTooltip(Component name, List<Component> lines, List<Component> keys) {
        Font textRenderer = Minecraft.getInstance().font;
        if (textRenderer != null && ModConfig.get().style_length != 0) {
            int maxLength = Math.max(ModConfig.get().style_length, textRenderer.width((FormattedText)name));
            for (Component originalText : keys) {
                MutableComponent translated = originalText.plainCopy().setStyle(originalText.getStyle());
                ComponentContents componentContents = translated.getContents();
                if (componentContents instanceof TranslatableContents) {
                    TranslatableContents translatable = (TranslatableContents)componentContents;
                    translated = Component.literal((String)I18n.get((String)translatable.getKey(), (Object[])new Object[0])).setStyle(translated.getStyle());
                }
                if (shouldIndent && translated.getString().isBlank() && !translated.getString().isEmpty()) {
                    indentationText = originalText.plainCopy();
                    ModHelpers.wrapTooltip(name, lines, originalText.getSiblings());
                    shouldIndent = false;
                    continue;
                }
                shouldIndent = false;
                while (lineTextWidth + textRenderer.width((FormattedText)translated) >= maxLength && translated.getString().contains(" ")) {
                    lineTextWidth = 0;
                    translated = ModHelpers.createNewLine(lines, (Component)translated, textRenderer, maxLength);
                }
                if (!translated.getString().isEmpty()) {
                    if (!lines.isEmpty() && lines.size() > 1 && textRenderer.width((FormattedText)lines.get(lines.size() - 1)) + textRenderer.width((FormattedText)translated) < maxLength && translated.getString().contains(" ")) {
                        Component oldText = lines.remove(lines.size() - 1);
                        MutableComponent newText = oldText.copy().append((Component)translated);
                        ModHelpers.createNewLine(lines, (Component)newText, textRenderer, maxLength);
                        lineTextWidth = 0;
                    } else {
                        lineTextWidth = textRenderer.width((FormattedText)translated);
                        ModHelpers.createNewLine(lines, (Component)translated, textRenderer, maxLength);
                    }
                }
                ModHelpers.wrapTooltip(name, lines, originalText.getSiblings());
            }
        }
    }

    private static Component createNewLine(List<Component> lines, Component text, Font textRenderer, int maxLength) {
        int lineLength = text.getString().length();
        while (text.getString().substring(0, lineLength).contains(" ") && textRenderer.width((FormattedText)Component.nullToEmpty((String)text.getString().substring(0, lineLength))) >= maxLength) {
            lineLength = ModHelpers.getIndex(text.getString(), lineLength);
        }
        Component newLine = ModHelpers.subText(text, 0, lineLength);
        if (indentationText != null) {
            newLine = indentationText.copy().append(newLine);
        }
        lines.add(newLine);
        return ModHelpers.subText(text, lineLength + 1);
    }

    private static Component subText(Component text, int beginIndex) {
        return ModHelpers.subText(text, beginIndex, text.getString().length());
    }

    private static Component subText(Component text, int beginIndex, int endIndex) {
        return ModHelpers.subText(text, beginIndex, endIndex, 0);
    }

    private static Component subText(Component text, int beginIndex, int endIndex, int currentIndex) {
        MutableComponent mutable = text.plainCopy();
        if (beginIndex > mutable.getString().length()) {
            beginIndex -= mutable.getString().length();
            currentIndex += mutable.getString().length();
        } else {
            String string = mutable.getString();
            string = string.substring(beginIndex, Math.min(endIndex - currentIndex, string.length()));
            mutable = Component.literal((String)string).setStyle(text.getStyle());
            currentIndex += string.length();
        }
        if (currentIndex >= endIndex) {
            return mutable;
        }
        for (Component sibling : text.getSiblings()) {
            if (currentIndex >= endIndex) break;
            Component subTextSibling = ModHelpers.subText(sibling, beginIndex, endIndex, currentIndex);
            currentIndex += subTextSibling.getString().length();
            mutable.append(subTextSibling);
        }
        return mutable;
    }

    public static Component fieldName(Field field) {
        return Component.translatable((String)"config.%s.config.%s".formatted("item-descriptions", field.getName()));
    }

    public static Component[] fieldTooltip(Field field) {
        String tooltipKey = "config.%s.config.%s.tooltip".formatted("item-descriptions", field.getName());
        return ModHelpers.createTooltip((Component)Component.empty(), tooltipKey).toArray(new Component[0]);
    }

    public static <T> T fieldGet(Object instance, Field field) {
        try {
            return (T)field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Consumer<T> fieldSetter(Object instance, Field field) {
        return t -> {
            try {
                field.set(instance, t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isLoadingLoaded(String mod) {
        return ModHelpersImpl.isLoadingLoaded(mod);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static File getMissingTranslationsPath() {
        return ModHelpersImpl.getMissingTranslationsPath();
    }

    private static <T> void addMissingTranslations(Registry<T> registry, Map<String, Map<String, String>> namespaces, Function<T, ?> valueTransform) {
        for (ResourceKey key : registry.registryKeySet()) {
            Object value = valueTransform.apply(registry.getValue(key));
            DescriptionKey description = ModHelpers.getDescriptionKey(value);
            ArrayList<String> keys = new ArrayList<String>(TagHelpers.findAllPotentialKeys(value).stream().map(Component::getString).toList());
            if (description.isEmpty()) {
                ModClient.LOGGER.warn("[Item Descriptions] Couldn't get lore key for {}: {}!", (Object)registry.key().location(), (Object)key.location());
                continue;
            }
            if (!keys.stream().noneMatch(I18n::exists)) continue;
            keys.remove(description.asLoreTranslation());
            if (value instanceof ItemStack) {
                ItemStack stack = (ItemStack)value;
                keys.remove(ModHelpers.getModdedNameMatch(stack).asLoreTranslation());
            }
            namespaces.computeIfAbsent(key.location().getNamespace(), k -> new TreeMap()).put(description.asDescriptionTranslation(), " ??? %s".formatted(String.join((CharSequence)", ", keys)));
        }
    }

    public static void generateMissingTranslations(RegistryGetter registryGetter) {
        ModClient.LOGGER.info("[Item Descriptions] Creating missing translations files");
        File folder = ModHelpers.getMissingTranslationsPath();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap<String, Map<String, String>> namespaces = new HashMap<String, Map<String, String>>();
        ModHelpers.addMissingTranslations(registryGetter.get(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entity_type"))).orElse(null), namespaces, Function.identity());
        ModHelpers.addMissingTranslations(registryGetter.get(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"item"))).orElse(null), namespaces, Item::getDefaultInstance);
        ModHelpers.addMissingTranslations(registryGetter.get(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"enchantment"))).orElse(null), namespaces, Function.identity());
        ModHelpers.addMissingTranslations(registryGetter.get(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block"))).orElse(null), namespaces, Block::defaultBlockState);
        ModHelpers.addMissingTranslations(registryGetter.get(ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"mob_effect"))).orElse(null), namespaces, Function.identity());
        for (Map.Entry entry : namespaces.entrySet()) {
            String namespace = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            Path namespacePath = folder.toPath().resolve("assets").resolve(namespace).resolve("lang");
            namespacePath.toFile().mkdirs();
            try (FileWriter writer = new FileWriter(namespacePath.resolve("en_us.json").toFile());){
                gson.toJson((Object)map, (Appendable)writer);
            }
            catch (IOException e) {
                ModClient.LOGGER.error("[Item Descriptions] Failed to write missing descriptions file", (Throwable)e);
            }
        }
    }

    public static interface RegistryGetter {
        public <E> Optional<? extends Registry<E>> get(ResourceKey<? extends Registry<? extends E>> var1);
    }
}

