/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.helpers;

import cc.cassian.item_descriptions.client.DescriptionKey;
import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.config.ModConfig;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.state.BlockState;

public class TagHelpers {
    private static boolean checkMatch(DescriptionKey[] currentKey, DescriptionKey newKey) {
        return newKey.hasTranslation() && (currentKey[0] == null || DescriptionKey.isMorePrecise(currentKey[0], newKey));
    }

    private static DescriptionKey checkGenericTagList(Object object) {
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            Item item = itemStack.getItem();
            if (item instanceof SpawnEggItem) {
                EntityType entityType;
                DescriptionKey key;
                SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                if (ModConfig.get().spawnEggsShowEntity && (key = ModHelpers.getDescriptionKey(entityType = spawnEggItem.getType((HolderLookup.Provider)ModClient.lookup, itemStack))).hasTranslation()) {
                    return key;
                }
                return new DescriptionKey("tag", "c", "spawn_egg");
            }
            DescriptionKey[] returnedKey = new DescriptionKey[1];
            itemStack.getTags().forEach(itemTagKey -> {
                DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                    returnedKey[0] = loreKey;
                }
            });
            if (returnedKey[0] == null && item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                blockItem.getBlock().defaultBlockState().getTags().forEach(itemTagKey -> {
                    DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                    if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                        returnedKey[0] = loreKey;
                    }
                });
            }
            return returnedKey[0];
        }
        if (object instanceof BlockState) {
            BlockState state = (BlockState)object;
            DescriptionKey[] returnedKey = new DescriptionKey[1];
            state.getTags().forEach(itemTagKey -> {
                DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                    returnedKey[0] = loreKey;
                }
            });
            return returnedKey[0];
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            DescriptionKey[] returnedKey = new DescriptionKey[1];
            entity.getType().builtInRegistryHolder().tags().forEach(itemTagKey -> {
                DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                    returnedKey[0] = loreKey;
                }
            });
            return returnedKey[0];
        }
        return DescriptionKey.empty();
    }

    private static void addSafe(ArrayList<Component> tags, DescriptionKey newAdd) {
        MutableComponent newText = Screen.hasAltDown() ? newAdd.toText() : Component.literal((String)newAdd.toString());
        if (!tags.contains(newText)) {
            tags.add((Component)newText);
        }
    }

    public static List<Component> findAllPotentialKeys(Object object) {
        ArrayList<Component> tags = new ArrayList<Component>();
        Object object2 = Objects.requireNonNull(object);
        if (object2 instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object2;
            TagHelpers.addSafe(tags, ModHelpers.findItemLoreKey(itemStack));
            TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(itemStack));
            TagHelpers.addSafe(tags, ModHelpers.getModdedNameMatch(itemStack));
            Item item = itemStack.getItem();
            if (item instanceof SpawnEggItem) {
                TagHelpers.addSafe(tags, new DescriptionKey("tag", "c", "spawn_egg"));
            }
            itemStack.getTags().forEach(itemTagKey -> {
                DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                TagHelpers.addSafe(tags, loreKey);
            });
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                blockItem.getBlock().defaultBlockState().getTags().forEach(itemTagKey -> {
                    DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                    TagHelpers.addSafe(tags, loreKey);
                });
            }
        } else if (object instanceof BlockState) {
            BlockState state = (BlockState)object;
            state.getTags().forEach(itemTagKey -> {
                DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                TagHelpers.addSafe(tags, loreKey);
            });
        } else if (object instanceof Entity) {
            Entity entity = (Entity)object;
            entity.getType().builtInRegistryHolder().tags().forEach(itemTagKey -> {
                DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                TagHelpers.addSafe(tags, loreKey);
            });
        } else {
            tags.add((Component)Component.empty());
        }
        return tags;
    }

    private static DescriptionKey tagKeyToGenericKey(TagKey<?> key) {
        return new DescriptionKey("tag", key.location());
    }

    public static DescriptionKey getGenericKey(Object object) {
        DescriptionKey generic;
        if (!ModConfig.get().developer_disableTagDescriptions && (generic = TagHelpers.checkGenericTagList(object)) != null) {
            if (generic.isEmpty()) {
                return DescriptionKey.empty();
            }
            return generic;
        }
        return DescriptionKey.empty();
    }
}

