/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.helpers.compat;

import com.mojang.serialization.MapCodec;
import eu.pb4.polymer.core.api.client.ClientPolymerBlock;
import eu.pb4.polymer.core.impl.client.InternalClientRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class PolymerHelpers {
    private static final String POLYMC_STACK = "PolyMcOriginal";
    public static final String POLYMER_STACK = "$polymer:stack";
    public static final MapCodec<ResourceLocation> POLYMER_STACK_ID_CODEC = ResourceLocation.CODEC.fieldOf("id").fieldOf("$polymer:stack");
    private static final MapCodec<ResourceLocation> POLYMC_STACK_ID_CODEC = ResourceLocation.CODEC.fieldOf("id").fieldOf("PolyMcOriginal");

    public static ResourceLocation getServerIdentifier(ItemStack itemStack) {
        return PolymerHelpers.getServerIdentifier((CustomData)itemStack.get(DataComponents.CUSTOM_DATA));
    }

    public static ResourceLocation getServerIdentifier(CustomData nbtData) {
        if (nbtData == null) {
            return null;
        }
        ResourceLocation x = PolymerHelpers.getPolymerIdentifier(nbtData);
        if (x != null) {
            return x;
        }
        if (nbtData.contains(POLYMC_STACK)) {
            try {
                return nbtData.read(POLYMC_STACK_ID_CODEC).result().orElse(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static ResourceLocation getPolymerIdentifier(CustomData custom) {
        if (custom != null && custom.contains(POLYMER_STACK)) {
            try {
                return custom.read(POLYMER_STACK_ID_CODEC).result().orElse(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static ResourceLocation findPolymerBlockIdentifier(BlockPos pos) {
        ClientPolymerBlock.State block = InternalClientRegistry.getBlockAt((BlockPos)pos);
        return block.block().identifier();
    }

    public static boolean isPolymerBlock(BlockPos pos) {
        ClientPolymerBlock.State block = InternalClientRegistry.getBlockAt((BlockPos)pos);
        return block != ClientPolymerBlock.NONE_STATE;
    }
}

