/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.fabric;

import cc.cassian.item_descriptions.client.Platform;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;

public class FabricPlatformImpl
implements Platform {
    @Override
    public boolean isLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    @Override
    public String loader() {
        return "fabric";
    }

    @Override
    public boolean isLoadingLoaded(String mod) {
        return this.isLoaded(mod);
    }

    @Override
    public File getMissingTranslationsPath() {
        Path savePath = FabricLoader.getInstance().getGameDir().resolve("data").resolve("item-descriptions").resolve("missing");
        return savePath.toFile();
    }

    @Override
    public Path configPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public String getModName(ItemStack stack) {
        String namespace = stack.getCreatorNamespace();
        String key = "modmenu.nameTranslation." + namespace;
        Optional modContainer = FabricLoader.getInstance().getModContainer(namespace);
        if (modContainer.isPresent()) {
            return ((ModContainer)modContainer.get()).getMetadata().getName();
        }
        if (I18n.exists((String)key)) {
            return I18n.get((String)key, (Object[])new Object[0]);
        }
        return WordUtils.capitalize((String)namespace);
    }
}

