/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.helpers;

import cc.cassian.item_descriptions.client.DescriptionKey;
import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.Platform;
import cc.cassian.item_descriptions.client.config.ModConfig;
import cc.cassian.item_descriptions.client.helpers.ModLists;
import cc.cassian.item_descriptions.client.helpers.ModStyle;
import cc.cassian.item_descriptions.client.helpers.TagHelpers;
import cc.cassian.item_descriptions.client.helpers.compat.FastItemFramesHelpers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import folk.sisby.kaleido.lib.quiltconfig.api.values.TrackedValue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.painting.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ModHelpers {
    public static final Identifier FABRIC_EVENT_PHASE = ModHelpers.of("description_tooltip");
    private static int lineTextWidth = 0;
    private static boolean shouldIndent = false;
    private static Component indentationText = null;

    public static Identifier of(String path) {
        return ModHelpers.of("item-descriptions", path);
    }

    public static Identifier of(String namespace, String path) {
        return Identifier.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static boolean useInternalWrapper() {
        return !ModHelpers.isLoaded("tooltipfix");
    }

    public static boolean useInternalEnchantmentDescriptions() {
        if (((Boolean)ModClient.CONFIG.developerOptions.forceEnableEnchantmentDescriptions.value()).booleanValue()) {
            return true;
        }
        return !ModHelpers.isLoaded("idwtialsimmoedm") && !ModHelpers.isLoaded("enchdesc");
    }

    public static boolean useInternalEffectDescriptions() {
        if (((Boolean)ModClient.CONFIG.developerOptions.forceEnableEffectDescriptions.value()).booleanValue()) {
            return true;
        }
        return !ModHelpers.isLoaded("potiondescriptions") && !ModHelpers.isLoaded("effectdescriptions");
    }

    public static boolean isLoaded(String mod) {
        return Platform.INSTANCE.isLoaded(mod);
    }

    public static Style getStyle(String colour) {
        return Style.EMPTY.withColor(ModHelpers.getColour(colour)).withItalic((Boolean)ModClient.CONFIG.style.italics.value()).withBold((Boolean)ModClient.CONFIG.style.bold.getDefaultValue());
    }

    public static MutableComponent getHintText() {
        StringBuilder sb = new StringBuilder();
        ModConfig config = ModClient.CONFIG;
        Boolean shift = (Boolean)config.keybinds.displayWhenShiftIsHeld.value();
        Boolean ctrl = (Boolean)config.keybinds.displayWhenCtrlIsHeld.value();
        Boolean alt = (Boolean)config.keybinds.displayWhenAltIsHeld.value();
        if (((Boolean)config.hint.showKeybinds.value()).booleanValue()) {
            if (ctrl.booleanValue()) {
                String ctrlText = I18n.get((String)"key.keyboard.ctrl", (Object[])new Object[0]);
                if (((Boolean)ModClient.CONFIG.hint.uppercase.value()).booleanValue()) {
                    ctrlText = ctrlText.toUpperCase(Locale.ROOT);
                }
                sb.append(ctrlText);
                if (shift.booleanValue() || alt.booleanValue()) {
                    sb.append("/");
                }
            }
            if (alt.booleanValue()) {
                String altText = I18n.get((String)"key.keyboard.alt", (Object[])new Object[0]);
                if (((Boolean)ModClient.CONFIG.hint.uppercase.value()).booleanValue()) {
                    altText = altText.toUpperCase(Locale.ROOT);
                }
                sb.append(altText);
                if (shift.booleanValue()) {
                    sb.append("/");
                }
            }
            if (shift.booleanValue()) {
                String shiftText = I18n.get((String)"key.keyboard.shift", (Object[])new Object[0]);
                if (((Boolean)ModClient.CONFIG.hint.uppercase.value()).booleanValue()) {
                    shiftText = shiftText.toUpperCase(Locale.ROOT);
                }
                sb.append(shiftText);
            }
            sb.append(": ");
        }
        if (((Boolean)config.keybinds.invert.value()).booleanValue()) {
            sb.append(I18n.get((String)"hint.item-descriptions.hint_inverted", (Object[])new Object[0]));
        } else {
            sb.append(I18n.get((String)"hint.item-descriptions.hint", (Object[])new Object[0]));
        }
        return Component.literal((String)sb.toString());
    }

    public static TextColor getColour(String colour) {
        int length = colour.length();
        if (length == 1) {
            return TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByCode((char)colour.charAt(0)));
        }
        try {
            return TextColor.fromRgb((int)Integer.parseInt(colour));
        }
        catch (NumberFormatException numberFormatException) {
            String replacedColour;
            return switch (replacedColour = colour.toLowerCase().replace(" ", "_")) {
                case "black", "dark_blue", "dark_green", "dark_red", "dark_purple", "blue", "green", "aqua", "red", "yellow", "white" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)colour));
                case "pink", "light_purple" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"light_purple"));
                case "dark_gray", "dark_grey" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"dark_gray"));
                case "cyan", "dark_aqua" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"dark_aqua"));
                case "orange", "gold", "dark_yellow" -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"gold"));
                default -> TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.getByName((String)"gray"));
            };
        }
    }

    public static int getIndex(String translatedKey, int maxLength) {
        String subKey = translatedKey.substring(0, maxLength);
        int index = subKey.contains(" ") ? subKey.lastIndexOf(" ") : maxLength;
        return index;
    }

    public static boolean tooltipKeyPressed() {
        boolean ctrl = Minecraft.getInstance().hasControlDown();
        boolean alt = Minecraft.getInstance().hasAltDown();
        boolean shift = Minecraft.getInstance().hasShiftDown();
        if (((Boolean)ModClient.CONFIG.keybinds.displayWhenCtrlIsHeld.value()).booleanValue() && ctrl) {
            return ModHelpers.checkKey(ctrl);
        }
        if (((Boolean)ModClient.CONFIG.keybinds.displayWhenShiftIsHeld.value()).booleanValue() && shift) {
            return ModHelpers.checkKey(shift);
        }
        if (((Boolean)ModClient.CONFIG.keybinds.displayWhenAltIsHeld.value()).booleanValue() && alt) {
            return ModHelpers.checkKey(alt);
        }
        return false;
    }

    public static boolean checkKey(boolean key) {
        boolean invert = (Boolean)ModClient.CONFIG.keybinds.invert.value();
        if (key) {
            return !invert;
        }
        if (!key) {
            return invert;
        }
        return false;
    }

    public static DescriptionKey findLoreKey(ItemStack stack) {
        DescriptionKey name;
        DescriptionKey profileKey;
        if (((Boolean)ModClient.CONFIG.enchantmentDescriptions.onlyEnchantmentDescriptionsOnBooks.value()).booleanValue() && stack.is(Items.ENCHANTED_BOOK)) {
            return DescriptionKey.empty();
        }
        if (ModHelpers.hasComponent(stack, DataComponents.ITEM_MODEL)) {
            data = Objects.requireNonNull((Identifier)stack.getComponents().get(DataComponents.ITEM_MODEL));
            DescriptionKey modelKey = new DescriptionKey(data);
            if (modelKey.hasTranslation()) {
                return modelKey;
            }
        } else if (ModHelpers.hasComponent(stack, DataComponents.CUSTOM_MODEL_DATA)) {
            data = Objects.requireNonNull((CustomModelData)stack.getComponents().get(DataComponents.CUSTOM_MODEL_DATA));
            String dataValue = data.getString(0);
            DescriptionKey key = ModHelpers.getDescriptionKey(stack);
            DescriptionKey modelKey = key.hasTranslation() ? key : TagHelpers.checkGenericTagList(stack);
            modelKey.setSuffix(".custommodeldata." + dataValue);
            if (modelKey.hasTranslation()) {
                return modelKey;
            }
        } else if (stack.is(Items.PAINTING) && ModHelpers.hasComponent(stack, DataComponents.ENTITY_DATA)) {
            data = Objects.requireNonNull((TypedEntityData)stack.getComponents().get(DataComponents.ENTITY_DATA));
            String variant = ModHelpers.toTranslationKey(data.copyTagWithoutId().getStringOr("variant", ""));
            DescriptionKey paintingKey = new DescriptionKey("lore", "minecraft", "painting", variant);
            if (paintingKey.hasTranslation() || ((Boolean)ModClient.CONFIG.developerOptions.showAllPotentialKeys.value()).booleanValue()) {
                return paintingKey;
            }
        } else if (ModHelpers.hasComponent(stack, DataComponents.PROFILE) && (profileKey = ModHelpers.getProfile(stack)).hasTranslation()) {
            return profileKey;
        }
        if ((name = ModHelpers.getModdedNameMatch(stack)).hasTranslation()) {
            return name;
        }
        DescriptionKey key = ModHelpers.getDescriptionKey(stack);
        return ModHelpers.checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(stack));
    }

    public static DescriptionKey getModdedNameMatch(ItemStack stack) {
        DescriptionKey key = ModHelpers.getDescriptionKey(stack);
        key.setSuffix(ModHelpers.toTranslationKey(stack.getItem().getName(stack).getString()));
        return key;
    }

    public static String toTranslationKey(String string) {
        return string.toLowerCase().replaceAll("\"", "").replaceAll(" ", "_").replaceAll("[/:]", ".");
    }

    public static boolean hasTranslation(String key) {
        if (((Boolean)ModClient.CONFIG.developerOptions.showUntranslated.value()).booleanValue()) {
            return true;
        }
        return I18n.exists((String)key);
    }

    public static DescriptionKey createBlockDescription(Block block, Level world, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        ItemStack contents;
        DescriptionKey profileKey;
        DescriptionKey loreKey = ModHelpers.findLoreKey(block);
        if (blockEntity instanceof SkullBlockEntity && (profileKey = ModHelpers.getProfile(blockEntity, loreKey)).hasTranslation()) {
            return profileKey;
        }
        if (ModHelpers.isLoaded("fastitemframes") && FastItemFramesHelpers.isFastItemFrame(blockEntity) && (contents = FastItemFramesHelpers.getFastItemFrameContents(blockEntity)) != null) {
            return ModHelpers.findLoreKey(contents);
        }
        if (!loreKey.hasTranslation()) {
            if (pos == null) {
                return ModHelpers.findLoreKey(block.asItem().getDefaultInstance());
            }
            return ModHelpers.findLoreKey(state.getCloneItemStack((LevelReader)world, pos, true));
        }
        return loreKey;
    }

    public static List<Component> createEntityDescription(Entity entity) {
        DescriptionKey loreKey;
        Painting painting;
        ItemFrame itemFrameEntity;
        Component name = entity.getName();
        if (entity instanceof ItemFrame && !(itemFrameEntity = (ItemFrame)entity).getItem().isEmpty()) {
            return ModHelpers.createTooltip(name, ModHelpers.findLoreKey(itemFrameEntity.getItem()));
        }
        if (entity instanceof Painting && (painting = (Painting)entity).getVariant().isBound() && (loreKey = new DescriptionKey("lore", "minecraft", "painting", ModHelpers.toTranslationKey(painting.getVariant().getRegisteredName()))).hasTranslation()) {
            return ModHelpers.createTooltip(name, loreKey);
        }
        return ModHelpers.createTooltip(name, ModHelpers.findLoreKey(entity));
    }

    public static boolean createEnchantmentDescription(ItemStack stack, List<Component> lines) {
        boolean descriptionFound = false;
        if (((Boolean)ModClient.CONFIG.enchantmentDescriptions.enable.value()).booleanValue() && ModHelpers.showEnchantmentDescriptions()) {
            if (((Boolean)ModClient.CONFIG.enchantmentDescriptions.onlyShowOnBooks.value()).booleanValue() && !stack.getItem().equals(Items.ENCHANTED_BOOK)) {
                return false;
            }
            HashSet enchantments = new HashSet(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).keySet());
            if (enchantments.isEmpty()) {
                return false;
            }
            for (Holder enchantmentEntry : enchantments) {
                Enchantment enchantment = (Enchantment)enchantmentEntry.value();
                for (int i = 0; i < lines.size(); ++i) {
                    ComponentContents description;
                    if (!lines.get(i).getContents().equals((Object)enchantment.description().getContents()) || !((description = lines.get(i).getContents()) instanceof TranslatableContents)) continue;
                    TranslatableContents translatableTextContent = (TranslatableContents)description;
                    DescriptionKey descriptionKey = new DescriptionKey(translatableTextContent.getKey());
                    lines.add(i + 1, (Component)descriptionKey.toText().setStyle(ModStyle.ENCHANTMENT_DESCRIPTIONS));
                }
            }
        }
        return descriptionFound;
    }

    private static boolean checkTranslatableText(Component text, Predicate<TranslatableContents> predicate) {
        TranslatableContents translatable;
        ComponentContents contents = null;
        if (text instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)text;
            if (mutable.getSiblings().stream().anyMatch(c -> ModHelpers.checkTranslatableText(c, predicate))) {
                return true;
            }
            contents = mutable.getContents();
        }
        if (contents == null) {
            return false;
        }
        return contents instanceof TranslatableContents && predicate.test(translatable = (TranslatableContents)contents);
    }

    public static void fixEnchantmentDescription(ItemStack stack, List<Component> lines) {
        if (((Boolean)ModClient.CONFIG.enchantmentDescriptions.enable.value()).booleanValue() && ModHelpers.useInternalEnchantmentDescriptions()) {
            if (((Boolean)ModClient.CONFIG.enchantmentDescriptions.onlyShowOnBooks.value()).booleanValue() && !stack.getItem().equals(Items.ENCHANTED_BOOK)) {
                return;
            }
            HashSet<Object> enchantments = new HashSet<Object>(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).keySet());
            if (enchantments.isEmpty()) {
                return;
            }
            for (int i = 0; i < lines.size(); ++i) {
                List<Component> newLines;
                if (!ModHelpers.isEnchantmentDescription(lines.get(i), enchantments) || (newLines = ModHelpers.createTooltip(stack.getDisplayName(), lines.get(i), ModHelpers.useInternalWrapper())).isEmpty()) continue;
                lines.set(i, newLines.getFirst());
                if (newLines.size() <= 1) continue;
                lines.addAll(i + 1, newLines.subList(1, newLines.size()));
            }
        }
    }

    private static boolean isEnchantmentDescription(Component text, Set<Object> enchantments) {
        if (Minecraft.getInstance().level == null) {
            return false;
        }
        return ModHelpers.checkTranslatableText(text, content -> {
            String[] split = content.getKey().split("\\.");
            if (split.length < 3) {
                return false;
            }
            String namespace = split[1];
            String path = split[2];
            if (ModHelpers.hasTranslation(content.getKey()) && (split.length == 4 && split[0].equals("enchantment") && (split[3].equals("description") || split[3].equals("desc")) || split.length == 3 && split[0].equals("lore"))) {
                return enchantments.stream().anyMatch(entry -> ((Holder)entry).is(ModHelpers.of(namespace, path)));
            }
            return false;
        });
    }

    public static List<Component> createEffectDescription(List<Component> text) {
        ArrayList<Component> lines = new ArrayList<Component>(text);
        if (((Boolean)ModClient.CONFIG.effectDescriptions.enable.value()).booleanValue()) {
            for (Component text1 : text) {
                TranslatableContents translatableTextContent;
                ComponentContents componentContents = text1.getContents();
                if (!(componentContents instanceof TranslatableContents) || (translatableTextContent = (TranslatableContents)componentContents).getKey().startsWith("effect.duration")) continue;
                DescriptionKey key = new DescriptionKey(translatableTextContent.getKey());
                List<Component> tooltip = ModHelpers.createTooltip(text1, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
                if (ModHelpers.showEffectDescriptions()) {
                    lines.addAll(tooltip);
                    continue;
                }
                if (!((Boolean)ModClient.CONFIG.hint.enabled.value()).booleanValue() || !key.hasTranslation()) continue;
                ModHelpers.addHint(lines);
            }
        }
        return lines;
    }

    public static void createEffectDescription(Component name, Consumer<Component> textConsumer, MobEffectInstance statusEffectInstance) {
        if (((Boolean)ModClient.CONFIG.effectDescriptions.enable.value()).booleanValue() && ModHelpers.showEffectDescriptions()) {
            DescriptionKey key = new DescriptionKey(statusEffectInstance.getDescriptionId());
            List<Component> tooltip = ModHelpers.createTooltip(name, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
            if (ModHelpers.showEffectDescriptions()) {
                for (Component line : tooltip) {
                    textConsumer.accept(line);
                }
            }
        }
    }

    public static void createEffectDescription(Component name, List<Component> textConsumer, MobEffectInstance statusEffectInstance) {
        if (((Boolean)ModClient.CONFIG.effectDescriptions.enable.value()).booleanValue() && ModHelpers.showEffectDescriptions()) {
            DescriptionKey key = new DescriptionKey(statusEffectInstance.getDescriptionId());
            List<Component> tooltip = ModHelpers.createTooltip(name, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
            if (ModHelpers.showEffectDescriptions()) {
                textConsumer.addAll(tooltip);
            }
        }
    }

    public static void addHint(List<Component> lines) {
        lines.add(1, (Component)ModHelpers.getHintText().setStyle(ModStyle.HINT));
    }

    public static boolean createItemDescription(ItemStack stack, List<Component> lines) {
        if (((Boolean)ModClient.CONFIG.itemDescriptions.value()).booleanValue()) {
            List<Component> tooltip;
            DescriptionKey descriptionKey = ModHelpers.findLoreKey(stack);
            if (((Boolean)ModClient.CONFIG.developerOptions.showAllPotentialKeys.value()).booleanValue()) {
                tooltip = TagHelpers.findAllPotentialKeys(stack);
            } else {
                if (descriptionKey.hasEmptyTranslation()) {
                    return false;
                }
                if (descriptionKey.hasTranslation()) {
                    tooltip = List.of(descriptionKey.toText());
                } else {
                    return false;
                }
            }
            if (ModHelpers.showItemDescriptions()) {
                tooltip = tooltip.stream().map(text -> text.copy().setStyle(ModStyle.ITEM_DESCRIPTIONS)).toList();
                lines.addAll(1, tooltip);
            } else {
                return descriptionKey.hasTranslation();
            }
        }
        return false;
    }

    public static void fixItemDescription(ItemStack stack, List<Component> lines) {
        if (((Boolean)ModClient.CONFIG.itemDescriptions.value()).booleanValue() && ModHelpers.showItemDescriptions()) {
            DescriptionKey descriptionKey = ModHelpers.findLoreKey(stack);
            List<Object> tooltip = (Boolean)ModClient.CONFIG.developerOptions.showAllPotentialKeys.value() != false ? TagHelpers.findAllPotentialKeys(stack) : List.of(descriptionKey.toText());
            for (int i = 0; i < lines.size(); ++i) {
                int finalI = i;
                if (!tooltip.stream().anyMatch(text -> text.getContents().equals((Object)((Component)lines.get(finalI)).getContents()))) continue;
                List<Component> newLines = ModHelpers.createTooltip(stack.getDisplayName(), lines.get(i), ModHelpers.useInternalWrapper());
                lines.set(i, newLines.getFirst());
                if (newLines.size() <= 1) continue;
                lines.addAll(i + 1, newLines.subList(1, newLines.size()));
            }
        }
    }

    public static boolean hasComponent(ItemStack stack, DataComponentType<?> type) {
        return stack.getComponents().has(type);
    }

    public static DescriptionKey getProfile(ItemStack stack) {
        String optionalProfileName = Objects.requireNonNull(Objects.requireNonNull((ResolvableProfile)stack.getComponents().get(DataComponents.PROFILE)).name()).orElse("");
        if (!optionalProfileName.isEmpty()) {
            DescriptionKey key = ModHelpers.getDescriptionKey(stack);
            DescriptionKey profileKey = key.hasTranslation() ? key : TagHelpers.checkGenericTagList(stack);
            profileKey.setSuffix("profile." + optionalProfileName);
            if (profileKey.hasTranslation()) {
                return profileKey;
            }
        }
        return DescriptionKey.empty();
    }

    public static DescriptionKey getProfile(BlockEntity blockEntity, DescriptionKey loreKey) {
        String optionalProfileName;
        try {
            optionalProfileName = Objects.requireNonNull(((SkullBlockEntity)blockEntity).getOwnerProfile()).name().orElse("");
        }
        catch (NullPointerException nullPointerException) {
            return loreKey;
        }
        loreKey.setSuffix("profile." + optionalProfileName);
        return loreKey;
    }

    public static boolean showBlockDescriptions() {
        return (Boolean)ModClient.CONFIG.blockDescriptions.enable.value() != false && (ModHelpers.tooltipKeyPressed() || (Boolean)ModClient.CONFIG.blockDescriptions.showAlways.value() != false);
    }

    public static boolean showItemDescriptions() {
        return (Boolean)ModClient.CONFIG.itemDescriptions.value() != false && (ModHelpers.tooltipKeyPressed() || (Boolean)ModClient.CONFIG.displayAlways.value() != false);
    }

    public static boolean showEnchantmentDescriptions() {
        return (Boolean)ModClient.CONFIG.enchantmentDescriptions.enable.value() != false && ModHelpers.useInternalEnchantmentDescriptions() && (ModHelpers.tooltipKeyPressed() || (Boolean)ModClient.CONFIG.enchantmentDescriptions.displayAlways.value() != false);
    }

    public static boolean showEntityDescriptions() {
        return (Boolean)ModClient.CONFIG.entityDescriptions.enable.value() != false && (ModHelpers.tooltipKeyPressed() || (Boolean)ModClient.CONFIG.entityDescriptions.showAlways.value() != false);
    }

    public static boolean showEffectDescriptions() {
        return (Boolean)ModClient.CONFIG.effectDescriptions.enable.value() != false && ModHelpers.useInternalEffectDescriptions() && (ModHelpers.tooltipKeyPressed() || (Boolean)ModClient.CONFIG.effectDescriptions.displayAlways.value() != false);
    }

    public static void createDescriptionsFromItemStack(ItemStack stack, Item.TooltipContext context, TooltipFlag type, List<Component> lines) {
        if (((Boolean)ModClient.CONFIG.developerOptions.hideOtherTooltips.value()).booleanValue() || ModLists.hidden_items.contains(stack.getItem())) {
            Component first = lines.getFirst();
            lines.clear();
            lines.add(first);
        }
        boolean enchant = ModHelpers.createEnchantmentDescription(stack, lines);
        boolean effect = ModHelpers.checkForEffectDescription(stack);
        if (((Boolean)ModClient.CONFIG.effectDescriptions.onlyShowEffectDescriptions.value()).booleanValue() && effect) {
            return;
        }
        boolean item = ModHelpers.createItemDescription(stack, lines);
        if (((Boolean)ModClient.CONFIG.hint.enabled.value()).booleanValue() && (item || enchant)) {
            ModHelpers.addHint(lines);
        }
        if ((ModHelpers.tooltipKeyPressed() || ((Boolean)ModClient.CONFIG.displayAlways.value()).booleanValue()) && ((Boolean)ModClient.CONFIG.showModName.value()).booleanValue()) {
            ModHelpers.addModName(stack, lines);
        }
    }

    private static void addModName(ItemStack stack, List<Component> lines) {
        String namespace = Platform.INSTANCE.getModName(stack);
        MutableComponent text = Component.literal((String)namespace);
        lines.add((Component)text.setStyle(ModStyle.MOD_NAME));
    }

    public static String getModName(ItemStack stack) {
        return Platform.INSTANCE.getModName(stack);
    }

    public static MutableComponent translatableWithFallback(String translatable, String fallback) {
        return Component.translatableWithFallback((String)translatable, (String)fallback);
    }

    private static boolean checkForEffectDescription(ItemStack stack) {
        if (ModHelpers.hasComponent(stack, DataComponents.POTION_CONTENTS)) {
            PotionContents contents = (PotionContents)stack.getComponents().get(DataComponents.POTION_CONTENTS);
            if (contents == null) {
                return false;
            }
            for (MobEffectInstance effect : contents.getAllEffects()) {
                DescriptionKey key = new DescriptionKey(effect.getDescriptionId());
                if (!key.hasTranslation()) continue;
                return true;
            }
        }
        return false;
    }

    public static void fixItemStackDescriptionTooltip(ItemStack stack, Item.TooltipContext context, TooltipFlag type, List<Component> lines) {
        if (!ModHelpers.useInternalWrapper()) {
            return;
        }
        ModHelpers.fixEnchantmentDescription(stack, lines);
        if (ModHelpers.useInternalWrapper()) {
            ModHelpers.fixItemDescription(stack, lines);
        }
    }

    public static String getProfileName(Optional<String> optionalProfileName) {
        if (optionalProfileName.isPresent()) {
            String profileName = optionalProfileName.get();
            return profileName;
        }
        return "";
    }

    public static DescriptionKey findLoreKey(Block block) {
        DescriptionKey key = ModHelpers.getDescriptionKey(block);
        return ModHelpers.checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(block));
    }

    public static DescriptionKey findLoreKey(BlockState state) {
        DescriptionKey key = ModHelpers.getDescriptionKey(state);
        return ModHelpers.checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(state));
    }

    public static DescriptionKey findLoreKey(Entity entity) {
        return ModHelpers.findLoreKey(entity.getType());
    }

    public static DescriptionKey findLoreKey(EntityType<?> entity) {
        DescriptionKey key = ModHelpers.getDescriptionKey(entity);
        return ModHelpers.checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(entity));
    }

    public static DescriptionKey checkLoreKey(DescriptionKey loreKey) {
        if (loreKey != null && loreKey.hasTranslation()) {
            return loreKey;
        }
        return DescriptionKey.empty();
    }

    @NotNull
    public static DescriptionKey convertToLoreKey(String translationKey) {
        DescriptionKey loreKey;
        if (translationKey.contains("block.")) {
            loreKey = new DescriptionKey(translationKey);
        } else if (translationKey.contains("item.")) {
            loreKey = new DescriptionKey(translationKey);
        } else if (translationKey.contains("entity.")) {
            loreKey = new DescriptionKey(translationKey);
            if (translationKey.contains("tropical_fish")) {
                loreKey = new DescriptionKey("entity", "minecraft", "tropical_fish");
            } else if (loreKey.hasTranslation()) {
                return loreKey;
            }
        } else {
            return DescriptionKey.empty();
        }
        return loreKey;
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(ItemStack stack) {
        return ModHelpers.getDescriptionKey(stack.getItem());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(Item item) {
        return ModHelpers.convertToLoreKey(item.getDescriptionId());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(BlockState blockState) {
        return ModHelpers.getDescriptionKey(blockState.getBlock());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(Block block) {
        return ModHelpers.convertToLoreKey(block.getDescriptionId());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(EntityType<?> entityType) {
        return ModHelpers.convertToLoreKey(entityType.getDescriptionId());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(Entity entity) {
        return ModHelpers.convertToLoreKey(ModHelpers.getEntityTranslationKey(entity));
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(MobEffect effect) {
        return new DescriptionKey(effect.getDescriptionId());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(Enchantment enchantment) {
        return ModHelpers.getEnchantmentDescriptionKey(enchantment);
    }

    public static DescriptionKey getEnchantmentDescriptionKey(Enchantment enchantment) {
        DescriptionKey descriptionKey;
        ComponentContents componentContents = enchantment.description().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            descriptionKey = new DescriptionKey(translatable.getKey());
        } else {
            descriptionKey = DescriptionKey.empty();
        }
        return descriptionKey;
    }

    public static String getEntityTranslationKey(Entity entity) {
        if (entity instanceof Player) {
            String playerKey = "entity.minecraft.player.%s".formatted(entity.getName().tryCollapseToString());
            if (ModHelpers.hasTranslation(playerKey)) {
                return playerKey;
            }
            return "entity.minecraft.player";
        }
        return entity.getType().getDescriptionId();
    }

    public static List<Component> createTooltip(Component name, DescriptionKey loreKey) {
        return ModHelpers.createTooltip(name, loreKey.toString(), true);
    }

    public static List<Component> createTooltip(Component name, String loreKey) {
        return ModHelpers.createTooltip(name, loreKey, true);
    }

    public static List<Component> createTooltip(Component name, String loreKey, boolean wrap) {
        return ModHelpers.createTooltip(name, loreKey, wrap, ModStyle.ITEM_DESCRIPTIONS);
    }

    public static List<Component> createTooltip(Component name, Component text, boolean wrap) {
        if (!wrap || text.getString().isEmpty()) {
            return List.of(text);
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        ModHelpers.wrapTooltip(name, lines, List.of(text));
        ModHelpers.resetWrapValues();
        return lines;
    }

    public static List<Component> createTooltip(Component name, String loreKey, boolean wrap, Style style) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (!loreKey.isBlank()) {
            String translatedKey = I18n.get((String)loreKey, (Object[])new Object[0]);
            if (ModHelpers.hasTranslation(loreKey)) {
                if (!wrap) {
                    if (!translatedKey.isBlank()) {
                        lines.add((Component)Component.translatable((String)loreKey).setStyle(style));
                    }
                } else {
                    ModHelpers.wrapTooltip(name, lines, List.of(Component.literal((String)translatedKey).setStyle(style)));
                    ModHelpers.resetWrapValues();
                }
            }
        }
        return lines;
    }

    private static void resetWrapValues() {
        lineTextWidth = 0;
        shouldIndent = true;
        indentationText = null;
    }

    private static void wrapTooltip(Component name, List<Component> lines, List<Component> keys) {
        Font textRenderer = Minecraft.getInstance().font;
        if (textRenderer != null && (Integer)ModClient.CONFIG.style.length.value() != 0) {
            int maxLength = Math.max((Integer)ModClient.CONFIG.style.length.value(), textRenderer.width((FormattedText)name));
            for (Component originalText : keys) {
                MutableComponent translated = originalText.plainCopy().setStyle(originalText.getStyle());
                ComponentContents componentContents = translated.getContents();
                if (componentContents instanceof TranslatableContents) {
                    TranslatableContents translatable = (TranslatableContents)componentContents;
                    translated = Component.literal((String)I18n.get((String)translatable.getKey(), (Object[])new Object[0])).setStyle(translated.getStyle());
                }
                if (shouldIndent && translated.getString().isBlank() && !translated.getString().isEmpty()) {
                    indentationText = originalText.plainCopy();
                    ModHelpers.wrapTooltip(name, lines, originalText.getSiblings());
                    shouldIndent = false;
                    continue;
                }
                shouldIndent = false;
                while (lineTextWidth + textRenderer.width((FormattedText)translated) >= maxLength && translated.getString().contains(" ")) {
                    lineTextWidth = 0;
                    translated = ModHelpers.createNewLine(lines, (Component)translated, textRenderer, maxLength);
                }
                if (!translated.getString().isEmpty()) {
                    if (!lines.isEmpty() && lines.size() > 1 && textRenderer.width((FormattedText)lines.get(lines.size() - 1)) + textRenderer.width((FormattedText)translated) < maxLength && translated.getString().contains(" ")) {
                        Component oldText = lines.removeLast();
                        MutableComponent newText = oldText.copy().append((Component)translated);
                        ModHelpers.createNewLine(lines, (Component)newText, textRenderer, maxLength);
                        lineTextWidth = 0;
                    } else {
                        lineTextWidth = textRenderer.width((FormattedText)translated);
                        ModHelpers.createNewLine(lines, (Component)translated, textRenderer, maxLength);
                    }
                }
                ModHelpers.wrapTooltip(name, lines, originalText.getSiblings());
            }
        }
    }

    private static Component createNewLine(List<Component> lines, Component text, Font textRenderer, int maxLength) {
        int lineLength = text.getString().length();
        if (text.getString().contains("\n")) {
            lineLength = text.getString().indexOf("\n");
        } else {
            while (text.getString().substring(0, lineLength).contains(" ") && textRenderer.width((FormattedText)Component.literal((String)text.getString().substring(0, lineLength))) >= maxLength) {
                lineLength = ModHelpers.getIndex(text.getString(), lineLength);
            }
        }
        Component newLine = ModHelpers.subText(text, 0, lineLength);
        if (indentationText != null) {
            newLine = indentationText.copy().append(newLine);
        }
        lines.add(newLine);
        return ModHelpers.subText(text, lineLength + 1);
    }

    private static Component subText(Component text, int beginIndex) {
        return ModHelpers.subText(text, beginIndex, text.getString().length());
    }

    private static Component subText(Component text, int beginIndex, int endIndex) {
        return ModHelpers.subText(text, beginIndex, endIndex, 0);
    }

    private static Component subText(Component text, int beginIndex, int endIndex, int currentIndex) {
        MutableComponent mutable = text.plainCopy();
        if (beginIndex > mutable.getString().length()) {
            beginIndex -= mutable.getString().length();
            currentIndex += mutable.getString().length();
        } else {
            String string = mutable.getString();
            string = string.substring(beginIndex, Math.min(endIndex - currentIndex, string.length()));
            mutable = Component.literal((String)string).setStyle(text.getStyle());
            currentIndex += string.length();
        }
        if (currentIndex >= endIndex) {
            return mutable;
        }
        for (Component sibling : text.getSiblings()) {
            if (currentIndex >= endIndex) break;
            Component subTextSibling = ModHelpers.subText(sibling, beginIndex, endIndex, currentIndex);
            currentIndex += subTextSibling.getString().length();
            mutable.append(subTextSibling);
        }
        return mutable;
    }

    public static Component fieldName(TrackedValue<?> field) {
        return Component.translatable((String)"config.%s.%s".formatted("item-descriptions", ModHelpers.toSnakeCase(field.key().toString())));
    }

    public static String toSnakeCase(String field) {
        return field.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }

    public static Component[] fieldTooltip(TrackedValue<?> field, boolean wrap) {
        String tooltipKey = "config.%s.%s.tooltip".formatted("item-descriptions", ModHelpers.toSnakeCase(field.key().toString()));
        if (wrap) {
            return ModHelpers.createTooltip((Component)Component.empty(), tooltipKey).toArray(new Component[0]);
        }
        return List.of(ModHelpers.translatableWithFallback(tooltipKey, "")).toArray(new Component[0]);
    }

    public static void fieldSetter(boolean instance, TrackedValue<Boolean> field) {
        field.setValue((Object)instance);
    }

    public static void fieldSetter(Integer instance, TrackedValue<Integer> field) {
        field.setValue((Object)instance);
    }

    public static void fieldSetter(String instance, TrackedValue<String> field) {
        field.setValue((Object)instance);
    }

    private static <T, V> void addMissingTranslations(Registry<T> registry, Map<String, Map<String, String>> namespaces, Function<T, V> valueTransform, Function<V, DescriptionKey> descGetter, Function<V, List<Component>> potentialKeys) {
        for (ResourceKey key : registry.registryKeySet()) {
            V value = valueTransform.apply(registry.getValue(key));
            DescriptionKey description = descGetter.apply(value);
            ArrayList<String> keys = new ArrayList<String>(potentialKeys.apply(value).stream().map(Component::getString).toList());
            Identifier id = key.identifier();
            if (description.isEmpty()) {
                ModClient.LOGGER.warn("[Item Descriptions] Couldn't get lore key for {}: {}!", registry.getAny().get(), (Object)id);
                continue;
            }
            if (!keys.stream().noneMatch(I18n::exists)) continue;
            keys.remove(description.asLoreTranslation());
            if (value instanceof ItemStack) {
                ItemStack stack = (ItemStack)value;
                keys.remove(ModHelpers.getModdedNameMatch(stack).asLoreTranslation());
            }
            namespaces.computeIfAbsent(id.getNamespace(), k -> new TreeMap()).compute(value instanceof Block || value instanceof Item ? description.asLoreTranslation() : description.asDescriptionTranslation(), (k, v) -> Objects.requireNonNullElse(v, " ??? ") + String.join((CharSequence)", ", keys));
        }
    }

    public static void generateMissingTranslations(RegistryGetter registryGetter) {
        ModClient.LOGGER.info("[Item Descriptions] Creating missing translations files");
        File folder = Platform.INSTANCE.getMissingTranslationsPath();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap<String, Map<String, String>> namespaces = new HashMap<String, Map<String, String>>();
        ModHelpers.addMissingTranslations(registryGetter.get(ResourceKey.createRegistryKey((Identifier)ModHelpers.of("minecraft", "entity_type"))).orElse(null), namespaces, Function.identity(), ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        ModHelpers.addMissingTranslations(registryGetter.get(ResourceKey.createRegistryKey((Identifier)ModHelpers.of("minecraft", "item"))).orElse(null), namespaces, Item::getDefaultInstance, ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        ModHelpers.addMissingTranslations(registryGetter.get(ResourceKey.createRegistryKey((Identifier)ModHelpers.of("minecraft", "enchantment"))).orElse(null), namespaces, Function.identity(), ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        ModHelpers.addMissingTranslations(registryGetter.get(ResourceKey.createRegistryKey((Identifier)ModHelpers.of("minecraft", "block"))).orElse(null), namespaces, Block::defaultBlockState, ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        ModHelpers.addMissingTranslations(registryGetter.get(ResourceKey.createRegistryKey((Identifier)ModHelpers.of("minecraft", "mob_effect"))).orElse(null), namespaces, Function.identity(), ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        TreeMap combined = new TreeMap();
        namespaces.values().forEach(combined::putAll);
        namespaces.put("item_descriptions", combined);
        for (Map.Entry entry : namespaces.entrySet()) {
            String namespace = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            Path namespacePath = folder.toPath().resolve("assets").resolve(namespace).resolve("lang");
            namespacePath.toFile().mkdirs();
            try (FileWriter writer = new FileWriter(namespacePath.resolve("en_us.json").toFile());){
                gson.toJson((Object)map, (Appendable)writer);
            }
            catch (IOException e) {
                ModClient.LOGGER.error("[Item Descriptions] Failed to write missing descriptions file", (Throwable)e);
            }
        }
    }

    public static interface RegistryGetter {
        public <E> Optional<? extends Registry<E>> get(ResourceKey<? extends Registry<? extends E>> var1);
    }
}

