/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.helpers;

import cc.cassian.item_descriptions.client.DescriptionKey;
import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7225;

public class TagHelpers {
    private static boolean checkMatch(DescriptionKey[] currentKey, DescriptionKey newKey) {
        return newKey.hasTranslation() && (currentKey[0] == null || DescriptionKey.isMorePrecise(currentKey[0], newKey));
    }

    public static DescriptionKey checkGenericTagList(class_1799 stack) {
        if (((Boolean)ModClient.CONFIG.developerOptions.disableTagDescriptions.value()).booleanValue()) {
            return DescriptionKey.empty();
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1826) {
            class_1826 spawnEggItem = (class_1826)item;
            if (((Boolean)ModClient.CONFIG.spawnEggsShowEntity.value()).booleanValue()) {
                class_638 level = class_310.method_1551().field_1687;
                if (level == null) {
                    return new DescriptionKey("tag", "c", "spawn_egg");
                }
                class_1299 entityType = spawnEggItem.method_8015((class_7225.class_7874)level.method_30349(), stack);
                DescriptionKey key = ModHelpers.getDescriptionKey(entityType);
                if (key.hasTranslation()) {
                    return key;
                }
            }
            return new DescriptionKey("tag", "c", "spawn_egg");
        }
        DescriptionKey[] returnedKey = new DescriptionKey[1];
        stack.method_40133().forEach(itemTagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
            if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                returnedKey[0] = loreKey;
            }
        });
        if (returnedKey[0] == null && item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            blockItem.method_7711().method_9564().method_40144().forEach(itemTagKey -> {
                DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                    returnedKey[0] = loreKey;
                }
            });
        }
        return Objects.requireNonNullElse(returnedKey[0], DescriptionKey.empty());
    }

    public static DescriptionKey checkGenericTagList(class_2680 state) {
        DescriptionKey[] returnedKey = new DescriptionKey[1];
        state.method_40144().forEach(tagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(tagKey);
            if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                returnedKey[0] = loreKey;
            }
        });
        return Objects.requireNonNullElse(returnedKey[0], DescriptionKey.empty());
    }

    public static DescriptionKey checkGenericTagList(class_2248 block) {
        return TagHelpers.checkGenericTagList(block.method_9564());
    }

    public static DescriptionKey checkGenericTagList(class_1297 entity) {
        return TagHelpers.checkGenericTagList(entity.method_5864());
    }

    public static DescriptionKey checkGenericTagList(class_1299<?> type) {
        DescriptionKey[] returnedKey = new DescriptionKey[1];
        type.method_40124().method_40228().forEach(tagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(tagKey);
            if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                returnedKey[0] = loreKey;
            }
        });
        return Objects.requireNonNullElse(returnedKey[0], DescriptionKey.empty());
    }

    private static void addSafe(ArrayList<class_2561> tags, DescriptionKey newAdd) {
        class_5250 newText = class_437.method_25443() ? newAdd.toText() : class_2561.method_43470((String)newAdd.toString());
        if (!tags.contains(newText)) {
            tags.add((class_2561)newText);
        }
    }

    public static List<class_2561> findAllPotentialKeys(class_1799 itemStack) {
        ArrayList<class_2561> tags = new ArrayList<class_2561>();
        TagHelpers.addSafe(tags, ModHelpers.findLoreKey(itemStack));
        TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(itemStack));
        TagHelpers.addSafe(tags, ModHelpers.getModdedNameMatch(itemStack));
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1826) {
            TagHelpers.addSafe(tags, new DescriptionKey("tag", "c", "spawn_egg"));
        }
        itemStack.method_40133().forEach(itemTagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
            TagHelpers.addSafe(tags, loreKey);
        });
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            blockItem.method_7711().method_9564().method_40144().forEach(itemTagKey -> {
                DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                TagHelpers.addSafe(tags, loreKey);
            });
        }
        return tags;
    }

    public static List<class_2561> findAllPotentialKeys(class_2680 state) {
        ArrayList<class_2561> tags = new ArrayList<class_2561>();
        TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(state));
        TagHelpers.addSafe(tags, ModHelpers.findLoreKey(state));
        state.method_40144().forEach(itemTagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
            TagHelpers.addSafe(tags, loreKey);
        });
        return tags;
    }

    public static List<class_2561> findAllPotentialKeys(class_2248 block) {
        return TagHelpers.findAllPotentialKeys(block.method_9564());
    }

    public static List<class_2561> findAllPotentialKeys(class_1297 entity) {
        return TagHelpers.findAllPotentialKeys(entity.method_5864());
    }

    public static List<class_2561> findAllPotentialKeys(class_1299<?> type) {
        ArrayList<class_2561> tags = new ArrayList<class_2561>();
        TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(type));
        TagHelpers.addSafe(tags, ModHelpers.findLoreKey(type));
        type.method_40124().method_40228().forEach(itemTagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
            TagHelpers.addSafe(tags, loreKey);
        });
        return tags;
    }

    public static List<class_2561> findAllPotentialKeys(class_1887 enchantment) {
        ArrayList<class_2561> tags = new ArrayList<class_2561>();
        TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(enchantment));
        return tags;
    }

    public static List<class_2561> findAllPotentialKeys(class_1291 mobEffect) {
        ArrayList<class_2561> tags = new ArrayList<class_2561>();
        TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(mobEffect));
        return tags;
    }

    private static DescriptionKey tagKeyToGenericKey(class_6862<?> key) {
        return new DescriptionKey("tag", key.comp_327());
    }
}

