/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.helpers;

import cc.cassian.item_descriptions.client.DescriptionKey;
import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TagHelpers {
    private static boolean checkMatch(DescriptionKey[] currentKey, DescriptionKey newKey) {
        return newKey.hasTranslation() && (currentKey[0] == null || DescriptionKey.isMorePrecise(currentKey[0], newKey));
    }

    public static DescriptionKey checkGenericTagList(ItemStack stack) {
        if (((Boolean)ModClient.CONFIG.developerOptions.disableTagDescriptions.value()).booleanValue()) {
            return DescriptionKey.empty();
        }
        Item item = stack.getItem();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem spawnEggItem = (SpawnEggItem)item;
            if (((Boolean)ModClient.CONFIG.spawnEggsShowEntity.value()).booleanValue()) {
                ClientLevel level = Minecraft.getInstance().level;
                if (level == null) {
                    return new DescriptionKey("tag", "c", "spawn_egg");
                }
                EntityType entityType = spawnEggItem.getType((HolderLookup.Provider)level.registryAccess(), stack);
                DescriptionKey key = ModHelpers.getDescriptionKey(entityType);
                if (key.hasTranslation()) {
                    return key;
                }
            }
            return new DescriptionKey("tag", "c", "spawn_egg");
        }
        DescriptionKey[] returnedKey = new DescriptionKey[1];
        stack.getTags().forEach(itemTagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
            if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                returnedKey[0] = loreKey;
            }
        });
        if (returnedKey[0] == null && item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            blockItem.getBlock().defaultBlockState().getTags().forEach(itemTagKey -> {
                DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                    returnedKey[0] = loreKey;
                }
            });
        }
        return Objects.requireNonNullElse(returnedKey[0], DescriptionKey.empty());
    }

    public static DescriptionKey checkGenericTagList(BlockState state) {
        DescriptionKey[] returnedKey = new DescriptionKey[1];
        state.getTags().forEach(tagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(tagKey);
            if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                returnedKey[0] = loreKey;
            }
        });
        return Objects.requireNonNullElse(returnedKey[0], DescriptionKey.empty());
    }

    public static DescriptionKey checkGenericTagList(Block block) {
        return TagHelpers.checkGenericTagList(block.defaultBlockState());
    }

    public static DescriptionKey checkGenericTagList(Entity entity) {
        return TagHelpers.checkGenericTagList(entity.getType());
    }

    public static DescriptionKey checkGenericTagList(EntityType<?> type) {
        DescriptionKey[] returnedKey = new DescriptionKey[1];
        type.builtInRegistryHolder().tags().forEach(tagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(tagKey);
            if (TagHelpers.checkMatch(returnedKey, loreKey)) {
                returnedKey[0] = loreKey;
            }
        });
        return Objects.requireNonNullElse(returnedKey[0], DescriptionKey.empty());
    }

    private static void addSafe(ArrayList<Component> tags, DescriptionKey newAdd) {
        MutableComponent newText = Screen.hasAltDown() ? newAdd.toText() : Component.literal((String)newAdd.toString());
        if (!tags.contains(newText)) {
            tags.add((Component)newText);
        }
    }

    public static List<Component> findAllPotentialKeys(ItemStack itemStack) {
        ArrayList<Component> tags = new ArrayList<Component>();
        TagHelpers.addSafe(tags, ModHelpers.findLoreKey(itemStack));
        TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(itemStack));
        TagHelpers.addSafe(tags, ModHelpers.getModdedNameMatch(itemStack));
        Item item = itemStack.getItem();
        if (item instanceof SpawnEggItem) {
            TagHelpers.addSafe(tags, new DescriptionKey("tag", "c", "spawn_egg"));
        }
        itemStack.getTags().forEach(itemTagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
            TagHelpers.addSafe(tags, loreKey);
        });
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            blockItem.getBlock().defaultBlockState().getTags().forEach(itemTagKey -> {
                DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
                TagHelpers.addSafe(tags, loreKey);
            });
        }
        return tags;
    }

    public static List<Component> findAllPotentialKeys(BlockState state) {
        ArrayList<Component> tags = new ArrayList<Component>();
        TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(state));
        TagHelpers.addSafe(tags, ModHelpers.findLoreKey(state));
        state.getTags().forEach(itemTagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
            TagHelpers.addSafe(tags, loreKey);
        });
        return tags;
    }

    public static List<Component> findAllPotentialKeys(Block block) {
        return TagHelpers.findAllPotentialKeys(block.defaultBlockState());
    }

    public static List<Component> findAllPotentialKeys(Entity entity) {
        return TagHelpers.findAllPotentialKeys(entity.getType());
    }

    public static List<Component> findAllPotentialKeys(EntityType<?> type) {
        ArrayList<Component> tags = new ArrayList<Component>();
        TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(type));
        TagHelpers.addSafe(tags, ModHelpers.findLoreKey(type));
        type.builtInRegistryHolder().tags().forEach(itemTagKey -> {
            DescriptionKey loreKey = TagHelpers.tagKeyToGenericKey(itemTagKey);
            TagHelpers.addSafe(tags, loreKey);
        });
        return tags;
    }

    public static List<Component> findAllPotentialKeys(Enchantment enchantment) {
        ArrayList<Component> tags = new ArrayList<Component>();
        TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(enchantment));
        return tags;
    }

    public static List<Component> findAllPotentialKeys(MobEffect mobEffect) {
        ArrayList<Component> tags = new ArrayList<Component>();
        TagHelpers.addSafe(tags, ModHelpers.getDescriptionKey(mobEffect));
        return tags;
    }

    private static DescriptionKey tagKeyToGenericKey(TagKey<?> key) {
        return new DescriptionKey("tag", key.location());
    }
}

