/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.helpers;

import cc.cassian.item_descriptions.client.DescriptionKey;
import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.Platform;
import cc.cassian.item_descriptions.client.config.ModConfig;
import cc.cassian.item_descriptions.client.helpers.ModLists;
import cc.cassian.item_descriptions.client.helpers.ModStyle;
import cc.cassian.item_descriptions.client.helpers.TagHelpers;
import cc.cassian.item_descriptions.client.helpers.compat.FastItemFramesHelpers;
import cc.cassian.item_descriptions.client.helpers.compat.GlowcaseHelpers;
import cc.cassian.item_descriptions.client.helpers.compat.PolymerHelpers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import folk.sisby.kaleido.lib.quiltconfig.api.values.TrackedValue;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9296;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class ModHelpers {
    public static final class_2960 FABRIC_EVENT_PHASE = ModHelpers.of("description_tooltip");
    private static int lineTextWidth = 0;
    private static boolean shouldIndent = false;
    private static class_2561 indentationText = null;

    public static class_2960 of(String path) {
        return ModHelpers.of("item-descriptions", path);
    }

    public static class_2960 of(String namespace, String path) {
        return class_2960.method_60655((String)namespace, (String)path);
    }

    public static boolean useInternalWrapper() {
        return !ModHelpers.isLoaded("tooltipfix");
    }

    public static boolean useInternalEnchantmentDescriptions() {
        if (((Boolean)ModClient.CONFIG.developerOptions.forceEnableEnchantmentDescriptions.value()).booleanValue()) {
            return true;
        }
        return !ModHelpers.isLoaded("idwtialsimmoedm") && !ModHelpers.isLoaded("enchdesc");
    }

    public static boolean useInternalEffectDescriptions() {
        if (((Boolean)ModClient.CONFIG.developerOptions.forceEnableEffectDescriptions.value()).booleanValue()) {
            return true;
        }
        return !ModHelpers.isLoaded("potiondescriptions") && !ModHelpers.isLoaded("effectdescriptions");
    }

    public static boolean isLoaded(String mod) {
        return Platform.INSTANCE.isLoaded(mod);
    }

    public static class_2583 getStyle(String colour) {
        return class_2583.field_24360.method_27703(ModHelpers.getColour(colour)).method_10978((Boolean)ModClient.CONFIG.style.italics.value()).method_10982((Boolean)ModClient.CONFIG.style.bold.getDefaultValue());
    }

    public static class_5250 getHintText() {
        StringBuilder sb = new StringBuilder();
        ModConfig config = ModClient.CONFIG;
        Boolean shift = (Boolean)config.keybinds.displayWhenShiftIsHeld.value();
        Boolean ctrl = (Boolean)config.keybinds.displayWhenCtrlIsHeld.value();
        Boolean alt = (Boolean)config.keybinds.displayWhenAltIsHeld.value();
        if (((Boolean)config.hint.showKeybinds.value()).booleanValue()) {
            if (ctrl.booleanValue()) {
                String ctrlText = class_1074.method_4662((String)"key.keyboard.ctrl", (Object[])new Object[0]);
                if (((Boolean)ModClient.CONFIG.hint.uppercase.value()).booleanValue()) {
                    ctrlText = ctrlText.toUpperCase(Locale.ROOT);
                }
                sb.append(ctrlText);
                if (shift.booleanValue() || alt.booleanValue()) {
                    sb.append("/");
                }
            }
            if (alt.booleanValue()) {
                String altText = class_1074.method_4662((String)"key.keyboard.alt", (Object[])new Object[0]);
                if (((Boolean)ModClient.CONFIG.hint.uppercase.value()).booleanValue()) {
                    altText = altText.toUpperCase(Locale.ROOT);
                }
                sb.append(altText);
                if (shift.booleanValue()) {
                    sb.append("/");
                }
            }
            if (shift.booleanValue()) {
                String shiftText = class_1074.method_4662((String)"key.keyboard.shift", (Object[])new Object[0]);
                if (((Boolean)ModClient.CONFIG.hint.uppercase.value()).booleanValue()) {
                    shiftText = shiftText.toUpperCase(Locale.ROOT);
                }
                sb.append(shiftText);
            }
            sb.append(": ");
        }
        if (((Boolean)config.keybinds.invert.value()).booleanValue()) {
            sb.append(class_1074.method_4662((String)"hint.item-descriptions.hint_inverted", (Object[])new Object[0]));
        } else {
            sb.append(class_1074.method_4662((String)"hint.item-descriptions.hint", (Object[])new Object[0]));
        }
        return class_2561.method_43470((String)sb.toString());
    }

    public static class_5251 getColour(String colour) {
        int length = colour.length();
        if (length == 1) {
            return class_5251.method_27718((class_124)class_124.method_544((char)colour.charAt(0)));
        }
        try {
            return class_5251.method_27717((int)Integer.parseInt(colour));
        }
        catch (NumberFormatException numberFormatException) {
            String replacedColour;
            return switch (replacedColour = colour.toLowerCase().replace(" ", "_")) {
                case "black", "dark_blue", "dark_green", "dark_red", "dark_purple", "blue", "green", "aqua", "red", "yellow", "white" -> class_5251.method_27718((class_124)class_124.method_533((String)colour));
                case "pink", "light_purple" -> class_5251.method_27718((class_124)class_124.method_533((String)"light_purple"));
                case "dark_gray", "dark_grey" -> class_5251.method_27718((class_124)class_124.method_533((String)"dark_gray"));
                case "cyan", "dark_aqua" -> class_5251.method_27718((class_124)class_124.method_533((String)"dark_aqua"));
                case "orange", "gold", "dark_yellow" -> class_5251.method_27718((class_124)class_124.method_533((String)"gold"));
                default -> class_5251.method_27718((class_124)class_124.method_533((String)"gray"));
            };
        }
    }

    public static int getIndex(String translatedKey, int maxLength) {
        String subKey = translatedKey.substring(0, maxLength);
        int index = subKey.contains(" ") ? subKey.lastIndexOf(" ") : maxLength;
        return index;
    }

    public static boolean tooltipKeyPressed() {
        boolean ctrl = class_437.method_25441();
        boolean alt = class_437.method_25443();
        boolean shift = class_437.method_25442();
        if (((Boolean)ModClient.CONFIG.keybinds.displayWhenCtrlIsHeld.value()).booleanValue() && ctrl) {
            return ModHelpers.checkKey(ctrl);
        }
        if (((Boolean)ModClient.CONFIG.keybinds.displayWhenShiftIsHeld.value()).booleanValue() && shift) {
            return ModHelpers.checkKey(shift);
        }
        if (((Boolean)ModClient.CONFIG.keybinds.displayWhenAltIsHeld.value()).booleanValue() && alt) {
            return ModHelpers.checkKey(alt);
        }
        return false;
    }

    public static boolean checkKey(boolean key) {
        boolean invert = (Boolean)ModClient.CONFIG.keybinds.invert.value();
        if (key) {
            return !invert;
        }
        if (!key) {
            return invert;
        }
        return false;
    }

    public static DescriptionKey findLoreKey(class_1799 stack) {
        DescriptionKey name;
        DescriptionKey profileKey;
        if (((Boolean)ModClient.CONFIG.enchantmentDescriptions.onlyEnchantmentDescriptionsOnBooks.value()).booleanValue() && stack.method_31574(class_1802.field_8598)) {
            return DescriptionKey.empty();
        }
        if (PolymerHelpers.getServerResourceLocation(stack) != null) {
            return new DescriptionKey(PolymerHelpers.getServerResourceLocation(stack));
        }
        if (ModHelpers.hasComponent(stack, class_9334.field_49637)) {
            data = Objects.requireNonNull((class_9280)stack.method_57353().method_57829(class_9334.field_49637));
            int dataValue = data.comp_2382();
            DescriptionKey key = ModHelpers.getDescriptionKey(stack);
            DescriptionKey modelKey = key.hasTranslation() ? key : TagHelpers.checkGenericTagList(stack);
            modelKey.setSuffix(".custommodeldata." + dataValue);
            if (modelKey.hasTranslation()) {
                return modelKey;
            }
        } else if (stack.method_31574(class_1802.field_8892) && ModHelpers.hasComponent(stack, class_9334.field_49609)) {
            data = Objects.requireNonNull((class_9279)stack.method_57353().method_57829(class_9334.field_49609));
            String variant = ModHelpers.toTranslationKey(data.method_57461().method_10558("variant"));
            DescriptionKey paintingKey = new DescriptionKey("lore", "minecraft", "painting", variant);
            if (paintingKey.hasTranslation() || ((Boolean)ModClient.CONFIG.developerOptions.showAllPotentialKeys.value()).booleanValue()) {
                return paintingKey;
            }
        } else if (ModHelpers.hasComponent(stack, class_9334.field_49617) && (profileKey = ModHelpers.getProfile(stack)).hasTranslation()) {
            return profileKey;
        }
        if ((name = ModHelpers.getModdedNameMatch(stack)).hasTranslation()) {
            return name;
        }
        DescriptionKey key = ModHelpers.getDescriptionKey(stack);
        return ModHelpers.checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(stack));
    }

    public static DescriptionKey getModdedNameMatch(class_1799 stack) {
        DescriptionKey key = ModHelpers.getDescriptionKey(stack);
        key.setSuffix(ModHelpers.toTranslationKey(stack.method_7909().method_7864(stack).getString()));
        return key;
    }

    public static String toTranslationKey(String string) {
        return string.toLowerCase().replaceAll("\"", "").replaceAll(" ", "_").replaceAll("[/:]", ".");
    }

    public static boolean hasTranslation(String key) {
        if (((Boolean)ModClient.CONFIG.developerOptions.showUntranslated.value()).booleanValue()) {
            return true;
        }
        return class_1074.method_4663((String)key);
    }

    public static DescriptionKey createBlockDescription(class_2248 block, class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        class_1799 contents;
        DescriptionKey profileKey;
        DescriptionKey loreKey = ModHelpers.findLoreKey(block);
        if (ModHelpers.isLoaded("polymer-bundled") && pos != null && PolymerHelpers.isPolymerBlock(pos)) {
            loreKey = new DescriptionKey(PolymerHelpers.findPolymerBlockResourceLocation(pos));
        }
        if (blockEntity instanceof class_2631 && (profileKey = ModHelpers.getProfile(blockEntity, loreKey)).hasTranslation()) {
            return profileKey;
        }
        if (ModHelpers.isLoaded("fastitemframes") && FastItemFramesHelpers.isFastItemFrame(blockEntity) && (contents = FastItemFramesHelpers.getFastItemFrameContents(blockEntity)) != null) {
            return ModHelpers.findLoreKey(contents);
        }
        if (ModHelpers.isLoaded("glowcase") && GlowcaseHelpers.isItemDisplay(blockEntity) && (contents = GlowcaseHelpers.getItemDisplayContents(blockEntity)) != null) {
            return ModHelpers.findLoreKey(contents);
        }
        if (!loreKey.hasTranslation()) {
            if (pos == null) {
                return ModHelpers.findLoreKey(block.method_8389().method_7854());
            }
            return ModHelpers.findLoreKey(block.method_9574((class_4538)world, pos, state));
        }
        return loreKey;
    }

    public static List<class_2561> createEntityDescription(class_1297 entity) {
        DescriptionKey loreKey;
        class_1534 painting;
        class_1533 itemFrameEntity;
        class_2561 name = entity.method_5477();
        if (entity instanceof class_1533 && !(itemFrameEntity = (class_1533)entity).method_6940().method_7960()) {
            return ModHelpers.createTooltip(name, ModHelpers.findLoreKey(itemFrameEntity.method_6940()));
        }
        if (entity instanceof class_1534 && (painting = (class_1534)entity).method_43404().method_40227() && (loreKey = new DescriptionKey("lore", "minecraft", "painting", ModHelpers.toTranslationKey(painting.method_43404().method_55840()))).hasTranslation()) {
            return ModHelpers.createTooltip(name, loreKey);
        }
        return ModHelpers.createTooltip(name, ModHelpers.findLoreKey(entity));
    }

    public static boolean createEnchantmentDescription(class_1799 stack, List<class_2561> lines) {
        boolean descriptionFound = false;
        if (((Boolean)ModClient.CONFIG.enchantmentDescriptions.enable.value()).booleanValue() && ModHelpers.showEnchantmentDescriptions()) {
            if (((Boolean)ModClient.CONFIG.enchantmentDescriptions.onlyShowOnBooks.value()).booleanValue() && !stack.method_7909().equals(class_1802.field_8598)) {
                return false;
            }
            HashSet enchantments = new HashSet(class_1890.method_57532((class_1799)stack).method_57534());
            if (enchantments.isEmpty()) {
                return false;
            }
            for (class_6880 enchantmentEntry : enchantments) {
                class_1887 enchantment = (class_1887)enchantmentEntry.comp_349();
                for (int i = 0; i < lines.size(); ++i) {
                    class_7417 description;
                    if (!lines.get(i).method_10851().equals((Object)enchantment.comp_2686().method_10851()) || !((description = lines.get(i).method_10851()) instanceof class_2588)) continue;
                    class_2588 translatableTextContent = (class_2588)description;
                    DescriptionKey descriptionKey = new DescriptionKey(translatableTextContent.method_11022());
                    lines.add(i + 1, (class_2561)descriptionKey.toText().method_10862(ModStyle.ENCHANTMENT_DESCRIPTIONS));
                }
            }
        }
        return descriptionFound;
    }

    private static boolean checkTranslatableText(class_2561 text, Predicate<class_2588> predicate) {
        class_2588 translatable;
        class_7417 contents = null;
        if (text instanceof class_5250) {
            class_5250 mutable = (class_5250)text;
            if (mutable.method_10855().stream().anyMatch(c -> ModHelpers.checkTranslatableText(c, predicate))) {
                return true;
            }
            contents = mutable.method_10851();
        }
        if (contents == null) {
            return false;
        }
        return contents instanceof class_2588 && predicate.test(translatable = (class_2588)contents);
    }

    public static void fixEnchantmentDescription(class_1799 stack, List<class_2561> lines) {
        if (((Boolean)ModClient.CONFIG.enchantmentDescriptions.enable.value()).booleanValue() && ModHelpers.useInternalEnchantmentDescriptions()) {
            if (((Boolean)ModClient.CONFIG.enchantmentDescriptions.onlyShowOnBooks.value()).booleanValue() && !stack.method_7909().equals(class_1802.field_8598)) {
                return;
            }
            HashSet<Object> enchantments = new HashSet<Object>(class_1890.method_57532((class_1799)stack).method_57534());
            if (enchantments.isEmpty()) {
                return;
            }
            for (int i = 0; i < lines.size(); ++i) {
                List<class_2561> newLines;
                if (!ModHelpers.isEnchantmentDescription(lines.get(i), enchantments) || (newLines = ModHelpers.createTooltip(stack.method_7954(), lines.get(i), ModHelpers.useInternalWrapper())).isEmpty()) continue;
                lines.set(i, newLines.getFirst());
                if (newLines.size() <= 1) continue;
                lines.addAll(i + 1, newLines.subList(1, newLines.size()));
            }
        }
    }

    private static boolean isEnchantmentDescription(class_2561 text, Set<Object> enchantments) {
        if (class_310.method_1551().field_1687 == null) {
            return false;
        }
        return ModHelpers.checkTranslatableText(text, content -> {
            String[] split = content.method_11022().split("\\.");
            if (split.length < 3) {
                return false;
            }
            String namespace = split[1];
            String path = split[2];
            if (ModHelpers.hasTranslation(content.method_11022()) && (split.length == 4 && split[0].equals("enchantment") && (split[3].equals("description") || split[3].equals("desc")) || split.length == 3 && split[0].equals("lore"))) {
                return enchantments.stream().anyMatch(entry -> ((class_6880)entry).method_40226(ModHelpers.of(namespace, path)));
            }
            return false;
        });
    }

    public static List<class_2561> createEffectDescription(List<class_2561> text) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>(text);
        if (((Boolean)ModClient.CONFIG.effectDescriptions.enable.value()).booleanValue()) {
            for (class_2561 text1 : text) {
                class_2588 translatableTextContent;
                class_7417 class_74172 = text1.method_10851();
                if (!(class_74172 instanceof class_2588) || (translatableTextContent = (class_2588)class_74172).method_11022().startsWith("effect.duration")) continue;
                DescriptionKey key = new DescriptionKey(translatableTextContent.method_11022());
                List<class_2561> tooltip = ModHelpers.createTooltip(text1, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
                if (ModHelpers.showEffectDescriptions()) {
                    lines.addAll(tooltip);
                    continue;
                }
                if (!((Boolean)ModClient.CONFIG.hint.enabled.value()).booleanValue() || !key.hasTranslation()) continue;
                ModHelpers.addHint(lines);
            }
        }
        return lines;
    }

    public static void createEffectDescription(class_2561 name, Consumer<class_2561> textConsumer, class_1293 statusEffectInstance) {
        if (((Boolean)ModClient.CONFIG.effectDescriptions.enable.value()).booleanValue() && ModHelpers.showEffectDescriptions()) {
            DescriptionKey key = new DescriptionKey(statusEffectInstance.method_5586());
            List<class_2561> tooltip = ModHelpers.createTooltip(name, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
            if (ModHelpers.showEffectDescriptions()) {
                for (class_2561 line : tooltip) {
                    textConsumer.accept(line);
                }
            }
        }
    }

    public static void createEffectDescription(class_2561 name, List<class_2561> textConsumer, class_1293 statusEffectInstance) {
        if (((Boolean)ModClient.CONFIG.effectDescriptions.enable.value()).booleanValue() && ModHelpers.showEffectDescriptions()) {
            DescriptionKey key = new DescriptionKey(statusEffectInstance.method_5586());
            List<class_2561> tooltip = ModHelpers.createTooltip(name, key.toString(), true, ModStyle.EFFECT_DESCRIPTIONS);
            if (ModHelpers.showEffectDescriptions()) {
                textConsumer.addAll(tooltip);
            }
        }
    }

    public static void addHint(List<class_2561> lines) {
        lines.add(1, (class_2561)ModHelpers.getHintText().method_10862(ModStyle.HINT));
    }

    public static boolean createItemDescription(class_1799 stack, List<class_2561> lines) {
        if (((Boolean)ModClient.CONFIG.itemDescriptions.value()).booleanValue()) {
            List<class_2561> tooltip;
            DescriptionKey descriptionKey = ModHelpers.findLoreKey(stack);
            if (((Boolean)ModClient.CONFIG.developerOptions.showAllPotentialKeys.value()).booleanValue()) {
                tooltip = TagHelpers.findAllPotentialKeys(stack);
            } else {
                if (descriptionKey.hasEmptyTranslation()) {
                    return false;
                }
                if (descriptionKey.hasTranslation()) {
                    tooltip = List.of(descriptionKey.toText());
                } else {
                    return false;
                }
            }
            if (ModHelpers.showItemDescriptions()) {
                tooltip = tooltip.stream().map(text -> text.method_27661().method_10862(ModStyle.ITEM_DESCRIPTIONS)).toList();
                lines.addAll(1, tooltip);
            } else {
                return descriptionKey.hasTranslation();
            }
        }
        return false;
    }

    public static void fixItemDescription(class_1799 stack, List<class_2561> lines) {
        if (((Boolean)ModClient.CONFIG.itemDescriptions.value()).booleanValue() && ModHelpers.showItemDescriptions()) {
            DescriptionKey descriptionKey = ModHelpers.findLoreKey(stack);
            List<Object> tooltip = (Boolean)ModClient.CONFIG.developerOptions.showAllPotentialKeys.value() != false ? TagHelpers.findAllPotentialKeys(stack) : List.of(descriptionKey.toText());
            for (int i = 0; i < lines.size(); ++i) {
                int finalI = i;
                if (!tooltip.stream().anyMatch(text -> text.method_10851().equals((Object)((class_2561)lines.get(finalI)).method_10851()))) continue;
                List<class_2561> newLines = ModHelpers.createTooltip(stack.method_7954(), lines.get(i), ModHelpers.useInternalWrapper());
                lines.set(i, newLines.getFirst());
                if (newLines.size() <= 1) continue;
                lines.addAll(i + 1, newLines.subList(1, newLines.size()));
            }
        }
    }

    public static boolean hasComponent(class_1799 stack, class_9331<?> type) {
        return stack.method_57353().method_57832(type);
    }

    public static DescriptionKey getProfile(class_1799 stack) {
        String optionalProfileName = Objects.requireNonNull(Objects.requireNonNull((class_9296)stack.method_57353().method_57829(class_9334.field_49617)).comp_2410()).orElse("");
        if (!optionalProfileName.isEmpty()) {
            DescriptionKey key = ModHelpers.getDescriptionKey(stack);
            DescriptionKey profileKey = key.hasTranslation() ? key : TagHelpers.checkGenericTagList(stack);
            profileKey.setSuffix("profile." + optionalProfileName);
            if (profileKey.hasTranslation()) {
                return profileKey;
            }
        }
        return DescriptionKey.empty();
    }

    public static DescriptionKey getProfile(class_2586 blockEntity, DescriptionKey loreKey) {
        String optionalProfileName;
        try {
            optionalProfileName = Objects.requireNonNull(((class_2631)blockEntity).method_11334()).comp_2410().orElse("");
        }
        catch (NullPointerException nullPointerException) {
            return loreKey;
        }
        loreKey.setSuffix("profile." + optionalProfileName);
        return loreKey;
    }

    public static boolean showBlockDescriptions() {
        return (Boolean)ModClient.CONFIG.blockDescriptions.enable.value() != false && (ModHelpers.tooltipKeyPressed() || (Boolean)ModClient.CONFIG.blockDescriptions.showAlways.value() != false);
    }

    public static boolean showItemDescriptions() {
        return (Boolean)ModClient.CONFIG.itemDescriptions.value() != false && (ModHelpers.tooltipKeyPressed() || (Boolean)ModClient.CONFIG.displayAlways.value() != false);
    }

    public static boolean showEnchantmentDescriptions() {
        return (Boolean)ModClient.CONFIG.enchantmentDescriptions.enable.value() != false && ModHelpers.useInternalEnchantmentDescriptions() && (ModHelpers.tooltipKeyPressed() || (Boolean)ModClient.CONFIG.enchantmentDescriptions.displayAlways.value() != false);
    }

    public static boolean showEntityDescriptions() {
        return (Boolean)ModClient.CONFIG.entityDescriptions.enable.value() != false && (ModHelpers.tooltipKeyPressed() || (Boolean)ModClient.CONFIG.entityDescriptions.showAlways.value() != false);
    }

    public static boolean showEffectDescriptions() {
        return (Boolean)ModClient.CONFIG.effectDescriptions.enable.value() != false && ModHelpers.useInternalEffectDescriptions() && (ModHelpers.tooltipKeyPressed() || (Boolean)ModClient.CONFIG.effectDescriptions.displayAlways.value() != false);
    }

    public static void createDescriptionsFromItemStack(class_1799 stack, class_1792.class_9635 context, class_1836 type, List<class_2561> lines) {
        if (((Boolean)ModClient.CONFIG.developerOptions.hideOtherTooltips.value()).booleanValue() || ModLists.hidden_items.contains(stack.method_7909())) {
            class_2561 first = lines.getFirst();
            lines.clear();
            lines.add(first);
        }
        boolean enchant = ModHelpers.createEnchantmentDescription(stack, lines);
        boolean effect = ModHelpers.checkForEffectDescription(stack);
        if (((Boolean)ModClient.CONFIG.effectDescriptions.onlyShowEffectDescriptions.value()).booleanValue() && effect) {
            return;
        }
        boolean item = ModHelpers.createItemDescription(stack, lines);
        if (((Boolean)ModClient.CONFIG.hint.enabled.value()).booleanValue() && (item || enchant)) {
            ModHelpers.addHint(lines);
        }
        if ((ModHelpers.tooltipKeyPressed() || ((Boolean)ModClient.CONFIG.displayAlways.value()).booleanValue()) && ((Boolean)ModClient.CONFIG.showModName.value()).booleanValue()) {
            ModHelpers.addModName(stack, lines);
        }
    }

    private static void addModName(class_1799 stack, List<class_2561> lines) {
        String namespace = Platform.INSTANCE.getModName(stack);
        class_5250 text = class_2561.method_43470((String)namespace);
        lines.add((class_2561)text.method_10862(ModStyle.MOD_NAME));
    }

    public static String getModName(class_1799 stack) {
        return Platform.INSTANCE.getModName(stack);
    }

    public static class_5250 translatableWithFallback(String translatable, String fallback) {
        return class_2561.method_48321((String)translatable, (String)fallback);
    }

    private static boolean checkForEffectDescription(class_1799 stack) {
        if (ModHelpers.hasComponent(stack, class_9334.field_49651)) {
            class_1844 contents = (class_1844)stack.method_57353().method_57829(class_9334.field_49651);
            if (contents == null) {
                return false;
            }
            for (class_1293 effect : contents.method_57397()) {
                DescriptionKey key = new DescriptionKey(effect.method_5586());
                if (!key.hasTranslation()) continue;
                return true;
            }
        }
        return false;
    }

    public static void fixItemStackDescriptionTooltip(class_1799 stack, class_1792.class_9635 context, class_1836 type, List<class_2561> lines) {
        if (!ModHelpers.useInternalWrapper()) {
            return;
        }
        ModHelpers.fixEnchantmentDescription(stack, lines);
        if (ModHelpers.useInternalWrapper()) {
            ModHelpers.fixItemDescription(stack, lines);
        }
    }

    public static String getProfileName(Optional<String> optionalProfileName) {
        if (optionalProfileName.isPresent()) {
            String profileName = optionalProfileName.get();
            return profileName;
        }
        return "";
    }

    public static DescriptionKey findLoreKey(class_2248 block) {
        DescriptionKey key = ModHelpers.getDescriptionKey(block);
        return ModHelpers.checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(block));
    }

    public static DescriptionKey findLoreKey(class_2680 state) {
        DescriptionKey key = ModHelpers.getDescriptionKey(state);
        return ModHelpers.checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(state));
    }

    public static DescriptionKey findLoreKey(class_1297 entity) {
        return ModHelpers.findLoreKey(entity.method_5864());
    }

    public static DescriptionKey findLoreKey(class_1299<?> entity) {
        DescriptionKey key = ModHelpers.getDescriptionKey(entity);
        return ModHelpers.checkLoreKey(key.hasTranslation() ? key : TagHelpers.checkGenericTagList(entity));
    }

    public static DescriptionKey checkLoreKey(DescriptionKey loreKey) {
        if (loreKey != null && loreKey.hasTranslation()) {
            return loreKey;
        }
        return DescriptionKey.empty();
    }

    @NotNull
    public static DescriptionKey convertToLoreKey(String translationKey) {
        DescriptionKey loreKey;
        if (translationKey.contains("block.")) {
            loreKey = new DescriptionKey(translationKey);
        } else if (translationKey.contains("item.")) {
            loreKey = new DescriptionKey(translationKey);
        } else if (translationKey.contains("entity.")) {
            loreKey = new DescriptionKey(translationKey);
            if (translationKey.contains("tropical_fish")) {
                loreKey = new DescriptionKey("entity", "minecraft", "tropical_fish");
            } else if (loreKey.hasTranslation()) {
                return loreKey;
            }
        } else {
            return DescriptionKey.empty();
        }
        return loreKey;
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(class_1799 stack) {
        return ModHelpers.getDescriptionKey(stack.method_7909());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(class_1792 item) {
        return ModHelpers.convertToLoreKey(item.method_7876());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(class_2680 blockState) {
        return ModHelpers.getDescriptionKey(blockState.method_26204());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(class_2248 block) {
        return ModHelpers.convertToLoreKey(block.method_9539());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(class_1299<?> entityType) {
        return ModHelpers.convertToLoreKey(entityType.method_5882());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(class_1297 entity) {
        return ModHelpers.convertToLoreKey(ModHelpers.getEntityTranslationKey(entity));
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(class_1291 effect) {
        return new DescriptionKey(effect.method_5567());
    }

    @NotNull
    public static DescriptionKey getDescriptionKey(class_1887 enchantment) {
        return ModHelpers.getEnchantmentDescriptionKey(enchantment);
    }

    public static DescriptionKey getEnchantmentDescriptionKey(class_1887 enchantment) {
        DescriptionKey descriptionKey;
        class_7417 class_74172 = enchantment.comp_2686().method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            descriptionKey = new DescriptionKey(translatable.method_11022());
        } else {
            descriptionKey = DescriptionKey.empty();
        }
        return descriptionKey;
    }

    public static String getEntityTranslationKey(class_1297 entity) {
        if (entity instanceof class_1657) {
            String playerKey = "entity.minecraft.player.%s".formatted(entity.method_5477().method_54160());
            if (ModHelpers.hasTranslation(playerKey)) {
                return playerKey;
            }
            return "entity.minecraft.player";
        }
        return entity.method_5864().method_5882();
    }

    public static List<class_2561> createTooltip(class_2561 name, DescriptionKey loreKey) {
        return ModHelpers.createTooltip(name, loreKey.toString(), true);
    }

    public static List<class_2561> createTooltip(class_2561 name, String loreKey) {
        return ModHelpers.createTooltip(name, loreKey, true);
    }

    public static List<class_2561> createTooltip(class_2561 name, String loreKey, boolean wrap) {
        return ModHelpers.createTooltip(name, loreKey, wrap, ModStyle.ITEM_DESCRIPTIONS);
    }

    public static List<class_2561> createTooltip(class_2561 name, class_2561 text, boolean wrap) {
        if (!wrap || text.getString().isEmpty()) {
            return List.of(text);
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        ModHelpers.wrapTooltip(name, lines, List.of(text));
        ModHelpers.resetWrapValues();
        return lines;
    }

    public static List<class_2561> createTooltip(class_2561 name, String loreKey, boolean wrap, class_2583 style) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        if (!loreKey.isBlank()) {
            String translatedKey = class_1074.method_4662((String)loreKey, (Object[])new Object[0]);
            if (ModHelpers.hasTranslation(loreKey)) {
                if (!wrap) {
                    if (!translatedKey.isBlank()) {
                        lines.add((class_2561)class_2561.method_43471((String)loreKey).method_10862(style));
                    }
                } else {
                    ModHelpers.wrapTooltip(name, lines, List.of(class_2561.method_43470((String)translatedKey).method_10862(style)));
                    ModHelpers.resetWrapValues();
                }
            }
        }
        return lines;
    }

    private static void resetWrapValues() {
        lineTextWidth = 0;
        shouldIndent = true;
        indentationText = null;
    }

    private static void wrapTooltip(class_2561 name, List<class_2561> lines, List<class_2561> keys) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (textRenderer != null && (Integer)ModClient.CONFIG.style.length.value() != 0) {
            int maxLength = Math.max((Integer)ModClient.CONFIG.style.length.value(), textRenderer.method_27525((class_5348)name));
            for (class_2561 originalText : keys) {
                class_5250 translated = originalText.method_27662().method_10862(originalText.method_10866());
                class_7417 class_74172 = translated.method_10851();
                if (class_74172 instanceof class_2588) {
                    class_2588 translatable = (class_2588)class_74172;
                    translated = class_2561.method_43470((String)class_1074.method_4662((String)translatable.method_11022(), (Object[])new Object[0])).method_10862(translated.method_10866());
                }
                if (shouldIndent && translated.getString().isBlank() && !translated.getString().isEmpty()) {
                    indentationText = originalText.method_27662();
                    ModHelpers.wrapTooltip(name, lines, originalText.method_10855());
                    shouldIndent = false;
                    continue;
                }
                shouldIndent = false;
                while (lineTextWidth + textRenderer.method_27525((class_5348)translated) >= maxLength && translated.getString().contains(" ")) {
                    lineTextWidth = 0;
                    translated = ModHelpers.createNewLine(lines, (class_2561)translated, textRenderer, maxLength);
                }
                if (!translated.getString().isEmpty()) {
                    if (!lines.isEmpty() && lines.size() > 1 && textRenderer.method_27525((class_5348)lines.get(lines.size() - 1)) + textRenderer.method_27525((class_5348)translated) < maxLength && translated.getString().contains(" ")) {
                        class_2561 oldText = lines.removeLast();
                        class_5250 newText = oldText.method_27661().method_10852((class_2561)translated);
                        ModHelpers.createNewLine(lines, (class_2561)newText, textRenderer, maxLength);
                        lineTextWidth = 0;
                    } else {
                        lineTextWidth = textRenderer.method_27525((class_5348)translated);
                        ModHelpers.createNewLine(lines, (class_2561)translated, textRenderer, maxLength);
                    }
                }
                ModHelpers.wrapTooltip(name, lines, originalText.method_10855());
            }
        }
    }

    private static class_2561 createNewLine(List<class_2561> lines, class_2561 text, class_327 textRenderer, int maxLength) {
        int lineLength = text.getString().length();
        if (text.getString().contains("\n")) {
            lineLength = text.getString().indexOf("\n");
        } else {
            while (text.getString().substring(0, lineLength).contains(" ") && textRenderer.method_27525((class_5348)class_2561.method_43470((String)text.getString().substring(0, lineLength))) >= maxLength) {
                lineLength = ModHelpers.getIndex(text.getString(), lineLength);
            }
        }
        class_2561 newLine = ModHelpers.subText(text, 0, lineLength);
        if (indentationText != null) {
            newLine = indentationText.method_27661().method_10852(newLine);
        }
        lines.add(newLine);
        return ModHelpers.subText(text, lineLength + 1);
    }

    private static class_2561 subText(class_2561 text, int beginIndex) {
        return ModHelpers.subText(text, beginIndex, text.getString().length());
    }

    private static class_2561 subText(class_2561 text, int beginIndex, int endIndex) {
        return ModHelpers.subText(text, beginIndex, endIndex, 0);
    }

    private static class_2561 subText(class_2561 text, int beginIndex, int endIndex, int currentIndex) {
        class_5250 mutable = text.method_27662();
        if (beginIndex > mutable.getString().length()) {
            beginIndex -= mutable.getString().length();
            currentIndex += mutable.getString().length();
        } else {
            String string = mutable.getString();
            string = string.substring(beginIndex, Math.min(endIndex - currentIndex, string.length()));
            mutable = class_2561.method_43470((String)string).method_10862(text.method_10866());
            currentIndex += string.length();
        }
        if (currentIndex >= endIndex) {
            return mutable;
        }
        for (class_2561 sibling : text.method_10855()) {
            if (currentIndex >= endIndex) break;
            class_2561 subTextSibling = ModHelpers.subText(sibling, beginIndex, endIndex, currentIndex);
            currentIndex += subTextSibling.getString().length();
            mutable.method_10852(subTextSibling);
        }
        return mutable;
    }

    public static class_2561 fieldName(TrackedValue<?> field) {
        return class_2561.method_43471((String)"config.%s.%s".formatted("item-descriptions", ModHelpers.toSnakeCase(field.key().toString())));
    }

    public static String toSnakeCase(String field) {
        return field.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }

    public static class_2561[] fieldTooltip(TrackedValue<?> field, boolean wrap) {
        String tooltipKey = "config.%s.%s.tooltip".formatted("item-descriptions", ModHelpers.toSnakeCase(field.key().toString()));
        if (wrap) {
            return ModHelpers.createTooltip((class_2561)class_2561.method_43473(), tooltipKey).toArray(new class_2561[0]);
        }
        return List.of(ModHelpers.translatableWithFallback(tooltipKey, "")).toArray(new class_2561[0]);
    }

    public static void fieldSetter(boolean instance, TrackedValue<Boolean> field) {
        field.setValue((Object)instance);
    }

    public static void fieldSetter(Integer instance, TrackedValue<Integer> field) {
        field.setValue((Object)instance);
    }

    public static void fieldSetter(String instance, TrackedValue<String> field) {
        field.setValue((Object)instance);
    }

    private static <T, V> void addMissingTranslations(class_2378<T> registry, Map<String, Map<String, String>> namespaces, Function<T, V> valueTransform, Function<V, DescriptionKey> descGetter, Function<V, List<class_2561>> potentialKeys) {
        for (class_5321 key : registry.method_42021()) {
            V value = valueTransform.apply(registry.method_29107(key));
            DescriptionKey description = descGetter.apply(value);
            ArrayList<String> keys = new ArrayList<String>(potentialKeys.apply(value).stream().map(class_2561::getString).toList());
            class_2960 id = key.method_29177();
            if (description.isEmpty()) {
                ModClient.LOGGER.warn("[Item Descriptions] Couldn't get lore key for {}: {}!", registry.method_60385().get(), (Object)id);
                continue;
            }
            if (!keys.stream().noneMatch(class_1074::method_4663)) continue;
            keys.remove(description.asLoreTranslation());
            if (value instanceof class_1799) {
                class_1799 stack = (class_1799)value;
                keys.remove(ModHelpers.getModdedNameMatch(stack).asLoreTranslation());
            }
            namespaces.computeIfAbsent(id.method_12836(), k -> new TreeMap()).compute(value instanceof class_2248 || value instanceof class_1792 ? description.asLoreTranslation() : description.asDescriptionTranslation(), (k, v) -> Objects.requireNonNullElse(v, " ??? ") + String.join((CharSequence)", ", keys));
        }
    }

    public static void generateMissingTranslations(RegistryGetter registryGetter) {
        ModClient.LOGGER.info("[Item Descriptions] Creating missing translations files");
        File folder = Platform.INSTANCE.getMissingTranslationsPath();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap<String, Map<String, String>> namespaces = new HashMap<String, Map<String, String>>();
        ModHelpers.addMissingTranslations(registryGetter.get(class_5321.method_29180((class_2960)ModHelpers.of("minecraft", "entity_type"))).orElse(null), namespaces, Function.identity(), ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        ModHelpers.addMissingTranslations(registryGetter.get(class_5321.method_29180((class_2960)ModHelpers.of("minecraft", "item"))).orElse(null), namespaces, class_1792::method_7854, ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        ModHelpers.addMissingTranslations(registryGetter.get(class_5321.method_29180((class_2960)ModHelpers.of("minecraft", "enchantment"))).orElse(null), namespaces, Function.identity(), ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        ModHelpers.addMissingTranslations(registryGetter.get(class_5321.method_29180((class_2960)ModHelpers.of("minecraft", "block"))).orElse(null), namespaces, class_2248::method_9564, ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        ModHelpers.addMissingTranslations(registryGetter.get(class_5321.method_29180((class_2960)ModHelpers.of("minecraft", "mob_effect"))).orElse(null), namespaces, Function.identity(), ModHelpers::getDescriptionKey, TagHelpers::findAllPotentialKeys);
        TreeMap combined = new TreeMap();
        namespaces.values().forEach(combined::putAll);
        namespaces.put("item_descriptions", combined);
        for (Map.Entry entry : namespaces.entrySet()) {
            String namespace = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            Path namespacePath = folder.toPath().resolve("assets").resolve(namespace).resolve("lang");
            namespacePath.toFile().mkdirs();
            try (FileWriter writer = new FileWriter(namespacePath.resolve("en_us.json").toFile());){
                gson.toJson((Object)map, (Appendable)writer);
            }
            catch (IOException e) {
                ModClient.LOGGER.error("[Item Descriptions] Failed to write missing descriptions file", (Throwable)e);
            }
        }
    }

    public static interface RegistryGetter {
        public <E> Optional<? extends class_2378<E>> get(class_5321<? extends class_2378<? extends E>> var1);
    }
}

