/*
 * Decompiled with CFR 0.152.
 */
package jp.nogami_rion.alchemical_power.client;

import java.util.function.IntFunction;
import jp.nogami_rion.alchemical_power.client.ColorTable;
import jp.nogami_rion.alchemical_power.registry.ModFluids;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="alchemical_power", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent e) {
        e.enqueueWork(() -> {});
    }

    @SubscribeEvent
    public static void onRegisterItemColors(RegisterColorHandlersEvent.Item e) {
        e.register((stack, tintIndex) -> {
            Item patt1847$temp;
            if (tintIndex == 1 && (patt1847$temp = stack.m_41720_()) instanceof BucketItem) {
                BucketItem bucket = (BucketItem)patt1847$temp;
                Fluid fluid = bucket.getFluid();
                IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((Fluid)fluid);
                return ext.getTintColor();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModFluids.T1_PANAKEIA.bucket.get(), (ItemLike)ModFluids.T2_PANAKEIA.bucket.get(), (ItemLike)ModFluids.T3_PANAKEIA.bucket.get(), (ItemLike)ModFluids.T4_PANAKEIA.bucket.get(), (ItemLike)ModFluids.T5_PANAKEIA.bucket.get(), (ItemLike)ModFluids.T6_PANAKEIA.bucket.get(), (ItemLike)ModFluids.UNITE_ALLOY.bucket.get(), (ItemLike)ModFluids.SINGULARITY.bucket.get()});
    }

    private static void registerFluidColor(ModFluids.FluidEntry entry, String idPath) {
        Minecraft mc = Minecraft.m_91087_();
        mc.getItemColors().m_92689_((stack, tintIndex) -> ColorTable.colorOf(new ResourceLocation("alchemical_power", idPath), -1), new ItemLike[]{(ItemLike)entry.bucket.get()});
        mc.m_91298_().m_92589_((state, reader, pos, tintIndex) -> ColorTable.colorOf(new ResourceLocation("alchemical_power", idPath), -1), new Block[]{(Block)entry.block.get()});
    }

    private static void registerItemColor(Item item, String idPath, int layerTintIndex) {
        Minecraft mc = Minecraft.m_91087_();
        mc.getItemColors().m_92689_((stack, tintIndex) -> tintIndex == layerTintIndex ? ColorTable.colorOf(new ResourceLocation("alchemical_power", idPath), -1) : -1, new ItemLike[]{item});
    }

    private static void registerItemColorWithLayers(Item item, IntFunction<Integer> colorByLayer) {
        Minecraft.m_91087_().getItemColors().m_92689_((stack, idx) -> (Integer)colorByLayer.apply(idx), new ItemLike[]{item});
    }

    private static void registerBlockColor(Block block, String idPath) {
        Minecraft.m_91087_().m_91298_().m_92589_((state, reader, pos, tintIndex) -> ColorTable.colorOf(new ResourceLocation("alchemical_power", idPath), -1), new Block[]{block});
    }
}

