/*
 * Decompiled with CFR 0.152.
 */
package jp.nogami_rion.alchemical_power.block.entity;

import javax.annotation.Nullable;
import jp.nogami_rion.alchemical_power.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class InfiniteLavaBarrelEntity
extends BlockEntity {
    private final IFluidHandler tank = new InfiniteLavaHandler();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(InfiniteLavaHandler::new);

    public InfiniteLavaBarrelEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.INFINITE_LAVA_BARREL_BE.get(), pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void m_7651_() {
        super.m_7651_();
        this.fluidCap.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        return super.getCapability(cap, side);
    }

    private static class InfiniteLavaHandler
    implements IFluidHandler {
        private static final int TANK_CAPACITY = Integer.MAX_VALUE;

        private InfiniteLavaHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int i) {
            if (i != 0) {
                return FluidStack.EMPTY;
            }
            return new FluidStack((Fluid)Fluids.f_76195_, Integer.MAX_VALUE);
        }

        public int getTankCapacity(int i) {
            if (i != 0) {
                return 0;
            }
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
            if (i != 0) {
                return false;
            }
            return fluidStack.getFluid() == Fluids.f_76195_;
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            if (fluidStack == null || fluidStack.isEmpty()) {
                return 0;
            }
            int accepted = Math.min(fluidStack.getAmount(), Integer.MAX_VALUE);
            return accepted;
        }

        @NotNull
        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            if (fluidStack == null || fluidStack.isEmpty()) {
                return FluidStack.EMPTY;
            }
            if (fluidStack.getFluid() != Fluids.f_76195_) {
                return FluidStack.EMPTY;
            }
            int wanted = Math.min(fluidStack.getAmount(), Integer.MAX_VALUE);
            return new FluidStack((Fluid)Fluids.f_76195_, wanted);
        }

        @NotNull
        public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
            if (i <= 0) {
                return FluidStack.EMPTY;
            }
            int amount = Math.min(i, Integer.MAX_VALUE);
            return new FluidStack((Fluid)Fluids.f_76195_, amount);
        }
    }
}

