/*
 * Decompiled with CFR 0.152.
 */
package jp.nogami_rion.alchemical_power.block.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import jp.nogami_rion.alchemical_power.block.custom.ModGenEnergyStorage;
import jp.nogami_rion.alchemical_power.block.entity.ModBlockEntities;
import jp.nogami_rion.alchemical_power.event.DamageCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class PainConverterBlockEntity
extends BlockEntity {
    private final ModGenEnergyStorage energyStorage = new ModGenEnergyStorage(1000000, 1000000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energyStorage);
    private final Map<UUID, Float> lastHurthMap = new HashMap<UUID, Float>();
    private final int GenFactor = 20;

    public PainConverterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PAIN_CONVERTER_BE.get(), pos, state);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            AABB box = new AABB(pos).m_82377_(0.5, 0.5, 0.5);
            List entities = level.m_45976_(LivingEntity.class, box);
            for (LivingEntity entity : entities) {
                float damage;
                float currentHurt = entity.f_20916_;
                float lastHurt = this.lastHurthMap.getOrDefault(entity.m_20148_(), Float.valueOf(0.0f)).floatValue();
                if (currentHurt > 0.0f && lastHurt == 0.0f && (damage = DamageCache.consumeDamage(entity)) > 0.0f) {
                    int energyGain = (int)(Math.pow(damage, 1.5) * 20.0);
                    this.energyStorage.receiveEnergy(energyGain, false);
                }
                this.lastHurthMap.put(entity.m_20148_(), Float.valueOf(currentHurt));
            }
            for (Direction dir : Direction.values()) {
                BlockEntity neighbor = level.m_7702_(pos.m_121945_(dir));
                if (neighbor == null) continue;
                neighbor.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).ifPresent(storage -> {
                    int sent = this.energyStorage.extractEnergy(this.energyStorage.getMaxEnergyStored(), true);
                    int received = storage.receiveEnergy(sent, false);
                    this.energyStorage.extractEnergy(received, false);
                });
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCap.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Energy", this.energyStorage.getEnergyStored());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Energy")) {
            this.energyStorage.setEnergy(tag.m_128451_("Energy"));
        }
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void onLoad() {
        super.onLoad();
        this.m_6596_();
    }
}

