/*
 * Decompiled with CFR 0.152.
 */
package jp.nogami_rion.alchemical_power.registry;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModFluids {
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"alchemical_power");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUIDS, (String)"alchemical_power");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"alchemical_power");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"alchemical_power");
    public static final FluidEntry T1_PANAKEIA = ModFluids.registerMolten("t1_panakeia_ingot", -3342337, 700, 8);
    public static final FluidEntry T2_PANAKEIA = ModFluids.registerMolten("t2_panakeia_ingot", -154, 800, 8);
    public static final FluidEntry T3_PANAKEIA = ModFluids.registerMolten("t3_panakeia_ingot", -39322, 900, 10);
    public static final FluidEntry T4_PANAKEIA = ModFluids.registerMolten("t4_panakeia_gem", -52225, 1000, 10);
    public static final FluidEntry T5_PANAKEIA = ModFluids.registerMolten("t5_panakeia_gem", -6710785, 1000, 12);
    public static final FluidEntry T6_PANAKEIA = ModFluids.registerMolten("t6_panakeia_ingot", -1, 1300, 12);
    public static final FluidEntry UNITE_ALLOY = ModFluids.registerMolten("unite_alloy", -2011885016, 1400, 12);
    public static final FluidEntry SINGULARITY = ModFluids.registerMolten("singularity", -1572, 1500, 15);

    private ModFluids() {
    }

    private static FluidEntry registerMolten(String baseId, final int argbColor, int temperature, int light) {
        String fluidId = "molten_" + baseId;
        String flowingId = fluidId + "_flowing";
        String bucketId = fluidId + "_bucket";
        final ResourceLocation STILL_TEX = new ResourceLocation("alchemical_power", "fluid/base_molten_ingot_still");
        final ResourceLocation FLOWING_TEX = new ResourceLocation("alchemical_power", "fluid/base_molten_ingot_flowing");
        RegistryObject type = FLUID_TYPES.register(fluidId, () -> new FluidType(FluidType.Properties.create().lightLevel(light).temperature(temperature).viscosity(3000).density(3000).canDrown(false).supportsBoating(false)){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){

                    public ResourceLocation getStillTexture() {
                        return STILL_TEX;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FLOWING_TEX;
                    }

                    public int getTintColor() {
                        return argbColor;
                    }
                });
            }
        });
        ForgeFlowingFluid.Properties[] holder = new ForgeFlowingFluid.Properties[1];
        RegistryObject source = FLUIDS.register(fluidId, () -> new ForgeFlowingFluid.Source(holder[0]));
        RegistryObject flowing = FLUIDS.register(flowingId, () -> new ForgeFlowingFluid.Flowing(holder[0]));
        RegistryObject block = BLOCKS.register(fluidId, () -> new LiquidBlock((Supplier)source, BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(100.0f).m_60953_(s -> light).m_222994_().m_280170_()));
        RegistryObject bucket = ITEMS.register(bucketId, () -> new BucketItem((Supplier)source, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
        holder[0] = new ForgeFlowingFluid.Properties((Supplier)type, (Supplier)source, (Supplier)flowing).bucket((Supplier)bucket).block((Supplier)block).slopeFindDistance(3).levelDecreasePerBlock(1);
        return new FluidEntry((RegistryObject<FluidType>)type, (RegistryObject<FlowingFluid>)source, (RegistryObject<FlowingFluid>)flowing, (RegistryObject<LiquidBlock>)block, (RegistryObject<Item>)bucket, holder[0]);
    }

    public static void register(IEventBus bus) {
        FLUID_TYPES.register(bus);
        FLUIDS.register(bus);
        BLOCKS.register(bus);
        ITEMS.register(bus);
    }

    public static final class FluidEntry {
        public final RegistryObject<FluidType> type;
        public final RegistryObject<FlowingFluid> source;
        public final RegistryObject<FlowingFluid> flowing;
        public final RegistryObject<LiquidBlock> block;
        public final RegistryObject<Item> bucket;
        public final ForgeFlowingFluid.Properties props;

        private FluidEntry(RegistryObject<FluidType> type, RegistryObject<FlowingFluid> source, RegistryObject<FlowingFluid> flowing, RegistryObject<LiquidBlock> block, RegistryObject<Item> bucket, ForgeFlowingFluid.Properties props) {
            this.type = type;
            this.source = source;
            this.flowing = flowing;
            this.block = block;
            this.bucket = bucket;
            this.props = props;
        }
    }
}

