/*
 * Decompiled with CFR 0.152.
 */
package jp.nogami_rion.alchemical_power.block.entity;

import jp.nogami_rion.alchemical_power.block.CobblestoneGeneratorMk5;
import jp.nogami_rion.alchemical_power.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CobblestoneGeneratorMk5Entity
extends BlockEntity {
    private final ItemStackHandler itemHandler = new LargeStackItemHandler(1, this);
    private Item product;
    private static final int SLOT = 0;
    private long itemCount = 0L;
    private final long genStackCount = 27L;
    private LazyOptional<IItemHandler> LazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 2;

    public CobblestoneGeneratorMk5Entity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.COBBLESTONE_GENERATOR_MK5_BE.get(), pPos, pBlockState);
        Block block = pBlockState.m_60734_();
        if (block instanceof CobblestoneGeneratorMk5) {
            CobblestoneGeneratorMk5 block2 = (CobblestoneGeneratorMk5)block;
            this.product = block2.getProduct();
        }
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> CobblestoneGeneratorMk5Entity.this.progress;
                    case 1 -> CobblestoneGeneratorMk5Entity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        CobblestoneGeneratorMk5Entity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        CobblestoneGeneratorMk5Entity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.LazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.LazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.LazyItemHandler.invalidate();
    }

    public void drops() {
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128356_("itemCount", this.itemCount);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemCount = pTag.m_128454_("itemCount");
        this.updateStack();
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        this.increaseCraftingProgress();
        if (this.hasProgressFinished()) {
            this.craftItem();
            this.resetProgress();
        }
    }

    public void use(Player player) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        Component itemName = this.itemHandler.getStackInSlot(0).m_41611_();
        int count = stack.m_41613_();
        if (this.itemCount > 0L) {
            int dropAmount = (int)Math.min(this.itemCount, 64L);
            ItemStack toGive = new ItemStack((ItemLike)this.product, dropAmount);
            if (!player.m_6144_()) {
                boolean added = player.m_36356_(toGive.m_41777_());
                if (!added) {
                    Containers.m_18992_((Level)this.f_58857_, (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (ItemStack)toGive);
                }
                this.itemCount -= (long)dropAmount;
                this.updateStack();
                player.m_5661_((Component)Component.m_237110_((String)"message.alchemical_power.cobblegen.remaining", (Object[])new Object[]{itemName, this.itemCount}), true);
            } else {
                player.m_5661_((Component)Component.m_237110_((String)"message.alchemical_power.cobblegen.remaining", (Object[])new Object[]{itemName, this.itemCount}), true);
            }
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        if (this.itemCount + 27L > Long.MAX_VALUE) {
            this.itemCount = Long.MAX_VALUE;
            this.updateStack();
        } else {
            this.itemCount += 27L;
            this.updateStack();
        }
    }

    private void updateStack() {
        int displayCount = (int)Math.min(this.itemCount, Integer.MAX_VALUE);
        this.itemHandler.setStackInSlot(0, this.itemCount > 0L ? new ItemStack((ItemLike)this.product, displayCount) : ItemStack.f_41583_);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    public void m_187476_(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        stack.m_41700_("BlockEntityTag", (Tag)tag);
    }

    public void loadFromItem(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BlockEntityTag")) {
            CompoundTag tag = stack.m_41783_().m_128469_("BlockEntityTag");
            this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        }
    }

    public static class LargeStackItemHandler
    extends ItemStackHandler {
        private final CobblestoneGeneratorMk5Entity parent;

        public LargeStackItemHandler(int slots, CobblestoneGeneratorMk5Entity parent) {
            super(slots);
            this.parent = parent;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.parent.itemCount <= 0L) {
                return ItemStack.f_41583_;
            }
            int extractAmount = (int)Math.min((long)amount, Math.min(this.parent.itemCount, Integer.MAX_VALUE));
            ItemStack extracted = new ItemStack((ItemLike)this.parent.product, extractAmount);
            if (!simulate) {
                this.parent.itemCount -= (long)extractAmount;
                this.parent.updateStack();
            }
            return extracted;
        }

        public int getStackLimit(int slot, @NotNull ItemStack stack) {
            return Integer.MAX_VALUE;
        }
    }
}

