/*
 * Decompiled with CFR 0.152.
 */
package jp.nogami_rion.alchemical_power.block.entity;

import java.util.Optional;
import java.util.Set;
import jp.nogami_rion.alchemical_power.block.entity.ModBlockEntities;
import jp.nogami_rion.alchemical_power.init.itemlist;
import jp.nogami_rion.alchemical_power.recipe.Rune_Activator_Recipe;
import jp.nogami_rion.alchemical_power.screen.Rune_Activator_Menu;
import jp.nogami_rion.alchemical_power.util.ConfigurableItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Rune_Activator_Entity
extends BlockEntity
implements MenuProvider {
    private final ConfigurableItemHandler itemHandler = new ConfigurableItemHandler(3, Set.of(Integer.valueOf(0), Integer.valueOf(1)), Set.of(Integer.valueOf(2))){

        protected void onContentsChanged(int slot) {
            Rune_Activator_Entity.this.m_6596_();
            if (!Rune_Activator_Entity.this.f_58857_.m_5776_()) {
                Rune_Activator_Entity.this.f_58857_.m_7260_(Rune_Activator_Entity.this.m_58899_(), Rune_Activator_Entity.this.m_58900_(), Rune_Activator_Entity.this.m_58900_(), 3);
            }
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int INPUT_SLOT2 = 1;
    private static final int OUTPUT_SLOT = 2;
    private LazyOptional<IItemHandler> LazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> Rune_Activator_Entity.this.progress;
                case 1 -> Rune_Activator_Entity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    Rune_Activator_Entity.this.progress = pValue;
                    break;
                }
                case 1: {
                    Rune_Activator_Entity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 40;

    public Rune_Activator_Entity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.RUNE_ACTIVATOR_BE.get(), pPos, pBlockState);
    }

    public ItemStack getRenderStack() {
        if (this.itemHandler.getStackInSlot(2).m_41619_()) {
            return this.itemHandler.getStackInSlot(1);
        }
        return this.itemHandler.getStackInSlot(2);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.LazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.LazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.LazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.alchemical_power.rune_activator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new Rune_Activator_Menu(i, inventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("rune_activator_progress", this.progress);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("rune_activator_progress");
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.hasRecipe()) {
            this.increaseCraftingProgress();
            Rune_Activator_Entity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<Rune_Activator_Recipe> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            ItemStack result = recipe.get().m_8043_(null);
            this.extractItem();
            this.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(2).m_41613_() + result.m_41613_()));
            return;
        }
        ItemStack rune = this.itemHandler.getStackInSlot(0);
        ItemStack cloneTarget = this.itemHandler.getStackInSlot(1).m_41777_();
        if (rune.m_41720_() == itemlist.RUNE_OF_REPRODUCTION.get() && !cloneTarget.m_41619_()) {
            ItemStack clone = cloneTarget.m_41777_();
            clone.m_41764_(64);
            ItemStack output = this.itemHandler.getStackInSlot(2);
            if (output.m_41619_() || output.m_150930_(clone.m_41720_())) {
                this.itemHandler.setStackInSlot(2, clone);
            } else {
                output.m_41769_(1);
            }
        }
    }

    public void extractItem() {
        for (int i : new int[]{1}) {
            this.itemHandler.extractItem(i, 1, false);
        }
        ItemStack _stk = this.itemHandler.getStackInSlot(0).m_41777_();
        if (_stk.m_220157_(1, RandomSource.m_216327_(), null)) {
            _stk.m_41774_(1);
            _stk.m_41721_(0);
        }
        this.itemHandler.setStackInSlot(0, _stk);
    }

    private boolean hasRecipe() {
        Optional<Rune_Activator_Recipe> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            ItemStack result = recipe.get().m_8043_(null);
            return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
        }
        ItemStack rune = this.itemHandler.getStackInSlot(0);
        ItemStack items = this.itemHandler.getStackInSlot(1);
        if (rune.m_41720_() == itemlist.RUNE_OF_REPRODUCTION.get() && !items.m_41619_()) {
            return this.canInsertAmountIntoOutputSlot(1) && this.canInsertItemIntoOutputSlot(items.m_41720_());
        }
        return false;
    }

    private Optional<Rune_Activator_Recipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)Rune_Activator_Recipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(2).m_41619_() || this.itemHandler.getStackInSlot(2).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(2).m_41613_() + count <= this.itemHandler.getStackInSlot(2).m_41741_();
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

