/*
 * Decompiled with CFR 0.152.
 */
package jp.nogami_rion.alchemical_power.integration.tinker.modifier;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import jp.nogami_rion.alchemical_power.util.DeadEndRainbowUtils;
import jp.nogami_rion.alchemical_power.util.ModDamageTypes;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public class SingularityModifier
extends Modifier
implements ProjectileHitModifierHook,
MeleeHitModifierHook,
OnAttackedModifierHook,
ProtectionModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT, ModifierHooks.ON_ATTACKED, ModifierHooks.PROTECTION});
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        Player attacker = context.getPlayerAttacker();
        if (!target.m_9236_().f_46443_ && target instanceof LivingEntity) {
            DeadEndRainbowUtils.applyAttackMark(target);
            int count = DeadEndRainbowUtils.getAttackMark(target);
            List<Vec3> colors = List.of(new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 0.5, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.5, 0.0, 1.0));
            Level level = target.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < count && i < colors.size(); ++i) {
                    Vec3 color = colors.get(i);
                    serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_), 2.0f), target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 5, 0.2, 0.2, 0.2, 0.0);
                }
            }
            if (count >= 7) {
                ServerLevel level2 = (ServerLevel)target.m_9236_();
                DamageSource singularity = ModDamageTypes.singularityTrue(level2, (LivingEntity)attacker);
                float maxHealth = target.m_21233_();
                target.m_6469_(singularity, maxHealth * 2.0f);
                if (target.m_6084_()) {
                    target.m_6074_();
                }
                if (target.m_6084_()) {
                    target.m_21153_(0.0f);
                    target.m_6667_(singularity);
                }
                DeadEndRainbowUtils.resetAttackMark(target);
            }
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (!target.m_9236_().f_46443_ && target != attacker && target instanceof LivingEntity) {
            DeadEndRainbowUtils.applyAttackMark(target);
            int count = DeadEndRainbowUtils.getAttackMark(target);
            List<Vec3> colors = List.of(new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 0.5, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.5, 0.0, 1.0));
            Level level = target.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < count && i < colors.size(); ++i) {
                    Vec3 color = colors.get(i);
                    serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_), 2.0f), target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 5, 0.2, 0.2, 0.2, 0.0);
                }
            }
            if (count >= 7) {
                ServerLevel level2 = (ServerLevel)target.m_9236_();
                DamageSource singularity = ModDamageTypes.singularityTrue(level2, attacker);
                float maxHealth = target.m_21233_();
                target.m_6469_(singularity, maxHealth * 2.0f);
                if (target.m_6084_()) {
                    target.m_6074_();
                }
                if (target.m_6084_()) {
                    target.m_21153_(0.0f);
                    target.m_6667_(singularity);
                }
                DeadEndRainbowUtils.resetAttackMark(target);
            }
        }
        return false;
    }

    public void onAttacked(IToolStackView iToolStackView, ModifierEntry modifierEntry, EquipmentContext equipmentContext, EquipmentSlot equipmentSlot, DamageSource damageSource, float amount, boolean b) {
        LivingEntity trueAttacker;
        Projectile proj;
        Entity owner;
        LivingEntity wearer = equipmentContext.getEntity();
        Entity attacker = null;
        Entity direct = damageSource.m_7640_();
        if (direct != null && direct instanceof Projectile && (owner = (proj = (Projectile)direct).m_19749_()) != null) {
            attacker = owner;
        }
        if (attacker == null) {
            attacker = damageSource.m_7639_();
        }
        if (attacker == null) {
            attacker = direct;
        }
        if (attacker == null) {
            return;
        }
        if (iToolStackView.hasTag(TinkerTags.Items.ARMOR) && attacker instanceof LivingEntity && (trueAttacker = (LivingEntity)attacker) != wearer && !trueAttacker.m_9236_().f_46443_ && attacker instanceof LivingEntity) {
            float reflected = amount * 2.0f;
            trueAttacker.m_6469_(damageSource, reflected);
            DeadEndRainbowUtils.applyAttackMark(trueAttacker);
            int count = DeadEndRainbowUtils.getAttackMark(trueAttacker);
            List<Vec3> colors = List.of(new Vec3(1.0, 0.0, 0.0), new Vec3(1.0, 0.5, 0.0), new Vec3(1.0, 1.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 1.0, 1.0), new Vec3(0.0, 0.0, 1.0), new Vec3(0.5, 0.0, 1.0));
            Level level = trueAttacker.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < count && i < colors.size(); ++i) {
                    Vec3 color = colors.get(i);
                    serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f((float)color.f_82479_, (float)color.f_82480_, (float)color.f_82481_), 2.0f), trueAttacker.m_20185_(), trueAttacker.m_20186_() + 1.0, trueAttacker.m_20189_(), 5, 0.2, 0.2, 0.2, 0.0);
                }
            }
            if (count >= 7) {
                ServerLevel level2 = (ServerLevel)trueAttacker.m_9236_();
                DamageSource singularity = ModDamageTypes.singularityTrue(level2, wearer);
                float maxHealth = trueAttacker.m_21233_();
                trueAttacker.m_6469_(singularity, maxHealth * 2.0f);
                if (trueAttacker.m_6084_()) {
                    trueAttacker.m_6074_();
                }
                if (trueAttacker.m_6084_()) {
                    trueAttacker.m_21153_(0.0f);
                    trueAttacker.m_6667_(singularity);
                }
                DeadEndRainbowUtils.resetAttackMark(trueAttacker);
            }
        }
    }

    public float getProtectionModifier(IToolStackView iToolStackView, ModifierEntry modifierEntry, EquipmentContext equipmentContext, EquipmentSlot equipmentSlot, DamageSource damageSource, float v) {
        return 2.1474836E9f;
    }

    @NotNull
    public Component getDisplayName(int level) {
        float hue = (float)(System.currentTimeMillis() % 5000L) / 5000.0f;
        int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
        return Component.m_237113_((String)this.getDisplayName().getString()).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)rgb)));
    }
}

