/*
 * Decompiled with CFR 0.152.
 */
package jp.nogami_rion.alchemical_power.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jp.nogami_rion.alchemical_power.block.entity.ModBlockEntities;
import jp.nogami_rion.alchemical_power.init.itemlist;
import jp.nogami_rion.alchemical_power.recipe.Transcendental_Table_Recipe;
import jp.nogami_rion.alchemical_power.screen.Transcendental_Table_Menu;
import jp.nogami_rion.alchemical_power.util.ConfigurableItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Transcendental_Table_Entity
extends BlockEntity
implements MenuProvider {
    private final ConfigurableItemHandler itemHandler = new ConfigurableItemHandler(171, IntStream.rangeClosed(0, 169).boxed().collect(Collectors.toSet()), Set.of(Integer.valueOf(170)));
    private static final List<Integer> INPUT_SLOT = new ArrayList<Integer>();
    private static int OUTPUT_SLOT;
    private LazyOptional<IItemHandler> LazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> Transcendental_Table_Entity.this.progress;
                case 1 -> Transcendental_Table_Entity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    Transcendental_Table_Entity.this.progress = pValue;
                    break;
                }
                case 1: {
                    Transcendental_Table_Entity.this.maxProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 60;

    public Transcendental_Table_Entity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TRANSCENDENTAL_TABLE_BE.get(), pPos, pBlockState);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (i != this.itemHandler.getSlots() - 1) {
                INPUT_SLOT.add(i);
                continue;
            }
            if (i != this.itemHandler.getSlots() - 1) continue;
            OUTPUT_SLOT = i;
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.LazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.LazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.LazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.alchemical_power.transcendental_table");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new Transcendental_Table_Menu(i, inventory, this, this.data);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("transcendental_table_progress", this.progress);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("transcendental_table_progress");
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!this.itemHandler.getStackInSlot(INPUT_SLOT.get(169)).m_41619_()) {
            if (this.hasRecipe()) {
                Transcendental_Table_Entity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
                this.increaseCraftingProgress();
                if (this.hasProgressFinished()) {
                    this.craftItem();
                    this.resetProgress();
                }
            } else {
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<Transcendental_Table_Recipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        this.extractItem();
        this.itemHandler.setStackInSlot(OUTPUT_SLOT, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(OUTPUT_SLOT).m_41613_() + result.m_41613_()));
    }

    private void extractItem() {
        for (int i = 0; i < this.itemHandler.getSlots() - 1; ++i) {
            if (i != this.itemHandler.getSlots() - 2) {
                this.itemHandler.extractItem(INPUT_SLOT.get(i), 1, false);
                continue;
            }
            if (i != this.itemHandler.getSlots() - 2) continue;
            ItemStack _stk = this.itemHandler.getStackInSlot(INPUT_SLOT.get(i)).m_41777_();
            if (_stk.m_150930_((Item)itemlist.PHILOSOPHERS_STONE.get())) {
                return;
            }
            if (_stk.m_41763_()) {
                if (_stk.m_220157_(1, RandomSource.m_216327_(), null)) {
                    _stk.m_41774_(1);
                    _stk.m_41721_(0);
                }
            } else {
                _stk.m_41774_(1);
            }
            this.itemHandler.setStackInSlot(INPUT_SLOT.get(i), _stk);
        }
    }

    private boolean hasRecipe() {
        Optional<Transcendental_Table_Recipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(null);
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private Optional<Transcendental_Table_Recipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)Transcendental_Table_Recipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(OUTPUT_SLOT).m_41619_() || this.itemHandler.getStackInSlot(OUTPUT_SLOT).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(OUTPUT_SLOT).m_41613_() + count <= this.itemHandler.getStackInSlot(OUTPUT_SLOT).m_41741_();
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }
}

