/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.deep.seek.command.admin;

import cn.handyplus.deep.seek.constants.DeepSeekConstants;
import cn.handyplus.deep.seek.core.DeepSeekUtil;
import cn.handyplus.deep.seek.lib.command.IHandyCommandEvent;
import cn.handyplus.deep.seek.lib.constants.BaseConstants;
import cn.handyplus.deep.seek.lib.core.CollUtil;
import cn.handyplus.deep.seek.lib.core.MapUtil;
import cn.handyplus.deep.seek.lib.core.StrUtil;
import cn.handyplus.deep.seek.lib.util.AssertUtil;
import cn.handyplus.deep.seek.lib.util.BaseUtil;
import cn.handyplus.deep.seek.lib.util.MessageUtil;
import cn.handyplus.deep.seek.param.DeepSeekRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "chat";
    }

    @Override
    public String permission() {
        return "deepSeek.chat";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 3, BaseUtil.getMsgNotColor("paramFailureMsg"));
        String keyName = args[1];
        String role = BaseConstants.CONFIG.getString("chatSystem." + keyName + ".role");
        String name = BaseConstants.CONFIG.getString("chatSystem." + keyName + ".name");
        List loadingList = BaseConstants.CONFIG.getStringList("chatSystem." + keyName + ".loading");
        for (String loading : loadingList) {
            loading = StrUtil.replace(loading, "name", name);
            MessageUtil.sendMessage(sender, loading);
        }
        List messages = DeepSeekRequest.Message.of("system", role);
        DeepSeekRequest.Message userContent = new DeepSeekRequest.Message("user", args[2]);
        Map<String, List> deepSeekNpcParamMap = new HashMap();
        if (BaseUtil.isPlayer(sender).booleanValue()) {
            Player player = (Player)sender;
            deepSeekNpcParamMap = DeepSeekConstants.COMMAND_CHAT_MAP.getOrDefault(player.getUniqueId(), MapUtil.of());
            if (MapUtil.isEmpty(deepSeekNpcParamMap)) {
                messages.add((DeepSeekRequest.Message)userContent);
                deepSeekNpcParamMap.put(keyName, messages);
                DeepSeekConstants.COMMAND_CHAT_MAP.put(player.getUniqueId(), deepSeekNpcParamMap);
            } else {
                List messagesList = (List)deepSeekNpcParamMap.get(keyName);
                if (CollUtil.isEmpty(messagesList)) {
                    messages.add((DeepSeekRequest.Message)userContent);
                    deepSeekNpcParamMap.put(keyName, messages);
                } else {
                    messagesList.add(userContent);
                    messages = messagesList;
                }
            }
        } else {
            messages.add((DeepSeekRequest.Message)userContent);
        }
        List formatList = BaseConstants.CONFIG.getStringList("chatSystem." + keyName + ".format");
        String chat = DeepSeekUtil.chat(messages);
        if (MapUtil.isNotEmpty(deepSeekNpcParamMap)) {
            ((List)deepSeekNpcParamMap.get(keyName)).add(new DeepSeekRequest.Message("assistant", chat));
        }
        for (String format : formatList) {
            format = StrUtil.replace(format, "name", name);
            format = StrUtil.replace(format, "message", chat);
            MessageUtil.sendMessage(sender, format);
        }
    }
}

