/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.deep.seek.core;

import cn.handyplus.deep.seek.constants.DeepSeekConstants;
import cn.handyplus.deep.seek.lib.constants.BaseConstants;
import cn.handyplus.deep.seek.lib.core.HttpUtil;
import cn.handyplus.deep.seek.lib.core.JsonUtil;
import cn.handyplus.deep.seek.lib.core.StrUtil;
import cn.handyplus.deep.seek.lib.util.BaseUtil;
import cn.handyplus.deep.seek.param.DeepSeekRequest;
import cn.handyplus.deep.seek.param.DeepSeekResponse;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class DeepSeekUtil {
    public static String chat(List<DeepSeekRequest.Message> messages) {
        String apiKey = BaseConstants.CONFIG.getString("apiKey");
        if (StrUtil.isEmpty(apiKey)) {
            return BaseUtil.getMsgNotColor("noApikey");
        }
        String baseUrl = BaseConstants.CONFIG.getString("baseUrl");
        if (StrUtil.isNotEmpty(baseUrl)) {
            DeepSeekConstants.DEEP_SEEK_API_URL = baseUrl;
        }
        String model = BaseConstants.CONFIG.getString("model");
        DeepSeekRequest request = new DeepSeekRequest(model, messages, false);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + apiKey);
        String msg = BaseUtil.getMsgNotColor("errorMsg");
        try {
            String responseJson = HttpUtil.post(DeepSeekConstants.DEEP_SEEK_API_URL, JsonUtil.toJson(request), headers);
            DeepSeekResponse response = JsonUtil.toBean(responseJson, DeepSeekResponse.class);
            msg = response.getChoices().get(0).getMessage().getContent();
        }
        catch (Exception exception) {
            Bukkit.getLogger().log(Level.SEVERE, "\u53d1\u751f\u5f02\u5e38", exception);
        }
        return msg;
    }
}

