/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.deep.seek.lib.db;

import cn.handyplus.deep.seek.lib.constants.BaseConstants;
import cn.handyplus.deep.seek.lib.core.BeanUtil;
import cn.handyplus.deep.seek.lib.core.DateUtil;
import cn.handyplus.deep.seek.lib.core.NumberUtil;
import cn.handyplus.deep.seek.lib.core.StrUtil;
import cn.handyplus.deep.seek.lib.db.BaseMapper;
import cn.handyplus.deep.seek.lib.db.DbConstant;
import cn.handyplus.deep.seek.lib.db.DbSql;
import cn.handyplus.deep.seek.lib.db.DbTypeEnum;
import cn.handyplus.deep.seek.lib.db.FieldInfoParam;
import cn.handyplus.deep.seek.lib.db.FieldTypeEnum;
import cn.handyplus.deep.seek.lib.db.IndexEnum;
import cn.handyplus.deep.seek.lib.db.Page;
import cn.handyplus.deep.seek.lib.db.SqlKeyword;
import cn.handyplus.deep.seek.lib.db.SqlManagerUtil;
import cn.handyplus.deep.seek.lib.db.SqlService;
import cn.handyplus.deep.seek.lib.db.TableInfoParam;
import cn.handyplus.deep.seek.lib.util.MessageUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;

public class DbExecution<T>
implements BaseMapper<T> {
    private final Class<T> clazz;
    private final DbSql dbSql;
    private final String storageMethod;
    private final boolean isMysql;
    private final Connection conn;

    protected DbExecution(DbSql dbSql, Class<T> clazz) {
        this.dbSql = dbSql;
        this.clazz = clazz;
        this.storageMethod = SqlManagerUtil.getInstance().getStorageMethod();
        this.isMysql = !DbTypeEnum.SQLite.getType().equalsIgnoreCase(this.storageMethod);
        this.conn = SqlManagerUtil.getInstance().getConnection(this.storageMethod);
    }

    protected DbExecution(DbSql dbSql, Class<T> clazz, boolean initConn) {
        this.dbSql = dbSql;
        this.clazz = clazz;
        this.storageMethod = SqlManagerUtil.getInstance().getStorageMethod();
        this.isMysql = !DbTypeEnum.SQLite.getType().equalsIgnoreCase(this.storageMethod);
        this.conn = initConn ? SqlManagerUtil.getInstance().getConnection(this.storageMethod) : null;
    }

    protected DbExecution(DbSql dbSql, Class<T> clazz, Connection conn) {
        this.dbSql = dbSql;
        this.clazz = clazz;
        this.storageMethod = SqlManagerUtil.getInstance().getStorageMethod();
        this.isMysql = !DbTypeEnum.SQLite.getType().equalsIgnoreCase(this.storageMethod);
        this.conn = conn;
    }

    protected DbExecution(DbSql dbSql, Class<T> clazz, String storageMethod) {
        this.dbSql = dbSql;
        this.clazz = clazz;
        this.storageMethod = storageMethod;
        this.isMysql = !DbTypeEnum.SQLite.getType().equalsIgnoreCase(storageMethod);
        this.conn = SqlManagerUtil.getInstance().getConnection(storageMethod);
    }

    protected void create() {
        TableInfoParam tableInfoParam = this.dbSql.getTableInfoParam();
        String createTable = this.isMysql ? "CREATE TABLE IF NOT EXISTS `%s` (`id` INTEGER (11) AUTO_INCREMENT,PRIMARY KEY (`id`)) CHARACTER SET = utf8mb4 ENGINE=INNODB;" : "CREATE TABLE IF NOT EXISTS `%s` ( `id` INTEGER PRIMARY KEY AUTOINCREMENT);";
        String createTableSql = String.format(createTable, tableInfoParam.getTableName());
        this.printSql(createTableSql, "createTableSql: ");
        SqlService.getInstance().executionSql(createTableSql, this.storageMethod);
        if (this.isMysql) {
            String tableCommentSql = String.format("ALTER TABLE `%s` COMMENT '%s';", tableInfoParam.getTableName(), tableInfoParam.getTableComment());
            this.printSql(tableCommentSql, "tableCommentSql: ");
            SqlService.getInstance().executionSql(tableCommentSql, this.storageMethod);
        }
        this.addColumn(tableInfoParam.getTableName(), this.dbSql.getFieldInfoMap());
        this.addIndex(tableInfoParam.getTableName());
    }

    private void addColumn(String tableName, LinkedHashMap<String, FieldInfoParam> fieldInfoMap) {
        String sql;
        if (this.isMysql) {
            String database = BaseConstants.STORAGE_CONFIG.getString("MySQL.Database");
            sql = String.format("SELECT column_name FROM information_schema.COLUMNS WHERE table_name = '%s' AND table_schema = '%s';", tableName, database);
        } else {
            sql = String.format("PRAGMA table_info ( %s )", tableName);
        }
        this.printSql(sql, "addColumnSelectSql: ");
        List<String> fieldNameList = SqlService.getInstance().getTableInfo(sql, this.storageMethod);
        for (String fieldName : fieldInfoMap.keySet()) {
            String fieldSql;
            FieldInfoParam fieldInfoParam = fieldInfoMap.get(fieldName);
            FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getEnum(fieldInfoParam);
            if (!fieldNameList.contains(fieldName)) {
                String fieldSql2;
                String addColumn;
                String string = addColumn = this.isMysql ? "ALTER TABLE `%s` ADD `%s` %s(%s) %s;" : "ALTER TABLE '%s' ADD '%s' %s(%s) %s;";
                if (this.isMysql) {
                    String string2 = fieldSql2 = fieldInfoParam.getFieldNotNull() != false ? "NOT NULL" : "";
                    if (StrUtil.isNotEmpty(fieldInfoParam.getFieldDefault())) {
                        fieldSql2 = fieldSql2 + String.format(" DEFAULT '%s'", fieldInfoParam.getFieldDefault());
                    }
                } else {
                    String string3 = fieldSql2 = fieldInfoParam.getFieldNotNull() != false ? "NOT NULL" : "";
                    if (StrUtil.isNotEmpty(fieldInfoParam.getFieldDefault())) {
                        fieldSql2 = fieldSql2 + String.format(" DEFAULT '%s'", fieldInfoParam.getFieldDefault());
                    } else if (fieldInfoParam.getFieldNotNull().booleanValue()) {
                        fieldSql2 = fieldSql2 + String.format(" DEFAULT '%s'", "");
                    }
                }
                Integer fieldLength = fieldInfoParam.getFieldLength() != 0 ? fieldInfoParam.getFieldLength() : fieldTypeEnum.getLength();
                String mysqlType = fieldTypeEnum.getMysqlType();
                String fieldLengthStr = fieldLength.toString();
                if (FieldTypeEnum.DOUBLE.getMysqlType().equals(mysqlType) || FieldTypeEnum.BASIC_DOUBLE.getMysqlType().equals(mysqlType)) {
                    fieldLengthStr = fieldLength + ", 2";
                }
                String createFieldSql = String.format(addColumn, tableName, fieldInfoParam.getFieldName(), mysqlType, fieldLengthStr, fieldSql2);
                createFieldSql = createFieldSql.replace("(0)", "");
                this.printSql(createFieldSql, "addColumnSql: ");
                SqlService.getInstance().executionSql(createFieldSql, this.storageMethod);
            }
            if (!this.isMysql) continue;
            String string = fieldSql = fieldInfoParam.getFieldNotNull() != false ? "NOT NULL" : "";
            if ("id".equals(fieldName)) {
                fieldSql = "NOT NULL AUTO_INCREMENT";
            }
            if (StrUtil.isNotEmpty(fieldInfoParam.getFieldDefault())) {
                fieldSql = fieldSql + String.format(" DEFAULT '%s'", fieldInfoParam.getFieldDefault());
            }
            if (StrUtil.isNotEmpty(fieldInfoParam.getFieldComment())) {
                fieldSql = fieldSql + String.format(" COMMENT '%s'", fieldInfoParam.getFieldComment());
            }
            Integer fieldLength = fieldInfoParam.getFieldLength() != 0 ? fieldInfoParam.getFieldLength() : fieldTypeEnum.getLength();
            String mysqlType = fieldTypeEnum.getMysqlType();
            String fieldLengthStr = fieldLength.toString();
            if (FieldTypeEnum.DOUBLE.getMysqlType().equals(mysqlType) || FieldTypeEnum.BASIC_DOUBLE.getMysqlType().equals(mysqlType)) {
                fieldLengthStr = fieldLength + ", 2";
            }
            String fieldCommentSql = String.format("ALTER TABLE `%s` MODIFY `%s` %s(%s) %s;", tableName, fieldInfoParam.getFieldName(), fieldTypeEnum.getMysqlType(), fieldLengthStr, fieldSql);
            fieldCommentSql = fieldCommentSql.replace("(0)", "");
            this.printSql(fieldCommentSql, "addColumnCommentSql: ");
            SqlService.getInstance().executionSql(fieldCommentSql, this.storageMethod);
        }
    }

    @Override
    public Optional<T> selectById(Integer id) {
        this.dbSql.addCondition(true, "id", SqlKeyword.EQ, id);
        return this.selectOne();
    }

    @Override
    public List<T> selectBatchIds(List<Integer> ids) {
        this.dbSql.addInCondition(true, "id", SqlKeyword.IN, ids);
        return this.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> selectListMap() {
        PreparedStatement ps = null;
        ResultSet rst = null;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String sql = null;
        try {
            sql = this.dbSql.selectDataSql();
            ps = this.conn.prepareStatement(sql);
            this.psSetVal(ps);
            rst = ps.executeQuery();
            ResultSetMetaData rstMetaData = rst.getMetaData();
            while (rst.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= rstMetaData.getColumnCount(); ++i) {
                    map.put(rstMetaData.getColumnName(i), rst.getObject(i));
                }
                list.add(map);
            }
            ArrayList<Map<String, Object>> arrayList = list;
            SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
            this.printSql(sql, "selectListMap: ");
            return arrayList;
        }
        catch (SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "selectListMap \u53d1\u751f\u5f02\u5e38", e);
                SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
                this.printSql(sql, "selectListMap: ");
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
                this.printSql(sql, "selectListMap: ");
                throw throwable;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<T> selectOne() {
        String sql;
        ResultSet rst;
        PreparedStatement ps;
        block7: {
            ps = null;
            rst = null;
            sql = null;
            sql = this.dbSql.selectDataSql();
            ps = this.conn.prepareStatement(sql);
            this.psSetVal(ps);
            rst = ps.executeQuery();
            if (rst.isBeforeFirst()) break block7;
            Optional optional = Optional.empty();
            SqlManagerUtil.getInstance().closeSql(this.conn, ps, rst);
            this.printSql(sql, "selectOne: ");
            return optional;
        }
        try {
            Constructor<T> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T newInstance = constructor.newInstance(new Object[0]);
            LinkedHashMap<String, FieldInfoParam> fieldInfoMap = this.dbSql.getFieldInfoMap();
            while (rst.next()) {
                for (String fieldName : fieldInfoMap.keySet()) {
                    FieldInfoParam fieldInfoParam = fieldInfoMap.get(fieldName);
                    Object obj = rst.getObject(fieldInfoParam.getFieldName());
                    if (obj == null) continue;
                    obj = this.specialHandling(fieldInfoParam, obj);
                    Field field = this.clazz.getDeclaredField(fieldInfoParam.getFieldRealName());
                    field.setAccessible(true);
                    field.set(newInstance, obj);
                }
            }
            Optional<T> optional = Optional.of(newInstance);
            SqlManagerUtil.getInstance().closeSql(this.conn, ps, rst);
            this.printSql(sql, "selectOne: ");
            return optional;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "selectOne \u53d1\u751f\u5f02\u5e38", e);
                SqlManagerUtil.getInstance().closeSql(this.conn, ps, rst);
                this.printSql(sql, "selectOne: ");
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(this.conn, ps, rst);
                this.printSql(sql, "selectOne: ");
                throw throwable;
            }
        }
        return Optional.empty();
    }

    @Override
    public int count() {
        return this.count(null);
    }

    @Override
    public int count(String field) {
        return this.count(field, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int count(String field, boolean isClose) {
        PreparedStatement ps = null;
        ResultSet rst = null;
        int count = 0;
        String sql = null;
        try {
            sql = this.dbSql.selectCountSql(field);
            ps = this.conn.prepareStatement(sql);
            this.psSetVal(ps);
            rst = ps.executeQuery();
            while (rst.next()) {
                count = rst.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "count \u53d1\u751f\u5f02\u5e38", e);
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(isClose ? this.conn : null, ps, rst);
                this.printSql(sql, "count: ");
                throw throwable;
            }
            SqlManagerUtil.getInstance().closeSql(isClose ? this.conn : null, ps, rst);
            this.printSql(sql, "count: ");
        }
        SqlManagerUtil.getInstance().closeSql(isClose ? this.conn : null, ps, rst);
        this.printSql(sql, "count: ");
        return count;
    }

    @Override
    public List<T> list() {
        return this.list(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<T> list(boolean isClose) {
        ArrayList<T> arrayList;
        String sql;
        ArrayList<T> list;
        ResultSet rst;
        PreparedStatement ps;
        block7: {
            ps = null;
            rst = null;
            list = new ArrayList<T>();
            sql = null;
            sql = this.dbSql.selectDataSql();
            ps = this.conn.prepareStatement(sql);
            this.psSetVal(ps);
            rst = ps.executeQuery();
            if (rst.isBeforeFirst()) break block7;
            ArrayList<T> arrayList2 = list;
            SqlManagerUtil.getInstance().closeSql(isClose ? this.conn : null, ps, rst);
            this.printSql(sql, "list: ");
            return arrayList2;
        }
        try {
            LinkedHashMap<String, FieldInfoParam> fieldInfoMap = this.dbSql.getFieldInfoMap();
            while (rst.next()) {
                Constructor<T> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                T newInstance = constructor.newInstance(new Object[0]);
                for (String fieldName : fieldInfoMap.keySet()) {
                    FieldInfoParam fieldInfoParam = fieldInfoMap.get(fieldName);
                    Object obj = rst.getObject(fieldInfoParam.getFieldName());
                    if (obj == null) continue;
                    obj = this.specialHandling(fieldInfoParam, obj);
                    Field field = this.clazz.getDeclaredField(fieldInfoParam.getFieldRealName());
                    field.setAccessible(true);
                    field.set(newInstance, obj);
                }
                list.add(newInstance);
            }
            arrayList = list;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "list \u53d1\u751f\u5f02\u5e38", e);
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(isClose ? this.conn : null, ps, rst);
                this.printSql(sql, "list: ");
                throw throwable;
            }
            SqlManagerUtil.getInstance().closeSql(isClose ? this.conn : null, ps, rst);
            this.printSql(sql, "list: ");
            return list;
        }
        SqlManagerUtil.getInstance().closeSql(isClose ? this.conn : null, ps, rst);
        this.printSql(sql, "list: ");
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page<T> page() {
        try {
            int count = this.count(null, false);
            List<Object> list = new ArrayList();
            if (count > 0) {
                list = this.list(false);
            }
            Page page = new Page(count, list);
            return page;
        }
        finally {
            SqlManagerUtil.getInstance().closeSql(this.conn, null, null);
        }
    }

    @Override
    public int insert(T obj) {
        if (this.isMysql) {
            return this.baseInsert(obj);
        }
        try {
            boolean lock = DbConstant.SQLITE_LOCK.tryLock(1L, TimeUnit.MINUTES);
            if (lock) {
                int n = this.baseInsert(obj);
                return n;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            DbConstant.SQLITE_LOCK.unlock();
        }
        return 0;
    }

    @Override
    public boolean insertBatch(List<T> objList) {
        if (this.isMysql) {
            return this.baseInsertBatch(objList);
        }
        try {
            boolean lock = DbConstant.SQLITE_LOCK.tryLock(1L, TimeUnit.MINUTES);
            if (lock) {
                boolean bl = this.baseInsertBatch(objList);
                return bl;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            DbConstant.SQLITE_LOCK.unlock();
        }
        return false;
    }

    @Override
    public int updateById(Integer id) {
        this.dbSql.addCondition(true, "id", SqlKeyword.EQ, id);
        return this.update();
    }

    @Override
    public int update() {
        if (this.isMysql) {
            return this.baseUpdate();
        }
        try {
            boolean lock = DbConstant.SQLITE_LOCK.tryLock(1L, TimeUnit.MINUTES);
            if (lock) {
                int n = this.baseUpdate();
                return n;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            DbConstant.SQLITE_LOCK.unlock();
        }
        return 0;
    }

    @Override
    public int deleteById(Integer id) {
        this.dbSql.addCondition(true, "id", SqlKeyword.EQ, id);
        return this.delete();
    }

    @Override
    public int deleteBatchIds(List<Integer> ids) {
        this.dbSql.addInCondition(true, "id", SqlKeyword.IN, ids);
        return this.delete();
    }

    @Override
    public int delete() {
        if (this.isMysql) {
            return this.baseDelete();
        }
        try {
            boolean lock = DbConstant.SQLITE_LOCK.tryLock(1L, TimeUnit.MINUTES);
            if (lock) {
                int n = this.baseDelete();
                return n;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            DbConstant.SQLITE_LOCK.unlock();
        }
        return 0;
    }

    private Object specialHandling(FieldInfoParam fieldInfoParam, Object obj) {
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getEnum(fieldInfoParam);
        switch (fieldTypeEnum) {
            case DATE: {
                if (!this.isMysql) {
                    String str = obj.toString();
                    obj = new Date(Long.parseLong(str));
                    break;
                }
                if (!(obj instanceof LocalDateTime)) break;
                obj = DateUtil.toDate((LocalDateTime)obj);
                break;
            }
            case BOOLEAN: 
            case BASIC_BOOLEAN: {
                if (!(obj instanceof Integer)) break;
                Integer bool = (Integer)obj;
                obj = bool == 1;
                break;
            }
            case LONG: 
            case BASIC_LONG: {
                if (!(obj instanceof Integer)) break;
                Integer number = (Integer)obj;
                obj = number.longValue();
                break;
            }
            case BIG_DECIMAL: {
                obj = NumberUtil.isNumericToBigDecimal(String.valueOf(obj), BigDecimal.ZERO);
                break;
            }
            case UUID: {
                if ("".equals(obj)) {
                    obj = null;
                }
                if (obj == null) break;
                obj = UUID.fromString(String.valueOf(obj));
                break;
            }
        }
        return obj;
    }

    private void addIndex(String tableName) {
        if (!this.isMysql) {
            return;
        }
        String showIndexSql = String.format("SHOW INDEX FROM %s;", tableName);
        this.printSql(showIndexSql, "showIndexSql: ");
        List<String> mysqlTableIndexList = SqlService.getInstance().getMysqlTableIndex(showIndexSql, this.storageMethod);
        for (String fieldName : this.dbSql.getFieldInfoMap().keySet()) {
            FieldInfoParam fieldInfoParam = this.dbSql.getFieldInfoMap().get(fieldName);
            if (IndexEnum.NOT.equals((Object)fieldInfoParam.getIndexEnum()) || mysqlTableIndexList.contains(fieldName)) continue;
            String indexName = fieldName;
            indexName = IndexEnum.UNIQUE.equals((Object)fieldInfoParam.getIndexEnum()) ? "un_" + indexName : "idx_" + indexName;
            String addIndexSql = String.format("ALTER TABLE %s ADD INDEX %s (%s);", tableName, indexName, fieldName);
            this.printSql(addIndexSql, "addIndexSql: ");
            SqlService.getInstance().executionSql(addIndexSql, this.storageMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int baseInsert(T obj) {
        PreparedStatement ps = null;
        ResultSet rst = null;
        try {
            String sql = this.dbSql.insertDataSql();
            MessageUtil.sendConsoleDebugMessage("insert: " + sql);
            ps = this.conn.prepareStatement(sql, 1);
            Map<String, FieldInfoParam> fieldInfoParamMap = this.dbSql.getFieldInfoMap().values().stream().collect(Collectors.groupingBy(FieldInfoParam::getFieldRealName, Collectors.collectingAndThen(Collectors.toList(), value -> (FieldInfoParam)value.get(0))));
            Map<String, Object> paramMap = BeanUtil.beanToMap(obj);
            for (String key : paramMap.keySet()) {
                FieldInfoParam fieldInfoParam = fieldInfoParamMap.get(key);
                if (fieldInfoParam == null) continue;
                Object paramObj = paramMap.get(key);
                if (FieldTypeEnum.UUID.getJavaType().equals(fieldInfoParam.getFieldType()) && paramObj != null) {
                    ps.setString(fieldInfoParam.getFieldIndex(), paramObj.toString());
                    continue;
                }
                ps.setObject(fieldInfoParam.getFieldIndex(), paramObj);
            }
            ps.executeUpdate();
            int id = 0;
            rst = ps.getGeneratedKeys();
            if (rst.next()) {
                id = rst.getInt(1);
            }
            int n = id;
            SqlManagerUtil.getInstance().closeSql(this.conn, ps, rst);
            return n;
        }
        catch (SQLException e) {
            Bukkit.getLogger().log(Level.SEVERE, "baseInsert \u53d1\u751f\u5f02\u5e38", e);
        }
        finally {
            SqlManagerUtil.getInstance().closeSql(this.conn, ps, rst);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean baseInsertBatch(List<T> objList) {
        PreparedStatement ps = null;
        boolean autoCommit = true;
        try {
            String sql = this.dbSql.insertDataSql();
            MessageUtil.sendConsoleDebugMessage("insertBatch: " + sql);
            autoCommit = this.conn.getAutoCommit();
            if (autoCommit) {
                this.conn.setAutoCommit(false);
            }
            ps = this.conn.prepareStatement(sql, 1);
            Map<String, FieldInfoParam> fieldInfoParamMap = this.dbSql.getFieldInfoMap().values().stream().collect(Collectors.groupingBy(FieldInfoParam::getFieldRealName, Collectors.collectingAndThen(Collectors.toList(), value -> (FieldInfoParam)value.get(0))));
            for (int i = 0; i < objList.size(); ++i) {
                Map<String, Object> paramMap = BeanUtil.beanToMap(objList.get(i));
                for (String key : paramMap.keySet()) {
                    FieldInfoParam fieldInfoParam = fieldInfoParamMap.get(key);
                    if (fieldInfoParam == null) continue;
                    Object paramObj = paramMap.get(key);
                    if (FieldTypeEnum.UUID.getJavaType().equals(fieldInfoParam.getFieldType()) && paramObj != null) {
                        ps.setString(fieldInfoParam.getFieldIndex(), paramObj.toString());
                        continue;
                    }
                    ps.setObject(fieldInfoParam.getFieldIndex(), paramObj);
                }
                ps.addBatch();
                if (i == 0 || (i + 1) % 500 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            ps.executeBatch();
            if (autoCommit) {
                this.conn.commit();
            }
            boolean bl = true;
            if (autoCommit) {
                SqlManagerUtil.getInstance().quietSetAutoCommit(this.conn, true);
            }
            SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
            return bl;
        }
        catch (SQLException e) {
            try {
                if (autoCommit) {
                    this.conn.rollback();
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            Bukkit.getLogger().log(Level.SEVERE, "baseInsertBatch \u53d1\u751f\u5f02\u5e38", e);
        }
        finally {
            if (autoCommit) {
                SqlManagerUtil.getInstance().quietSetAutoCommit(this.conn, true);
            }
            SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int baseUpdate() {
        PreparedStatement ps = null;
        String sql = null;
        try {
            sql = this.dbSql.updateDataSql();
            ps = this.conn.prepareStatement(sql);
            LinkedHashMap<Integer, Object> updateFieldMap = this.dbSql.getUpdateFieldMap();
            for (Integer index : updateFieldMap.keySet()) {
                ps.setObject(index, updateFieldMap.get(index));
            }
            this.psSetVal(ps, updateFieldMap.size());
            int n = ps.executeUpdate();
            SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
            this.printSql(sql, "update: ");
            return n;
        }
        catch (SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "baseUpdate \u53d1\u751f\u5f02\u5e38", e);
                SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
                this.printSql(sql, "update: ");
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
                this.printSql(sql, "update: ");
                throw throwable;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int baseDelete() {
        PreparedStatement ps = null;
        String sql = null;
        try {
            sql = this.dbSql.deleteDataSql();
            ps = this.conn.prepareStatement(sql);
            this.psSetVal(ps);
            int n = ps.executeUpdate();
            SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
            this.printSql(sql, "delete: ");
            return n;
        }
        catch (SQLException e) {
            try {
                Bukkit.getLogger().log(Level.SEVERE, "baseDelete \u53d1\u751f\u5f02\u5e38", e);
                SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
                this.printSql(sql, "delete: ");
            }
            catch (Throwable throwable) {
                SqlManagerUtil.getInstance().closeSql(this.conn, ps, null);
                this.printSql(sql, "delete: ");
                throw throwable;
            }
        }
        return 0;
    }

    private void psSetVal(PreparedStatement ps) throws SQLException {
        this.psSetVal(ps, 0);
    }

    private void psSetVal(PreparedStatement ps, Integer size) throws SQLException {
        if (this.dbSql.getWhereMap() == null) {
            return;
        }
        for (Integer index : this.dbSql.getWhereMap().keySet()) {
            ps.setObject(index + size, this.dbSql.getWhereMap().get(index));
        }
    }

    private void printSql(String sql, String method) {
        if (!BaseConstants.DEBUG || StrUtil.isEmpty(sql)) {
            return;
        }
        LinkedHashMap<Integer, Object> whereMap = this.dbSql.getWhereMap();
        LinkedHashMap<Integer, Object> updateFieldMap = this.dbSql.getUpdateFieldMap();
        if (updateFieldMap != null) {
            for (Integer index : updateFieldMap.keySet()) {
                sql = sql.replaceFirst("\\?", updateFieldMap.get(index).toString());
            }
        }
        if (whereMap != null) {
            for (Integer index : whereMap.keySet()) {
                sql = sql.replaceFirst("\\?", whereMap.get(index).toString());
            }
        }
        MessageUtil.sendConsoleDebugMessage(method + sql);
    }
}

