/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.deep.seek.listener;

import cn.handyplus.deep.seek.constants.DeepSeekConstants;
import cn.handyplus.deep.seek.core.DeepSeekUtil;
import cn.handyplus.deep.seek.lib.annotation.HandyListener;
import cn.handyplus.deep.seek.lib.constants.BaseConstants;
import cn.handyplus.deep.seek.lib.core.MapUtil;
import cn.handyplus.deep.seek.lib.core.StrUtil;
import cn.handyplus.deep.seek.lib.util.BaseUtil;
import cn.handyplus.deep.seek.lib.util.MessageUtil;
import cn.handyplus.deep.seek.param.DeepSeekNpcParam;
import cn.handyplus.deep.seek.param.DeepSeekRequest;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@HandyListener
public class NpcChatEventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onAsyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        DeepSeekNpcParam deepSeekNpcParam = DeepSeekConstants.NPC_CHAT_MAP.get(player.getUniqueId());
        if (deepSeekNpcParam == null) {
            return;
        }
        event.setCancelled(true);
        String msg = event.getMessage();
        String stripColorMsg = BaseUtil.stripColor(msg);
        if ("T".equalsIgnoreCase(stripColorMsg)) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("cancelMsg"));
            DeepSeekConstants.NPC_CHAT_MAP.remove(player.getUniqueId());
            return;
        }
        String name = BaseConstants.CONFIG.getString("chatSystem." + deepSeekNpcParam.getKeyName() + ".name");
        String playerFormat = BaseUtil.getMsgNotColor("playerFormat", MapUtil.of("${name}", name, "${message}", msg));
        MessageUtil.sendMessage(player, playerFormat);
        List loadingList = BaseConstants.CONFIG.getStringList("chatSystem." + deepSeekNpcParam.getKeyName() + ".loading");
        for (String loading : loadingList) {
            loading = StrUtil.replace(loading, "name", name);
            MessageUtil.sendMessage(player, loading);
        }
        deepSeekNpcParam.getMessages().add(new DeepSeekRequest.Message("user", msg));
        String chat = DeepSeekUtil.chat(deepSeekNpcParam.getMessages());
        deepSeekNpcParam.getMessages().add(new DeepSeekRequest.Message("assistant", chat));
        List formatList = BaseConstants.CONFIG.getStringList("chatSystem." + deepSeekNpcParam.getKeyName() + ".format");
        for (String format : formatList) {
            format = StrUtil.replace(format, "name", name);
            format = StrUtil.replace(format, "message", chat);
            MessageUtil.sendMessage(player, format);
        }
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("cancel"));
    }
}

