/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.deep.seek.listener;

import cn.handyplus.chat.api.PlayerChatApi;
import cn.handyplus.chat.event.PlayerChannelChatEvent;
import cn.handyplus.deep.seek.DeepSeek;
import cn.handyplus.deep.seek.api.DeepSeekApi;
import cn.handyplus.deep.seek.constants.DeepSeekConstants;
import cn.handyplus.deep.seek.lib.annotation.HandyListener;
import cn.handyplus.deep.seek.lib.constants.BaseConstants;
import cn.handyplus.deep.seek.lib.core.CollUtil;
import cn.handyplus.deep.seek.lib.core.StrUtil;
import cn.handyplus.deep.seek.lib.expand.adapter.HandySchedulerUtil;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

@HandyListener
public class PlayerChannelChatEventListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onEvent(PlayerChannelChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (DeepSeekConstants.CHAT_STATUS) {
            return;
        }
        if (StrUtil.isEmpty(event.getSource())) {
            return;
        }
        if (DeepSeek.INSTANCE.getName().equals(event.getSource())) {
            return;
        }
        List playerChatAiList = BaseConstants.CONFIG.getStringList("playerChatAi");
        if (CollUtil.isEmpty(playerChatAiList)) {
            return;
        }
        String playerChatAi = null;
        boolean playerChatAiName = BaseConstants.CONFIG.getBoolean("playerChatAiName");
        if (playerChatAiName) {
            for (String chatAi : playerChatAiList) {
                if (!event.getOriginalMessage().contains(chatAi)) continue;
                playerChatAi = chatAi;
                break;
            }
        }
        int duration = BaseConstants.CONFIG.getInt("duration", 10);
        if (playerChatAi == null && DeepSeekConstants.DURATION != null && System.currentTimeMillis() - DeepSeekConstants.DURATION < (long)duration * 1000L) {
            playerChatAi = DeepSeekConstants.CACHE_AI_NAME;
        }
        if (StrUtil.isEmpty(playerChatAi)) {
            return;
        }
        String finalPlayerChatAi = playerChatAi;
        HandySchedulerUtil.runTaskAsynchronously(() -> this.aiChat(event, finalPlayerChatAi));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aiChat(PlayerChannelChatEvent event, String playerChatAi) {
        DeepSeekConstants.CHAT_STATUS = true;
        try {
            int playerChatAiSize = BaseConstants.CONFIG.getInt("playerChatAiSize", 10);
            if (DeepSeekConstants.CHAT_LIST.size() >= playerChatAiSize) {
                DeepSeekConstants.CHAT_LIST.remove(0);
            }
            String name = BaseConstants.CONFIG.getString("chatSystem." + playerChatAi + ".name");
            DeepSeekConstants.CHAT_LIST.add(event.getOriginalMessage());
            String chat = DeepSeekApi.chat(playerChatAi, DeepSeekConstants.CHAT_LIST);
            DeepSeekConstants.CHAT_LIST.add(chat);
            List formatList = BaseConstants.CONFIG.getStringList("chatSystem." + playerChatAi + ".format");
            for (String format : formatList) {
                format = StrUtil.replace(format, "name", name);
                format = StrUtil.replace(format, "message", chat);
                format = StrUtil.replace(format, "player", event.getPlayer().getName());
                PlayerChatApi.getInstance().sendMessage(event.getPlayer(), event.getChannel(), format, DeepSeek.INSTANCE.getName());
            }
        }
        catch (Exception exception) {
        }
        finally {
            DeepSeekConstants.CHAT_STATUS = false;
            DeepSeekConstants.DURATION = System.currentTimeMillis();
            DeepSeekConstants.CACHE_AI_NAME = playerChatAi;
        }
    }
}

