/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.egoego.network;

import java.util.function.Supplier;
import net.mcreator.egoego.EgoEgoMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EgoEgoModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        EgoEgoMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        EgoEgoMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.alfa_magic_bullet_tester = message.data.alfa_magic_bullet_tester;
                    variables.beta_magic_bullet_tester = message.data.beta_magic_bullet_tester;
                    variables.x_magic_bullet_tester = message.data.x_magic_bullet_tester;
                    variables.y_magic_bullet_tester = message.data.y_magic_bullet_tester;
                    variables.z_magic_bullet_tester = message.data.z_magic_bullet_tester;
                    variables.konranti = message.data.konranti;
                    variables.konrannsaidaiti = message.data.konrannsaidaiti;
                    variables.run_check = message.data.run_check;
                    variables.golddshoot_chaeck = message.data.golddshoot_chaeck;
                    variables.what_people_want_K = message.data.what_people_want_K;
                    variables.what_pepole_want_N = message.data.what_pepole_want_N;
                    variables.slid_X = message.data.slid_X;
                    variables.sird_Z = message.data.sird_Z;
                    variables.slid = message.data.slid;
                    variables.Spes = message.data.Spes;
                    variables.nikutaikyouka = message.data.nikutaikyouka;
                    variables.kasoku_x = message.data.kasoku_x;
                    variables.kasoku_Z = message.data.kasoku_Z;
                    variables.M = message.data.M;
                    variables.FA = message.data.FA;
                    variables.kaikyuu = message.data.kaikyuu;
                    variables.alfa = message.data.alfa;
                    variables.beta = message.data.beta;
                    variables.O_N_K = message.data.O_N_K;
                    variables.wing_hit = message.data.wing_hit;
                    variables.goukeireberu = message.data.goukeireberu;
                    variables.F_F_K = message.data.F_F_K;
                    variables.F_M_K = message.data.F_M_K;
                    variables.amo = message.data.amo;
                    variables.gekihasuu = message.data.gekihasuu;
                    variables.S_B_K = message.data.S_B_K;
                    variables.si = message.data.si;
                    variables.D_S_F = message.data.D_S_F;
                    variables.aaa = message.data.aaa;
                    variables.ss = message.data.ss;
                    variables.D_F_F = message.data.D_F_F;
                    variables.T_F_B = message.data.T_F_B;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double alfa_magic_bullet_tester = 0.0;
        public double beta_magic_bullet_tester = 0.0;
        public double x_magic_bullet_tester = 0.0;
        public double y_magic_bullet_tester = 0.0;
        public double z_magic_bullet_tester = 0.0;
        public double konranti = 20.0;
        public double konrannsaidaiti = 20.0;
        public double run_check = 0.0;
        public double golddshoot_chaeck = 0.0;
        public double what_people_want_K = 0.0;
        public double what_pepole_want_N = 0.0;
        public double slid_X = 0.0;
        public double sird_Z = 0.0;
        public double slid = 0.0;
        public double Spes = 0.0;
        public double nikutaikyouka = 0.0;
        public double kasoku_x = 0.0;
        public double kasoku_Z = 0.0;
        public double M = 0.0;
        public ItemStack FA = ItemStack.f_41583_;
        public double kaikyuu = 10.0;
        public double alfa = 0.0;
        public double beta = 0.0;
        public double O_N_K = 0.0;
        public double wing_hit = 0.0;
        public double goukeireberu = 0.0;
        public double F_F_K = 0.0;
        public double F_M_K = 0.0;
        public double amo = 0.0;
        public double gekihasuu = 0.0;
        public double S_B_K = 0.0;
        public double si = 0.0;
        public double D_S_F = 0.0;
        public double aaa = 0.0;
        public String ss = "0";
        public double D_F_F = 0.0;
        public double T_F_B = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                EgoEgoMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("alfa_magic_bullet_tester", this.alfa_magic_bullet_tester);
            nbt.m_128347_("beta_magic_bullet_tester", this.beta_magic_bullet_tester);
            nbt.m_128347_("x_magic_bullet_tester", this.x_magic_bullet_tester);
            nbt.m_128347_("y_magic_bullet_tester", this.y_magic_bullet_tester);
            nbt.m_128347_("z_magic_bullet_tester", this.z_magic_bullet_tester);
            nbt.m_128347_("konranti", this.konranti);
            nbt.m_128347_("konrannsaidaiti", this.konrannsaidaiti);
            nbt.m_128347_("run_check", this.run_check);
            nbt.m_128347_("golddshoot_chaeck", this.golddshoot_chaeck);
            nbt.m_128347_("what_people_want_K", this.what_people_want_K);
            nbt.m_128347_("what_pepole_want_N", this.what_pepole_want_N);
            nbt.m_128347_("slid_X", this.slid_X);
            nbt.m_128347_("sird_Z", this.sird_Z);
            nbt.m_128347_("slid", this.slid);
            nbt.m_128347_("Spes", this.Spes);
            nbt.m_128347_("nikutaikyouka", this.nikutaikyouka);
            nbt.m_128347_("kasoku_x", this.kasoku_x);
            nbt.m_128347_("kasoku_Z", this.kasoku_Z);
            nbt.m_128347_("M", this.M);
            nbt.m_128365_("FA", (Tag)this.FA.m_41739_(new CompoundTag()));
            nbt.m_128347_("kaikyuu", this.kaikyuu);
            nbt.m_128347_("alfa", this.alfa);
            nbt.m_128347_("beta", this.beta);
            nbt.m_128347_("O_N_K", this.O_N_K);
            nbt.m_128347_("wing_hit", this.wing_hit);
            nbt.m_128347_("goukeireberu", this.goukeireberu);
            nbt.m_128347_("F_F_K", this.F_F_K);
            nbt.m_128347_("F_M_K", this.F_M_K);
            nbt.m_128347_("amo", this.amo);
            nbt.m_128347_("gekihasuu", this.gekihasuu);
            nbt.m_128347_("S_B_K", this.S_B_K);
            nbt.m_128347_("si", this.si);
            nbt.m_128347_("D_S_F", this.D_S_F);
            nbt.m_128347_("aaa", this.aaa);
            nbt.m_128359_("ss", this.ss);
            nbt.m_128347_("D_F_F", this.D_F_F);
            nbt.m_128347_("T_F_B", this.T_F_B);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.alfa_magic_bullet_tester = nbt.m_128459_("alfa_magic_bullet_tester");
            this.beta_magic_bullet_tester = nbt.m_128459_("beta_magic_bullet_tester");
            this.x_magic_bullet_tester = nbt.m_128459_("x_magic_bullet_tester");
            this.y_magic_bullet_tester = nbt.m_128459_("y_magic_bullet_tester");
            this.z_magic_bullet_tester = nbt.m_128459_("z_magic_bullet_tester");
            this.konranti = nbt.m_128459_("konranti");
            this.konrannsaidaiti = nbt.m_128459_("konrannsaidaiti");
            this.run_check = nbt.m_128459_("run_check");
            this.golddshoot_chaeck = nbt.m_128459_("golddshoot_chaeck");
            this.what_people_want_K = nbt.m_128459_("what_people_want_K");
            this.what_pepole_want_N = nbt.m_128459_("what_pepole_want_N");
            this.slid_X = nbt.m_128459_("slid_X");
            this.sird_Z = nbt.m_128459_("sird_Z");
            this.slid = nbt.m_128459_("slid");
            this.Spes = nbt.m_128459_("Spes");
            this.nikutaikyouka = nbt.m_128459_("nikutaikyouka");
            this.kasoku_x = nbt.m_128459_("kasoku_x");
            this.kasoku_Z = nbt.m_128459_("kasoku_Z");
            this.M = nbt.m_128459_("M");
            this.FA = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("FA"));
            this.kaikyuu = nbt.m_128459_("kaikyuu");
            this.alfa = nbt.m_128459_("alfa");
            this.beta = nbt.m_128459_("beta");
            this.O_N_K = nbt.m_128459_("O_N_K");
            this.wing_hit = nbt.m_128459_("wing_hit");
            this.goukeireberu = nbt.m_128459_("goukeireberu");
            this.F_F_K = nbt.m_128459_("F_F_K");
            this.F_M_K = nbt.m_128459_("F_M_K");
            this.amo = nbt.m_128459_("amo");
            this.gekihasuu = nbt.m_128459_("gekihasuu");
            this.S_B_K = nbt.m_128459_("S_B_K");
            this.si = nbt.m_128459_("si");
            this.D_S_F = nbt.m_128459_("D_S_F");
            this.aaa = nbt.m_128459_("aaa");
            this.ss = nbt.m_128461_("ss");
            this.D_F_F = nbt.m_128459_("D_F_F");
            this.T_F_B = nbt.m_128459_("T_F_B");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("ego__ego", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "ego__ego_mapvars";
        public double zentei = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.zentei = nbt.m_128459_("zentei");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("zentei", this.zentei);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                EgoEgoMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "ego__ego_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                EgoEgoMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.what_people_want_K = original.what_people_want_K;
            clone.O_N_K = original.O_N_K;
            clone.F_F_K = original.F_F_K;
            clone.F_M_K = original.F_M_K;
            clone.gekihasuu = original.gekihasuu;
            clone.S_B_K = original.S_B_K;
            clone.D_S_F = original.D_S_F;
            clone.aaa = original.aaa;
            clone.ss = original.ss;
            clone.D_F_F = original.D_F_F;
            clone.T_F_B = original.T_F_B;
            if (!event.isWasDeath()) {
                clone.alfa_magic_bullet_tester = original.alfa_magic_bullet_tester;
                clone.beta_magic_bullet_tester = original.beta_magic_bullet_tester;
                clone.x_magic_bullet_tester = original.x_magic_bullet_tester;
                clone.y_magic_bullet_tester = original.y_magic_bullet_tester;
                clone.z_magic_bullet_tester = original.z_magic_bullet_tester;
                clone.konranti = original.konranti;
                clone.konrannsaidaiti = original.konrannsaidaiti;
                clone.run_check = original.run_check;
                clone.golddshoot_chaeck = original.golddshoot_chaeck;
                clone.what_pepole_want_N = original.what_pepole_want_N;
                clone.slid_X = original.slid_X;
                clone.sird_Z = original.sird_Z;
                clone.slid = original.slid;
                clone.Spes = original.Spes;
                clone.nikutaikyouka = original.nikutaikyouka;
                clone.kasoku_x = original.kasoku_x;
                clone.kasoku_Z = original.kasoku_Z;
                clone.M = original.M;
                clone.FA = original.FA;
                clone.kaikyuu = original.kaikyuu;
                clone.alfa = original.alfa;
                clone.beta = original.beta;
                clone.wing_hit = original.wing_hit;
                clone.goukeireberu = original.goukeireberu;
                clone.amo = original.amo;
                clone.si = original.si;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    EgoEgoMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    EgoEgoMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                EgoEgoMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

