/*
 * Decompiled with CFR 0.152.
 */
package me.manolopro3333.dynamicTP.listeners;

import java.util.List;
import me.manolopro3333.dynamicTP.DynamicTP;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerInteractListener
implements Listener {
    private final DynamicTP plugin;

    public PlayerInteractListener(DynamicTP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() != Material.STICK || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasDisplayName() || !meta.getDisplayName().equals(ChatColor.GOLD + "Poner localizaci\u00f3n")) {
            return;
        }
        if (!player.hasPermission("dtp.use")) {
            this.sendMessage(player, ChatColor.RED + "[DynamicTP] No tienes permiso para hacer esto!");
            return;
        }
        FileConfiguration config = this.plugin.getStorage();
        List coords = config.getStringList("Localizaciones.CoordenadasGuardadas");
        if (player.isSneaking() && event.getAction().toString().contains("RIGHT_CLICK")) {
            if (coords.isEmpty()) {
                this.sendMessage(player, ChatColor.RED + "[DynamicTP] No hay localizaciones para eliminar.");
                return;
            }
            String lastCoord = (String)coords.remove(coords.size() - 1);
            config.set("Localizaciones.CoordenadasGuardadas", (Object)coords);
            this.plugin.saveStorage();
            this.sendMessage(player, ChatColor.YELLOW + "[DynamicTP] \u00daltima localizaci\u00f3n eliminada: " + lastCoord);
            return;
        }
        if (event.getAction().toString().contains("RIGHT_CLICK")) {
            if (event.getClickedBlock() == null) {
                this.sendMessage(player, ChatColor.RED + "[DynamicTP] Debes hacer click en un bloque para guardar.");
                return;
            }
            double x = (double)event.getClickedBlock().getX() + 0.5;
            double y = event.getClickedBlock().getY() + 2;
            double z = (double)event.getClickedBlock().getZ() + 0.5;
            coords.add(x + " " + y + " " + z);
            config.set("Localizaciones.CoordenadasGuardadas", (Object)coords);
            this.plugin.saveStorage();
            this.sendMessage(player, ChatColor.GREEN + "[DynamicTP] Localizaci\u00f3n guardada: " + x + " " + y + " " + z);
        } else if (event.getAction().toString().contains("LEFT_CLICK")) {
            player.getInventory().remove(item);
            this.sendMessage(player, ChatColor.GREEN + "[DynamicTP] Localizaciones guardadas exitosamente.");
        }
    }

    private void sendMessage(Player player, String message) {
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }
}

