/*
 * Decompiled with CFR 0.152.
 */
package me.manolopro3333.dynamicTP.animations;

import me.manolopro3333.dynamicTP.DynamicTP;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TeleportTransition {
    public static void execute(DynamicTP plugin, Player player, final Runnable teleportFunction) {
        FileConfiguration config = plugin.getConfig();
        String title = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("Transicion.title"));
        int fadeIn = config.getInt("Transicion.times.fadeIn");
        int stay = config.getInt("Transicion.times.stay");
        int fadeOut = config.getInt("Transicion.times.fadeOut");
        player.sendTitle(title != null ? title : "", "", fadeIn, stay, fadeOut);
        String soundName = config.getString("Transicion.sound");
        if (soundName != null) {
            try {
                Sound sound = Sound.valueOf((String)soundName.replace("minecraft:", "").replace(".", "_").toUpperCase());
                player.playSound(player.getLocation(), sound, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            catch (IllegalArgumentException e) {
                player.playSound(player.getLocation(), soundName, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        int delay = config.getInt("Transicion.delay");
        new BukkitRunnable(){

            public void run() {
                teleportFunction.run();
            }
        }.runTaskLater((Plugin)plugin, (long)delay);
    }
}

