/*
 * Decompiled with CFR 0.152.
 */
package me.manolopro3333.dynamicTP.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.manolopro3333.dynamicTP.DynamicTP;
import me.manolopro3333.dynamicTP.animations.TeleportTransition;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DTPCommands
implements CommandExecutor,
TabCompleter {
    private final DynamicTP plugin;

    public DTPCommands(DynamicTP plugin) {
        this.plugin = plugin;
    }

    private void sendMessage(CommandSender sender, Component component) {
        sender.sendMessage(LegacyComponentSerializer.legacySection().serialize(component));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendMessage(sender, Component.text("[DynamicTP] Error en el comando, ejecuta /dtp help para ver la lista de comandos").color(NamedTextColor.RED));
            return true;
        }
        if (!sender.hasPermission("dtp.use")) {
            this.sendMessage(sender, Component.text("[DynamicTP] No tienes permiso para hacer esto!").color(NamedTextColor.RED));
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "setpost": {
                this.handleSetpostCommand(sender, args);
                break;
            }
            case "remove": {
                this.handleRemoveCommand(sender, args);
                break;
            }
            case "tp": {
                this.handleTpCommand(sender, args);
                break;
            }
            case "return": {
                this.handleReturnCommand(sender, args);
                break;
            }
            case "help": {
                this.handleHelpCommand(sender);
                break;
            }
            case "reload": {
                this.handleReloadCommand(sender);
                break;
            }
            case "save": {
                this.handleSaveCommand(sender, args);
                break;
            }
            case "load": {
                this.handleLoadCommand(sender, args);
                break;
            }
            case "delete": {
                this.handleDeleteCommand(sender, args);
                break;
            }
            default: {
                this.sendMessage(sender, Component.text("[DynamicTP] Error en el comando, ejecuta /dtp help para ver la lista de comandos").color(NamedTextColor.RED));
            }
        }
        return true;
    }

    private void handleSaveCommand(CommandSender sender, String[] args) {
        FileConfiguration storage;
        List coordsList;
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, Component.text("[DynamicTP] Solo los jugadores pueden usar este comando.").color(NamedTextColor.RED));
            return;
        }
        if (args.length < 2) {
            this.sendMessage(sender, Component.text("[DynamicTP] Uso: /dtp save <nombre>").color(NamedTextColor.RED));
            return;
        }
        String saveName = args[1];
        File savesFolder = new File(this.plugin.getDataFolder(), "saves");
        if (!savesFolder.exists()) {
            savesFolder.mkdirs();
        }
        if ((coordsList = (storage = this.plugin.getStorage()).getStringList("Localizaciones.CoordenadasGuardadas")).isEmpty()) {
            this.sendMessage(sender, Component.text("[DynamicTP] No hay coordenadas para guardar.").color(NamedTextColor.RED));
            return;
        }
        File saveFile = new File(savesFolder, saveName + ".yml");
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.set("coords", (Object)coordsList);
        try {
            yaml.save(saveFile);
            this.sendMessage(sender, Component.text("[DynamicTP] Guardado exitoso en: saves/" + saveName + ".yml").color(NamedTextColor.GREEN));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("[DynamicTP] No se pudo guardar el archivo: " + saveFile.getName());
            this.sendMessage(sender, Component.text("[DynamicTP] Error al guardar. Revisa la consola.").color(NamedTextColor.RED));
        }
    }

    private void handleLoadCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, Component.text("[DynamicTP] Solo los jugadores pueden usar este comando.").color(NamedTextColor.RED));
            return;
        }
        if (args.length < 2) {
            this.sendMessage(sender, Component.text("[DynamicTP] Uso: /dtp load <nombre>").color(NamedTextColor.RED));
            return;
        }
        String saveName = args[1];
        File savesFolder = new File(this.plugin.getDataFolder(), "saves");
        File loadFile = new File(savesFolder, saveName + ".yml");
        if (!loadFile.exists()) {
            this.sendMessage(sender, Component.text("[DynamicTP] No existe ning\u00fan save con ese nombre.").color(NamedTextColor.RED));
            return;
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)loadFile);
        List loadedCoords = yaml.getStringList("coords");
        if (loadedCoords == null || loadedCoords.isEmpty()) {
            this.sendMessage(sender, Component.text("[DynamicTP] El archivo no contiene coordenadas o est\u00e1 vac\u00edo.").color(NamedTextColor.RED));
            return;
        }
        FileConfiguration storage = this.plugin.getStorage();
        storage.set("Localizaciones.CoordenadasGuardadas", (Object)loadedCoords);
        this.plugin.saveStorage();
        this.sendMessage(sender, Component.text("[DynamicTP] Coordenadas cargadas desde: saves/" + saveName + ".yml").color(NamedTextColor.GREEN));
    }

    private void handleDeleteCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, Component.text("[DynamicTP] Solo los jugadores pueden usar este comando.").color(NamedTextColor.RED));
            return;
        }
        if (args.length < 2) {
            this.sendMessage(sender, Component.text("[DynamicTP] Uso: /dtp delete <nombre>").color(NamedTextColor.RED));
            return;
        }
        String saveName = args[1];
        File savesFolder = new File(this.plugin.getDataFolder(), "saves");
        File deleteFile = new File(savesFolder, saveName + ".yml");
        if (!deleteFile.exists()) {
            this.sendMessage(sender, Component.text("[DynamicTP] No existe ning\u00fan save con ese nombre.").color(NamedTextColor.RED));
            return;
        }
        if (deleteFile.delete()) {
            this.sendMessage(sender, Component.text("[DynamicTP] Save eliminado: " + saveName + ".yml").color(NamedTextColor.GREEN));
        } else {
            this.sendMessage(sender, Component.text("[DynamicTP] No se pudo eliminar el archivo. Revisa permisos.").color(NamedTextColor.RED));
        }
    }

    private void handleRemoveCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.sendMessage(sender, Component.text("[DynamicTP] Error en el comando, ejecuta /dtp help para ver la lista de comandos").color(NamedTextColor.RED));
            return;
        }
        switch (args[1].toLowerCase()) {
            case "coord": {
                this.handleRemoveCoordCommand(sender, args);
                break;
            }
            case "returns": {
                this.handleRemoveReturnCommand(sender, args);
                break;
            }
            default: {
                this.sendMessage(sender, Component.text("[DynamicTP] Acci\u00f3n inv\u00e1lida para /dtp remove").color(NamedTextColor.RED));
            }
        }
    }

    private void handleRemoveReturnCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, Component.text("[DynamicTP] Solo jugadores pueden usar este comando").color(NamedTextColor.RED));
            return;
        }
        Player player = (Player)sender;
        if (args.length < 3) {
            this.sendMessage(sender, Component.text("[DynamicTP] Uso: /dtp remove returns <@selector|nombre>").color(NamedTextColor.RED));
            return;
        }
        List<Player> targets = this.resolveTargets(args[2], player);
        if (targets.isEmpty()) {
            this.sendMessage(sender, Component.text("[DynamicTP] No se encontraron jugadores").color(NamedTextColor.RED));
            return;
        }
        FileConfiguration storage = this.plugin.getStorage();
        if (targets.size() > 1) {
            for (Player target : targets) {
                String path = "Localizaciones.PosicionesOriginales." + target.getName();
                storage.set(path, null);
            }
            this.sendMessage(sender, Component.text("[DynamicTP] Posiciones reseteadas correctamente.").color(NamedTextColor.GREEN));
        } else {
            for (Player target : targets) {
                String name = target.getName();
                String path = "Localizaciones.PosicionesOriginales." + name;
                if (storage.contains(path)) {
                    storage.set(path, null);
                    this.sendMessage(sender, Component.text("[DynamicTP] Se ha eliminado la posici\u00f3n inicial del jugador: " + name).color(NamedTextColor.GREEN));
                    continue;
                }
                this.sendMessage(sender, Component.text("[DynamicTP] Este jugador no tiene ninguna localizaci\u00f3n guardada: " + name).color(NamedTextColor.RED));
            }
        }
        this.plugin.saveStorage();
    }

    private void handleSetpostCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.sendMessage(sender, Component.text("[DynamicTP] Error en el comando, ejecuta /dtp help para ver la lista de comandos").color(NamedTextColor.RED));
            return;
        }
        switch (args[1].toLowerCase()) {
            case "add": {
                this.giveStick(sender);
                break;
            }
            case "list": {
                this.listCoordinates(sender);
                break;
            }
            default: {
                this.sendMessage(sender, Component.text("[DynamicTP] Acci\u00f3n inv\u00e1lida para /dtp setpost").color(NamedTextColor.RED));
            }
        }
    }

    private void giveStick(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, Component.text("Este comando solo puede ser usado por jugadores."));
            return;
        }
        Player player = (Player)sender;
        ItemStack stick = new ItemStack(Material.STICK);
        ItemMeta meta = stick.getItemMeta();
        meta.setDisplayName("\u00a76Poner localizaci\u00f3n");
        meta.setLore(Arrays.asList("\u00a77Haz click derecho para a\u00f1adir una localizaci\u00f3n", "\u00a77Haz click izquierdo para guardar la localizaci\u00f3n", "\u00a77Haz shift + click derecho para eliminar la ultima localizaci\u00f3n"));
        meta.addEnchant(Enchantment.DURABILITY, 1, true);
        meta.setUnbreakable(true);
        stick.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{stick});
        this.plugin.getStorage().set("Localizaciones.CoordenadasGuardadas", new ArrayList());
        this.plugin.saveStorage();
        this.sendMessage((CommandSender)player, Component.text("Haz click derecho para a\u00f1adir una localizaci\u00f3n y click izquierdo para guardar todas las localizaciones"));
    }

    private void listCoordinates(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, Component.text("[DynamicTP] Este comando solo puede ser usado por jugadores.").color(NamedTextColor.RED));
            return;
        }
        Player player = (Player)sender;
        List coordenadasList = this.plugin.getStorage().getStringList("Localizaciones.CoordenadasGuardadas");
        if (coordenadasList.isEmpty()) {
            this.sendMessage((CommandSender)player, Component.text("[DynamicTP] No hay coordenadas guardadas.").color(NamedTextColor.RED));
            return;
        }
        this.sendMessage((CommandSender)player, Component.text("[DynamicTP] Lista de coordenadas:").color(NamedTextColor.GOLD));
        for (int i = 0; i < coordenadasList.size(); ++i) {
            String message;
            String coord = (String)coordenadasList.get(i);
            String[] parts = coord.split(",");
            if (parts.length == 4) {
                message = "\u00a7c[\u00a7l" + i + "\u00a7c] \u00a77- Mundo: " + parts[0] + " | X: " + parts[1] + " Y: " + parts[2] + " Z: " + parts[3];
                player.sendMessage(message);
                continue;
            }
            message = "\u00a7c[\u00a7l" + i + "\u00a7c] \u00a77- " + coord + " (formato antiguo)";
            player.sendMessage(message);
        }
    }

    private void handleRemoveCoordCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, Component.text("[DynamicTP] Este comando solo puede ser usado por jugadores.").color(NamedTextColor.RED));
            return;
        }
        if (args.length < 3) {
            this.sendMessage(sender, Component.text("[DynamicTP] Uso incorrecto. Falt\u00f3 el \u00edndice.").color(NamedTextColor.RED));
            return;
        }
        try {
            int index = Integer.parseInt(args[2]);
            List coords = this.plugin.getStorage().getStringList("Localizaciones.CoordenadasGuardadas");
            if (index < 0 || index >= coords.size()) {
                this.sendMessage(sender, Component.text("[DynamicTP] \u00cdndice inv\u00e1lido.").color(NamedTextColor.RED));
                return;
            }
            String removedCoord = (String)coords.remove(index);
            this.plugin.getStorage().set("Localizaciones.CoordenadasGuardadas", (Object)coords);
            this.plugin.saveStorage();
            this.sendMessage(sender, Component.text("[DynamicTP] Coordenada eliminada: " + removedCoord).color(NamedTextColor.GREEN));
        }
        catch (NumberFormatException e) {
            this.sendMessage(sender, Component.text("[DynamicTP] El \u00edndice debe ser un n\u00famero.").color(NamedTextColor.RED));
        }
    }

    private void handleTpCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, Component.text("[DynamicTP] Solo jugadores pueden usar este comando").color(NamedTextColor.RED));
            return;
        }
        Player executor = (Player)sender;
        if (args.length < 2) {
            this.sendMessage(sender, Component.text("[DynamicTP] Uso: /dtp tp <@selector|nombre>").color(NamedTextColor.RED));
            return;
        }
        List<Player> targets = this.resolveTargets(args[1], executor);
        if (targets.isEmpty()) {
            this.sendMessage(sender, Component.text("[DynamicTP] No se encontraron jugadores").color(NamedTextColor.RED));
            return;
        }
        List coords = this.plugin.getStorage().getStringList("Localizaciones.CoordenadasGuardadas");
        if (coords.isEmpty()) {
            this.sendMessage(sender, Component.text("[DynamicTP] No hay coordenadas guardadas").color(NamedTextColor.RED));
            return;
        }
        FileConfiguration storage = this.plugin.getStorage();
        boolean useTransition = this.plugin.getConfig().getBoolean("Transicion.activado", false);
        int index = 0;
        for (Player target : targets) {
            String[] parts;
            String name = target.getName();
            String path = "Localizaciones.PosicionesOriginales." + name;
            if (!storage.contains(path)) {
                Location loc = target.getLocation();
                String locString = loc.getWorld().getName() + "," + loc.getX() + "," + loc.getY() + "," + loc.getZ();
                storage.set(path, (Object)locString);
            }
            if ((parts = ((String)coords.get(index % coords.size())).split(",")).length != 4) {
                ++index;
                continue;
            }
            try {
                World world = Bukkit.getWorld((String)parts[0]);
                if (world == null) {
                    this.sendMessage(sender, Component.text("[DynamicTP] Mundo no encontrado: " + parts[0]).color(NamedTextColor.RED));
                    ++index;
                    continue;
                }
                Location destination = new Location(world, Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
                if (useTransition) {
                    TeleportTransition.execute(this.plugin, target, () -> target.teleport(destination));
                } else {
                    target.teleport(destination);
                }
            }
            catch (NumberFormatException e) {
                this.sendMessage(sender, Component.text("[DynamicTP] Error en coordenadas").color(NamedTextColor.RED));
            }
            ++index;
        }
        this.plugin.saveStorage();
        this.sendMessage(sender, Component.text("[DynamicTP] Teleportaci\u00f3n " + (useTransition ? "con transici\u00f3n" : "inmediata") + " completada").color(NamedTextColor.GREEN));
    }

    private void handleReturnCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, Component.text("[DynamicTP] Solo jugadores pueden usar este comando").color(NamedTextColor.RED));
            return;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            this.sendMessage(sender, Component.text("[DynamicTP] Uso: /dtp return <@selector|nombre>").color(NamedTextColor.RED));
            return;
        }
        List<Player> targets = this.resolveTargets(args[1], player);
        if (targets.isEmpty()) {
            this.sendMessage(sender, Component.text("[DynamicTP] No se encontraron jugadores").color(NamedTextColor.RED));
            return;
        }
        FileConfiguration storage = this.plugin.getStorage();
        boolean restored = false;
        for (Player target : targets) {
            String name = target.getName();
            String path = "Localizaciones.PosicionesOriginales." + name;
            String data = storage.getString(path);
            if (data == null) continue;
            try {
                World world;
                String[] parts = data.split(",");
                if (parts.length != 4 || (world = Bukkit.getWorld((String)parts[0])) == null) continue;
                Location origin = new Location(world, Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
                target.teleport(origin);
                storage.set(path, null);
                restored = true;
            }
            catch (Exception exception) {}
        }
        if (restored) {
            this.plugin.saveStorage();
            this.sendMessage(sender, Component.text("[DynamicTP] Jugadores devueltos y posiciones eliminadas").color(NamedTextColor.GREEN));
        } else {
            this.sendMessage(sender, Component.text("[DynamicTP] No se restauraron posiciones").color(NamedTextColor.RED));
        }
    }

    private List<Player> resolveTargets(String selector, Player executor) {
        switch (selector) {
            case "@a": {
                return new ArrayList<Player>(Bukkit.getOnlinePlayers());
            }
            case "@r": {
                ArrayList list = new ArrayList(Bukkit.getOnlinePlayers());
                Collections.shuffle(list);
                return list.isEmpty() ? List.of() : List.of((Player)list.get(0));
            }
        }
        if (selector.startsWith("@a[") && selector.endsWith("]")) {
            String content = selector.substring(3, selector.length() - 1);
            String[] parts = content.split(",");
            String tagFilter = null;
            String teamFilter = null;
            for (String part : parts) {
                if ((part = part.trim()).startsWith("tag=")) {
                    tagFilter = part.substring(4);
                }
                if (!part.startsWith("team=")) continue;
                teamFilter = part.substring(5);
            }
            boolean tagNegated = tagFilter != null && tagFilter.startsWith("!");
            String finalTag = tagFilter != null ? tagFilter.replaceFirst("!", "") : null;
            boolean teamNegated = teamFilter != null && teamFilter.startsWith("!");
            String finalTeam = teamFilter != null ? teamFilter.replaceFirst("!", "") : null;
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            return Bukkit.getOnlinePlayers().stream().filter(p -> {
                Team team = scoreboard.getEntryTeam(p.getName());
                if (finalTag != null) {
                    boolean hasTag;
                    boolean bl = hasTag = team != null && team.getName().equals(finalTag);
                    if (tagNegated == hasTag) {
                        return false;
                    }
                }
                if (finalTeam != null) {
                    boolean isInTeam;
                    boolean bl = isInTeam = team != null && team.getName().equals(finalTeam);
                    if (teamNegated == isInTeam) {
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
        }
        Player player = Bukkit.getPlayer((String)selector);
        return player != null ? List.of(player) : List.of();
    }

    private void handleHelpCommand(CommandSender sender) {
        this.sendMessage(sender, Component.text("===== Lista de comandos [DynamicTP] =====").color(NamedTextColor.GOLD));
        this.sendMessage(sender, Component.text("    /dtp setpost add       - Crear palo para a\u00f1adir localizaciones").color(NamedTextColor.GRAY));
        this.sendMessage(sender, Component.text("    /dtp setpost list      - Ver localizaciones guardadas").color(NamedTextColor.GRAY));
        this.sendMessage(sender, Component.text("    /dtp removecoord [idx] - Eliminar coordenada de la lista").color(NamedTextColor.GRAY));
        this.sendMessage(sender, Component.text("    /dtp tp <selector>      - Teletransportar jugadores").color(NamedTextColor.GRAY));
        this.sendMessage(sender, Component.text("    /dtp return <selector>  - Volver a posici\u00f3n original").color(NamedTextColor.GRAY));
        this.sendMessage(sender, Component.text("    /dtp reload             - Recargar configuraci\u00f3n").color(NamedTextColor.GRAY));
        this.sendMessage(sender, Component.text("    /dtp save <nombre>      - Guardar coordenadas actuales").color(NamedTextColor.GRAY));
        this.sendMessage(sender, Component.text("    /dtp load <nombre>      - Cargar coordenadas de un save").color(NamedTextColor.GRAY));
        this.sendMessage(sender, Component.text("    /dtp delete <nombre>    - Eliminar un save existente").color(NamedTextColor.GRAY));
        this.sendMessage(sender, Component.text("Plugin creado por Aimbot/Manolopro3333 en colaboraci\u00f3n de Owleaf Studio.").color(NamedTextColor.GRAY));
    }

    private void handleReloadCommand(CommandSender sender) {
        this.plugin.reloadConfig();
        this.plugin.reloadStorage();
        this.sendMessage(sender, Component.text("[DynamicTP] La configuraci\u00f3n ha sido recargada correctamente.").color(NamedTextColor.GREEN));
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("setpost", "tp", "return", "help", "reload", "remove", "save", "load", "delete"));
        } else if (args.length == 2) {
            File savesFolder;
            String first = args[0].toLowerCase();
            if (first.equals("tp") || first.equals("return")) {
                completions.addAll(Arrays.asList("@a", "@r"));
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).toList());
            } else if (first.equals("setpost")) {
                completions.addAll(Arrays.asList("add", "list"));
            } else if (first.equals("remove")) {
                completions.addAll(Arrays.asList("coord", "returns"));
            } else if ((first.equals("load") || first.equals("delete")) && (savesFolder = new File(this.plugin.getDataFolder(), "saves")).exists()) {
                String prefix = args[1].toLowerCase();
                for (File f : Objects.requireNonNull(savesFolder.listFiles((dir, name) -> name.endsWith(".yml")))) {
                    String baseName = f.getName().substring(0, f.getName().length() - 4);
                    if (!baseName.toLowerCase().startsWith(prefix)) continue;
                    completions.add(baseName);
                }
            }
        }
        return completions;
    }
}

