/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.connection;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import wuemeli.utils.logger.Logger;
import wuemeli.utils.privatemsg.PrivateMessageManager;

@Environment(value=EnvType.CLIENT)
public class ConnectionManager {
    private static WebSocketClient client;
    private static final String SERVER_URL = "wss://mc.wuemeli.com/ws";
    private static final Gson gson;
    private static boolean isAuthenticated;
    private static final String SERVER_ID = "wuemelis-utils-server";
    private static boolean shouldReconnect;
    private static boolean isReconnecting;
    private static int reconnectAttempts;
    private static final int MAX_RECONNECT_ATTEMPTS = 10;
    private static final int BASE_RECONNECT_DELAY = 2000;
    private static long lastConnectionErrorLog;
    private static final long MIN_LOG_INTERVAL = 10000L;

    public static void init() {
        try {
            URI serverUri = new URI(SERVER_URL);
            client = new WebSocketClient(serverUri){

                public void onOpen(ServerHandshake handshakedata) {
                    Logger.info("Connected to WebSocket server");
                    isReconnecting = false;
                    reconnectAttempts = 0;
                    ConnectionManager.authenticate();
                }

                public void onMessage(String message) {
                    Logger.debug("Received message: " + message);
                    ConnectionManager.handleMessage(message);
                }

                public void onClose(int code, String reason, boolean remote) {
                    Logger.warn("WebSocket connection closed: " + reason + " (Code: " + code + ", Remote: " + remote + ")");
                    isAuthenticated = false;
                    if (shouldReconnect && !isReconnecting) {
                        ConnectionManager.scheduleReconnect();
                    }
                }

                public void onError(Exception ex) {
                    Logger.error("WebSocket error: " + ex.getMessage());
                    isAuthenticated = false;
                    if (shouldReconnect && !isReconnecting) {
                        ConnectionManager.scheduleReconnect();
                    }
                }
            };
            ConnectionManager.connect();
        }
        catch (URISyntaxException e) {
            Logger.error("Invalid WebSocket server URI: " + e.getMessage());
        }
    }

    public static void connect() {
        if (client != null && !client.isOpen()) {
            Logger.info("Connecting to WebSocket server...");
            client.connect();
        }
    }

    public static void disconnect() {
        shouldReconnect = false;
        if (client != null && client.isOpen()) {
            Logger.info("Disconnecting from WebSocket server...");
            client.close();
        }
    }

    public static void reconnect() {
        shouldReconnect = true;
        ConnectionManager.disconnect();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        ConnectionManager.connect();
    }

    private static void handleMessage(String message) {
        try {
            String type;
            JsonObject messageObj = (JsonObject)gson.fromJson(message, JsonObject.class);
            switch (type = messageObj.get("type").getAsString()) {
                case "auth_success": {
                    Logger.info("Authentication successful");
                    isAuthenticated = true;
                    Logger.debug("Triggering private message initialization after authentication");
                    new Thread(() -> {
                        try {
                            Thread.sleep(1000L);
                            PrivateMessageManager.init();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }).start();
                    break;
                }
                case "auth_failed": {
                    Logger.error("Authentication failed: " + messageObj.get("message").getAsString());
                    isAuthenticated = false;
                    break;
                }
                case "error": {
                    Logger.error("Server error: " + messageObj.get("message").getAsString());
                    break;
                }
                case "private_message_response": {
                    if (messageObj.has("data")) {
                        PrivateMessageManager.handlePrivateMessageResponse(messageObj.get("data").getAsJsonObject());
                    }
                    break;
                }
                default: {
                    Logger.warn("Unknown message type: " + type);
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.error("Error parsing message: " + e.getMessage());
        }
    }

    private static void authenticate() {
        if (client == null || !client.isOpen()) {
            Logger.warn("Cannot authenticate: WebSocket not connected");
            return;
        }
        try {
            class_310 mc = class_310.method_1551();
            if (mc.method_1548() == null) {
                Logger.warn("Cannot authenticate: No user session");
                return;
            }
            String uuid = mc.method_1548().method_44717().toString();
            String username = mc.method_1548().method_1676();
            String accessToken = mc.method_1548().method_1674();
            Logger.debug("Attempting authentication for: " + username + " (UUID: " + uuid + ")");
            Logger.debug("Access token: " + (String)(accessToken != null ? accessToken.substring(0, Math.min(10, accessToken.length())) + "..." : "null"));
            Logger.debug("Server ID: wuemelis-utils-server");
            if (accessToken == null || accessToken.isEmpty() || accessToken.equals("0") || accessToken.equals("null")) {
                Logger.error("Authentication failed: Invalid or missing access token. Offline mode not supported.");
                return;
            }
            if (ConnectionManager.joinSessionServer(username, accessToken, SERVER_ID)) {
                JsonObject authMessage = new JsonObject();
                authMessage.addProperty("type", "auth");
                authMessage.addProperty("uuid", uuid);
                authMessage.addProperty("serverId", SERVER_ID);
                String authJson = gson.toJson((JsonElement)authMessage);
                client.send(authJson);
                Logger.debug("Authentication message sent for user: " + username);
            } else {
                Logger.error("Failed to join session server - authentication aborted");
            }
        }
        catch (Exception e) {
            Logger.error("Error during authentication: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean joinSessionServer(String username, String accessToken, String serverId) {
        try {
            HttpClient httpClient = HttpClient.newHttpClient();
            class_310 mc = class_310.method_1551();
            String playerUuid = mc.method_1548().method_44717().toString();
            String cleanUuid = playerUuid.replace("-", "");
            JsonObject requestBody = new JsonObject();
            requestBody.addProperty("accessToken", accessToken);
            requestBody.addProperty("selectedProfile", cleanUuid);
            requestBody.addProperty("serverId", serverId);
            Logger.debug("Joining session server with data:");
            Logger.debug("  Username: " + username);
            Logger.debug("  UUID (with dashes): " + playerUuid);
            Logger.debug("  UUID (clean): " + cleanUuid);
            Logger.debug("  Server ID: " + serverId);
            Logger.debug("  Request body: " + requestBody.toString());
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://sessionserver.mojang.com/session/minecraft/join")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody.toString())).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            Logger.debug("Session server response: " + response.statusCode() + " - " + response.body());
            if (response.statusCode() == 204) {
                Logger.debug("Successfully joined session server");
                return true;
            }
            Logger.debug("Session server error: " + response.statusCode() + " - " + response.body());
            return false;
        }
        catch (Exception e) {
            Logger.error("Error joining session server: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static void scheduleReconnect() {
        if (isReconnecting || reconnectAttempts >= 10) {
            if (reconnectAttempts >= 10) {
                Logger.error("Max reconnection attempts reached. Stopping reconnection.");
            }
            return;
        }
        isReconnecting = true;
        int delay = Math.min(2000 * (int)Math.pow(2.0, ++reconnectAttempts - 1), 30000);
        Logger.info("Scheduling reconnection attempt " + reconnectAttempts + "/10 in " + delay / 1000 + " seconds...");
        new Thread(() -> {
            try {
                Thread.sleep(delay);
                if (shouldReconnect && isReconnecting) {
                    Logger.debug("Attempting to reconnect to WebSocket server... (Attempt " + reconnectAttempts + ")");
                    try {
                        ConnectionManager.init();
                    }
                    catch (Exception e) {
                        Logger.error("Reconnection attempt failed: " + e.getMessage());
                        isReconnecting = false;
                        ConnectionManager.scheduleReconnect();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                isReconnecting = false;
            }
        }).start();
    }

    public static void sendMessage(String message) {
        if (client != null && client.isOpen()) {
            client.send(message);
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastConnectionErrorLog > 10000L) {
                Logger.warn("Cannot send message: WebSocket not connected");
                lastConnectionErrorLog = currentTime;
            }
            if (shouldReconnect && !isReconnecting) {
                ConnectionManager.connect();
            }
        }
    }

    public static boolean isConnected() {
        try {
            return client != null && client.isOpen() && isAuthenticated;
        }
        catch (Exception e) {
            Logger.warn("Error checking connection status: " + e.getMessage());
            return false;
        }
    }

    static {
        gson = new Gson();
        isAuthenticated = false;
        shouldReconnect = true;
        isReconnecting = false;
        reconnectAttempts = 0;
        lastConnectionErrorLog = 0L;
    }
}

