/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.logger;

import dev.isxander.yacl3.api.NameableEnum;
import io.sentry.Sentry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import wuemeli.utils.Main;

@Environment(value=EnvType.CLIENT)
public class Logger {
    private static void log(LogLevel level, String message) {
        if (Main.logLevel != null && level.getLevel() >= Main.logLevel.getLevel()) {
            String prefix = "[Wuemeli's Utils] [" + level.getName() + "] ";
            if (level == LogLevel.ERROR) {
                System.err.println(prefix + message);
            } else {
                System.out.println(prefix + message);
            }
        }
    }

    public static void debug(String message) {
        Logger.log(LogLevel.DEBUG, message);
    }

    public static void info(String message) {
        Logger.log(LogLevel.INFO, message);
    }

    public static void warn(String message) {
        Logger.log(LogLevel.WARN, message);
    }

    public static void error(String message) {
        Sentry.captureException((Throwable)new Exception(message));
        Logger.log(LogLevel.ERROR, message);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum LogLevel implements NameableEnum
    {
        DEBUG(0, "DEBUG"),
        INFO(1, "INFO"),
        WARN(2, "WARN"),
        ERROR(3, "ERROR");

        private final int level;
        private final String name;

        private LogLevel(int level, String name) {
            this.level = level;
            this.name = name;
        }

        public int getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43470((String)this.name);
        }
    }
}

