/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.privatemsg;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import wuemeli.utils.Main;
import wuemeli.utils.connection.ConnectionManager;
import wuemeli.utils.logger.Logger;
import wuemeli.utils.privatemsg.PGPKeyManager;

@Environment(value=EnvType.CLIENT)
public class PrivateMessageManager {
    private static final Map<String, String> playerPublicKeys = new HashMap<String, String>();
    private static String lastMessagedPlayer = null;
    private static final Map<String, String> pendingMessages = new HashMap<String, String>();
    private static boolean noConnectionWarningShown = false;
    public static boolean isUsingFallbackMode = false;
    private static String lastLoggedPlayer = null;
    private static long lastLogTime = 0L;
    private static final long LOG_COOLDOWN = 5000L;

    public static void init() {
        PGPKeyManager.generateKeyPair();
        noConnectionWarningShown = false;
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
                PrivateMessageManager.uploadPublicKey();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    private static void uploadPublicKey() {
        if (!PGPKeyManager.hasKeyPair()) {
            Logger.warn("No key pair available to upload");
            return;
        }
        String publicKey = PGPKeyManager.getPublicKeyString();
        if (publicKey == null) {
            Logger.error("Failed to get public key string");
            return;
        }
        Logger.debug("Preparing to upload public key");
        JsonObject uploadMessage = new JsonObject();
        uploadMessage.addProperty("type", "upload_public_key");
        uploadMessage.addProperty("publicKey", publicKey);
        ConnectionManager.sendMessage(uploadMessage.toString());
        Logger.info("Public key upload message sent to server");
    }

    public static void sendPrivateMessage(String playerName, String message) {
        if (playerName == null || message == null) {
            Logger.warn("Cannot send message: player name or message is null");
            return;
        }
        try {
            lastMessagedPlayer = playerName;
            pendingMessages.put(playerName, message);
            if (!Main.privateMessagingEnabled || Main.alwaysFallbackToVanilla) {
                Logger.debug("Using vanilla messaging due to configuration settings");
                isUsingFallbackMode = true;
                PrivateMessageManager.fallbackToVanillaMessage(playerName, message);
                return;
            }
            if (!ConnectionManager.isConnected()) {
                if (!noConnectionWarningShown) {
                    Logger.warn("No server connection, falling back to vanilla messaging");
                    noConnectionWarningShown = true;
                }
                isUsingFallbackMode = true;
                PrivateMessageManager.fallbackToVanillaMessage(playerName, message);
                return;
            }
            isUsingFallbackMode = false;
            noConnectionWarningShown = false;
            if (!PGPKeyManager.hasKeyPair()) {
                Logger.warn("No encryption keys available");
                PrivateMessageManager.sendChatMessage("\u00a7cPrivate messaging not available - no encryption keys");
                PrivateMessageManager.fallbackToVanillaMessage(playerName, message);
                return;
            }
            try {
                JsonObject keyRequest = new JsonObject();
                keyRequest.addProperty("type", "request_public_key");
                keyRequest.addProperty("playerName", playerName);
                ConnectionManager.sendMessage(keyRequest.toString());
                Logger.debug("Requesting public key for player: " + playerName);
            }
            catch (Exception connectionEx) {
                Logger.error("Failed to check user connection: " + connectionEx.getMessage());
                PrivateMessageManager.sendChatMessage("\u00a7cConnection issue, falling back to vanilla messaging");
                PrivateMessageManager.fallbackToVanillaMessage(playerName, message);
            }
        }
        catch (Exception e) {
            Logger.error("Error in sendPrivateMessage: " + e.getMessage());
            try {
                PrivateMessageManager.fallbackToVanillaMessage(playerName, message);
            }
            catch (Exception fallbackEx) {
                Logger.error("Critical error in fallback messaging: " + fallbackEx.getMessage());
                PrivateMessageManager.sendChatMessage("\u00a7cFailed to send message - check game logs");
            }
        }
    }

    private static void storeMessageForLater(String playerName, String message) {
        pendingMessages.put(playerName, message);
        Logger.debug("Stored message for " + playerName + " until public key is received");
    }

    private static void fallbackToVanillaMessage(String playerName, String message) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && mc.field_1724.field_3944 != null) {
            lastMessagedPlayer = playerName;
            long currentTime = System.currentTimeMillis();
            if (!playerName.equals(lastLoggedPlayer) || currentTime - lastLogTime > 5000L) {
                Logger.info("Falling back to vanilla messaging for: " + playerName);
                lastLogTime = currentTime;
                lastLoggedPlayer = playerName;
            }
            try {
                String command = Main.fallbackVanillaCommand != null && !Main.fallbackVanillaCommand.isEmpty() ? Main.fallbackVanillaCommand : "msg";
                String syntax = Main.fallbackCommandSyntax != null && !Main.fallbackCommandSyntax.isEmpty() ? Main.fallbackCommandSyntax : "{command} {player} {message}";
                String formattedCommand = syntax.replace("{command}", command).replace("{player}", playerName).replace("{message}", message);
                mc.field_1724.field_3944.method_45730(formattedCommand);
                Logger.debug("Sent message over Minecraft server using command format: " + formattedCommand);
                pendingMessages.remove(playerName);
            }
            catch (Exception e) {
                Logger.error("Error sending message over Minecraft server: " + e.getMessage());
                PrivateMessageManager.sendChatMessage("\u00a7cCouldn't send message to " + playerName);
            }
        }
    }

    public static String getLastMessagedPlayer() {
        return lastMessagedPlayer;
    }

    public static void setLastMessagedPlayer(String playerName) {
        lastMessagedPlayer = playerName;
    }

    public static void handlePrivateMessageResponse(JsonObject response) {
        String subType;
        switch (subType = response.get("subType").getAsString()) {
            case "public_key_response": {
                PrivateMessageManager.handlePublicKeyResponse(response);
                break;
            }
            case "private_message": {
                PrivateMessageManager.handleIncomingPrivateMessage(response);
                break;
            }
            case "player_not_found": {
                Logger.warn("Player not found or not connected");
                if (lastMessagedPlayer == null || !pendingMessages.containsKey(lastMessagedPlayer)) break;
                Logger.info("Attempting fallback to vanilla messaging for player not found: " + lastMessagedPlayer);
                PrivateMessageManager.fallbackToVanillaMessage(lastMessagedPlayer, pendingMessages.get(lastMessagedPlayer));
                break;
            }
            case "no_public_key": {
                Logger.warn("Player does not have encryption enabled");
                if (lastMessagedPlayer == null || !pendingMessages.containsKey(lastMessagedPlayer)) break;
                Logger.info("Attempting fallback to vanilla messaging for player without public key: " + lastMessagedPlayer);
                PrivateMessageManager.fallbackToVanillaMessage(lastMessagedPlayer, pendingMessages.get(lastMessagedPlayer));
                break;
            }
            case "message_sent": {
                Logger.info("Private message sent successfully");
                break;
            }
            case "public_key_uploaded": {
                Logger.info("Public key uploaded successfully");
                break;
            }
            default: {
                Logger.warn("Unknown private message response type: " + subType);
            }
        }
    }

    private static void handlePublicKeyResponse(JsonObject response) {
        block4: {
            try {
                String playerName = response.get("playerName").getAsString();
                String publicKey = response.get("publicKey").getAsString();
                String pendingMessage = pendingMessages.remove(playerName);
                if (pendingMessage == null) {
                    Logger.debug("No pending message found for " + playerName);
                    return;
                }
                String encryptedMessage = PGPKeyManager.encryptMessage(pendingMessage, publicKey);
                if (encryptedMessage == null) {
                    PrivateMessageManager.sendChatMessage("Failed to encrypt message");
                    return;
                }
                JsonObject sendMessage = new JsonObject();
                sendMessage.addProperty("type", "send_private_message");
                sendMessage.addProperty("recipientName", playerName);
                sendMessage.addProperty("encryptedMessage", encryptedMessage);
                ConnectionManager.sendMessage(sendMessage.toString());
                Logger.info("Sent encrypted message to: " + playerName);
            }
            catch (Exception e) {
                Logger.error("Error handling public key response: " + e.getMessage());
                PrivateMessageManager.sendChatMessage("Failed to handle public key response");
                if (lastMessagedPlayer == null) break block4;
                PrivateMessageManager.fallbackToVanillaMessage(lastMessagedPlayer, pendingMessages.get(lastMessagedPlayer));
            }
        }
    }

    private static void handleIncomingPrivateMessage(JsonObject response) {
        String senderName = response.get("senderName").getAsString();
        String encryptedMessage = response.get("encryptedMessage").getAsString();
        PrivateMessageManager.setLastMessagedPlayer(senderName);
        String decryptedMessage = PGPKeyManager.decryptMessage(encryptedMessage);
        if (decryptedMessage == null) {
            Logger.error("Failed to decrypt message from " + senderName);
            PrivateMessageManager.sendChatMessage("\u00a7cFailed to decrypt message from " + senderName);
            return;
        }
        String formattedMessage = Main.privateMessageIncomingFormat.replace("{sender}", senderName).replace("{message}", decryptedMessage);
        PrivateMessageManager.sendChatMessage(formattedMessage);
        Logger.info("Received private message from: " + senderName);
    }

    private static void sendChatMessage(String message) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
        }
    }
}

