/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.updater;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class UpdaterMain {
    public static void main(String[] args) throws InterruptedException, IOException {
        File logFile = new File(".autoupdates", "postexit.log");
        logFile.getParentFile().mkdirs();
        PrintStream printStream = new PrintStream(new FileOutputStream(logFile, true));
        System.setErr(printStream);
        System.setOut(printStream);
        block8: for (int i = 2; i < args.length; ++i) {
            switch (args[i].intern()) {
                case "delete": {
                    File file = UpdaterMain.unlockedFile(args[++i]);
                    if (file.delete()) continue block8;
                    System.out.println("Failed to delete " + String.valueOf(file));
                    continue block8;
                }
                case "move": {
                    File from = UpdaterMain.unlockedFile(args[++i]);
                    File to = UpdaterMain.unlockedFile(args[++i]);
                    System.out.println("Moving " + String.valueOf(from) + " to " + String.valueOf(to));
                    Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    continue block8;
                }
                default: {
                    System.exit(1);
                }
            }
        }
    }

    public static File unlockedFile(String name) throws InterruptedException {
        File file = new File(name);
        while (file.exists() && !file.renameTo(file)) {
            Thread.sleep(1000L);
        }
        file.getParentFile().mkdirs();
        return file;
    }
}

