/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils;

import com.mojang.brigadier.CommandDispatcher;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import wuemeli.utils.alarm.Alarm;
import wuemeli.utils.alarm.EffectAlarm;
import wuemeli.utils.autorespawn.AutoRespawn;
import wuemeli.utils.command.CommandHandler;
import wuemeli.utils.config.ConfigManager;
import wuemeli.utils.congrater.Congrater;
import wuemeli.utils.connection.ConnectionManager;
import wuemeli.utils.globalchat.GlobalChatManager;
import wuemeli.utils.logger.Logger;
import wuemeli.utils.privatemsg.PrivateMessageManager;
import wuemeli.utils.services.DiscordRpcService;
import wuemeli.utils.services.SentryService;
import wuemeli.utils.ui.ConfigScreenBuilder;
import wuemeli.utils.updater.UpdateContext;
import wuemeli.utils.updater.UpdateTarget;

@Environment(value=EnvType.CLIENT)
public class Main
implements ModMenuApi,
ClientModInitializer {
    private static final UpdateContext UPDATE_CONTEXT = Main.createUpdateContext();
    private static boolean initialized = false;
    private static ConfigManager configManager;
    private static SentryService sentryService;
    private static DiscordRpcService discordRpcService;

    private static UpdateContext createUpdateContext() {
        return new UpdateContext("Ueey2eHa", "1.0.5", "release", "Ueey2eHa", UpdateTarget.deleteAndSaveInTheSameFolder(UpdateTarget.class));
    }

    public void onInitializeClient() {
        block3: {
            if (initialized) {
                Logger.warn("Mod already initialized, skipping");
                return;
            }
            try {
                Logger.info("Initializing Wuemeli's Utils v1.0.5");
                this.handleUpdates();
                this.initializeServices();
                this.loadConfiguration();
                this.initializeModFeatures();
                this.registerCommands();
                initialized = true;
                Logger.info("Wuemeli's Utils initialization complete");
            }
            catch (Exception e) {
                Logger.error("Critical error during mod initialization", e);
                if (sentryService == null || !sentryService.isInitialized()) break block3;
                sentryService.reportException(e);
            }
        }
    }

    private void initializeServices() {
        try {
            sentryService = SentryService.getInstance();
            sentryService.initialize();
            Logger.debug("Sentry service initialized");
            discordRpcService = DiscordRpcService.getInstance();
            discordRpcService.initialize();
            Logger.debug("Discord RPC service initialized");
        }
        catch (Exception e) {
            Logger.error("Failed to initialize services", e);
        }
    }

    private void handleUpdates() {
        try {
            UPDATE_CONTEXT.cleanup();
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                try {
                    return UPDATE_CONTEXT.checkUpdate().get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    Logger.error("Failed to check for updates", e);
                    return null;
                }
            }).thenAccept(potentialUpdate -> {
                if (potentialUpdate != null) {
                    potentialUpdate.launchUpdate();
                    Logger.info("Update will be applied after minecraft closes");
                } else {
                    Logger.debug("No updates available");
                }
            })).exceptionally(throwable -> {
                Logger.warn("Update check failed");
                return null;
            });
        }
        catch (Exception e) {
            Logger.error("Error during update handling", e);
        }
    }

    private void loadConfiguration() {
        try {
            configManager = ConfigManager.getInstance();
            configManager.load();
            Logger.info("Configuration loaded successfully");
        }
        catch (Exception e) {
            Logger.error("Failed to load configuration", e);
            if (sentryService != null) {
                sentryService.reportException(e);
            }
            throw new RuntimeException("Configuration loading failed", e);
        }
    }

    private void initializeModFeatures() {
        try {
            ConnectionManager.init();
            Logger.debug("Connection manager initialized");
            AutoRespawn.init();
            Logger.debug("Auto respawn initialized");
            PrivateMessageManager.init();
            Logger.debug("Private message manager initialized");
            GlobalChatManager.init();
            Logger.debug("Global chat manager initialized");
            Congrater.init();
            Logger.debug("Congrater initialized");
            Alarm.init();
            EffectAlarm.init();
            Logger.debug("Alarms initialized");
            Logger.info("All mod features initialized successfully");
        }
        catch (Exception e) {
            Logger.error("Failed to initialize mod features", e);
            if (sentryService != null) {
                sentryService.reportException(e);
            }
            throw new RuntimeException("Feature initialization failed", e);
        }
    }

    private void registerCommands() {
        block2: {
            try {
                ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
                    CommandHandler.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
                    Logger.debug("Commands registered successfully");
                });
            }
            catch (Exception e) {
                Logger.error("Failed to register commands", e);
                if (sentryService == null) break block2;
                sentryService.reportException(e);
            }
        }
    }

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return ConfigScreenBuilder.createScreenFactory();
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }

    public static SentryService getSentryService() {
        return sentryService;
    }

    public static DiscordRpcService getDiscordRpcService() {
        return discordRpcService;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String getVersion() {
        return "1.0.5";
    }

    public static String getModName() {
        return "Wuemeli's Utils";
    }
}

