/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.alarm;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import wuemeli.utils.config.ConfigManager;
import wuemeli.utils.config.ModConfig;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class EffectAlarm {
    private static int tickCounter = 0;
    private static int soundIntervalCounter = 0;
    private static final int TICK_INTERVAL = 10;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (++tickCounter % 10 != 0) {
                return;
            }
            ConfigManager configManager = ConfigManager.getInstance();
            if (configManager == null || !configManager.isLoaded()) {
                return;
            }
            ModConfig config = configManager.getConfig();
            if (!config.effectAlarm.enabled || client.field_1724 == null) {
                return;
            }
            client.field_1724.method_6026().forEach(effectInstance -> {
                if (effectInstance == null) {
                    return;
                }
                int remainingDuration = effectInstance.method_5584();
                int thresholdSeconds = config.effectAlarm.thresholds;
                int thresholdTicks = thresholdSeconds * 20;
                if (remainingDuration <= 0 || remainingDuration > thresholdTicks || effectInstance.method_48559()) {
                    return;
                }
                int soundIntervalTicks = config.effectAlarm.soundInterval * 20;
                if (++soundIntervalCounter >= soundIntervalTicks) {
                    EffectAlarm.playWarningSound(client);
                    soundIntervalCounter = 0;
                    Logger.debug("Effect alarm triggered - effect expiring in " + remainingDuration / 20 + " seconds");
                }
            });
        });
    }

    private static void playWarningSound(class_310 client) {
        try {
            class_3414 sound = class_3417.field_14627;
            client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)1.0f, (float)0.7f));
        }
        catch (Exception e) {
            Logger.error("Failed to play warning sound", e);
        }
    }
}

