/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.autorespawn;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import wuemeli.utils.config.ConfigManager;
import wuemeli.utils.config.ModConfig;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class AutoRespawn {
    private static long deathTime = 0L;
    private static boolean wasDead = false;

    public static void init() {
        ConfigManager configManager = ConfigManager.getInstance();
        if (configManager == null || !configManager.isLoaded()) {
            return;
        }
        ModConfig config = configManager.getConfig();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!config.autoRespawn.enabled || client.field_1724 == null) {
                AutoRespawn.resetDeathState();
                return;
            }
            if (client.field_1724.method_29504()) {
                AutoRespawn.handleRespawn(client);
            } else {
                AutoRespawn.resetDeathState();
            }
        });
    }

    private static void handleRespawn(class_310 client) {
        ConfigManager configManager;
        if (!wasDead) {
            deathTime = System.currentTimeMillis();
            wasDead = true;
            Logger.info("Player died");
        }
        if ((configManager = ConfigManager.getInstance()) == null || !configManager.isLoaded()) {
            return;
        }
        ModConfig config = configManager.getConfig();
        if (System.currentTimeMillis() - deathTime >= (long)config.autoRespawn.delay && client.field_1724 != null) {
            Logger.info("Auto respawning player");
            client.field_1724.method_7331();
            client.method_1507(null);
            AutoRespawn.resetDeathState();
        }
    }

    private static void resetDeathState() {
        deathTime = 0L;
        wasDead = false;
    }
}

