/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import wuemeli.utils.config.ConfigManager;
import wuemeli.utils.config.ModConfig;
import wuemeli.utils.connection.ConnectionManager;
import wuemeli.utils.globalchat.GlobalChatManager;
import wuemeli.utils.logger.Logger;
import wuemeli.utils.privatemsg.PrivateMessageManager;

@Environment(value=EnvType.CLIENT)
public class CommandHandler {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        CommandHandler.registerMainCommands(dispatcher, "poppy");
    }

    private static void registerMainCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, String commandName) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)commandName).then(ClientCommandManager.literal((String)"gc").then(ClientCommandManager.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(CommandHandler::sendGlobalMessage)))).then(ClientCommandManager.literal((String)"pm").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(ClientCommandManager.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(CommandHandler::sendPrivateMessage))))).then(ClientCommandManager.literal((String)"r").then(ClientCommandManager.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(CommandHandler::sendReply)))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggle").then(ClientCommandManager.literal((String)"gc").executes(CommandHandler::toggleGlobalChat))).then(ClientCommandManager.literal((String)"pm").executes(CommandHandler::togglePrivateMessaging)))).then(ClientCommandManager.literal((String)"status").executes(CommandHandler::showStatus)));
    }

    private static int sendGlobalMessage(CommandContext<FabricClientCommandSource> context) {
        try {
            String message = StringArgumentType.getString(context, (String)"message");
            if (!GlobalChatManager.isEnabled()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cGlobal chat is disabled. Use \u00a7e/wuemeli toggle gc \u00a7cto enable it."));
                return 0;
            }
            if (!GlobalChatManager.isReady()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cGlobal chat is not available. Check your connection and try again."));
                return 0;
            }
            if (message.trim().isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cCannot send empty message to global chat"));
                return 0;
            }
            if (message.length() > 256) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cMessage too long for global chat (max 256 characters)"));
                return 0;
            }
            GlobalChatManager.sendGlobalMessage(message);
            Logger.debug("Global chat message sent via command: " + message.substring(0, Math.min(50, message.length())));
        }
        catch (Exception e) {
            Logger.error("Error sending global chat message via command", e);
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cError sending global chat message"));
        }
        return 1;
    }

    private static int sendPrivateMessage(CommandContext<FabricClientCommandSource> context) {
        try {
            String playerName = StringArgumentType.getString(context, (String)"player");
            String message = StringArgumentType.getString(context, (String)"message");
            if (playerName.trim().isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cPlayer name cannot be empty"));
                return 0;
            }
            if (message.trim().isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cMessage cannot be empty"));
                return 0;
            }
            PrivateMessageManager.setLastMessagedPlayer(playerName);
            PrivateMessageManager.sendPrivateMessage(playerName, message);
            ConfigManager configManager = ConfigManager.getInstance();
            if (configManager != null && configManager.isLoaded()) {
                ModConfig config = configManager.getConfig();
                if (!PrivateMessageManager.isUsingFallbackMode && config.privateMessaging.enabled) {
                    String formattedMessage = config.privateMessaging.outgoingFormat.replace("{recipient}", playerName).replace("{message}", message);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)formattedMessage));
                }
            }
            Logger.debug("Private message sent via command to: " + playerName);
        }
        catch (Exception e) {
            Logger.error("Error sending private message via command", e);
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cError sending private message"));
        }
        return 1;
    }

    private static int sendReply(CommandContext<FabricClientCommandSource> context) {
        try {
            String message = StringArgumentType.getString(context, (String)"message");
            String lastPlayer = PrivateMessageManager.getLastMessagedPlayer();
            if (lastPlayer == null || lastPlayer.isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7cYou have nobody to reply to"));
                return 0;
            }
            if (message.trim().isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cMessage cannot be empty"));
                return 0;
            }
            PrivateMessageManager.sendPrivateMessage(lastPlayer, message);
            ConfigManager configManager = ConfigManager.getInstance();
            if (configManager != null && configManager.isLoaded()) {
                ModConfig config = configManager.getConfig();
                if (!PrivateMessageManager.isUsingFallbackMode && config.privateMessaging.enabled) {
                    String formattedMessage = config.privateMessaging.outgoingFormat.replace("{recipient}", lastPlayer).replace("{message}", message);
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)formattedMessage));
                }
            }
            Logger.debug("Reply sent via command to: " + lastPlayer);
        }
        catch (Exception e) {
            Logger.error("Error sending reply via command", e);
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cError sending reply"));
        }
        return 1;
    }

    private static int toggleGlobalChat(CommandContext<FabricClientCommandSource> context) {
        try {
            boolean newState = GlobalChatManager.toggleGlobalChat();
            String status = newState ? "\u00a7aenabled" : "\u00a7cdisabled";
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a76Global chat " + status + "\u00a7r")));
            if (newState && !GlobalChatManager.isReady()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7eNote: Global chat requires server connection and encryption keys"));
            }
            Logger.info("Global chat toggled via command: " + (newState ? "enabled" : "disabled"));
        }
        catch (Exception e) {
            Logger.error("Error toggling global chat via command", e);
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cError toggling global chat"));
        }
        return 1;
    }

    private static int togglePrivateMessaging(CommandContext<FabricClientCommandSource> context) {
        try {
            ConfigManager configManager = ConfigManager.getInstance();
            if (configManager == null || !configManager.isLoaded()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cConfiguration not loaded"));
                return 0;
            }
            ModConfig config = configManager.getConfig();
            config.privateMessaging.enabled = !config.privateMessaging.enabled;
            configManager.save();
            String status = config.privateMessaging.enabled ? "\u00a7aenabled" : "\u00a7cdisabled";
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a76Private messaging " + status + "\u00a7r")));
            Logger.info("Private messaging toggled via command: " + (config.privateMessaging.enabled ? "enabled" : "disabled"));
        }
        catch (Exception e) {
            Logger.error("Error toggling private messaging via command", e);
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cError toggling private messaging"));
        }
        return 1;
    }

    private static int showStatus(CommandContext<FabricClientCommandSource> context) {
        try {
            boolean connected;
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76=== Mod Status ==="));
            boolean gcEnabled = GlobalChatManager.isEnabled();
            boolean gcReady = GlobalChatManager.isReady();
            String gcStatus = gcEnabled ? (gcReady ? "\u00a7aReady" : "\u00a7eEnabled (Not Ready)") : "\u00a7cDisabled";
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a76Global Chat: " + gcStatus)));
            ConfigManager configManager = ConfigManager.getInstance();
            if (configManager != null && configManager.isLoaded()) {
                ModConfig config = configManager.getConfig();
                boolean pmEnabled = config.privateMessaging.enabled;
                String pmStatus = pmEnabled ? "\u00a7aEnabled" : "\u00a7cDisabled";
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a76Private Messaging: " + pmStatus)));
                if (config.privateMessaging.alwaysFallbackToVanilla) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7ePrivate Messaging: Always using vanilla fallback"));
                }
            }
            String connectionStatus = (connected = ConnectionManager.isConnected()) ? "\u00a7aConnected" : "\u00a7cDisconnected";
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a76Server Connection: " + connectionStatus)));
            String lastPlayer = PrivateMessageManager.getLastMessagedPlayer();
            if (lastPlayer != null && !lastPlayer.isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a76Last messaged: \u00a7f" + lastPlayer)));
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76============================="));
        }
        catch (Exception e) {
            Logger.error("Error showing status via command", e);
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cError retrieving status"));
        }
        return 1;
    }
}

