/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.config;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import wuemeli.utils.config.ModConfig;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static ConfigManager instance;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConfigClassHandler<ModConfig> configHandler;
    private final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("wuemeli.json");
    private ModConfig config;
    private boolean loaded = false;

    private ConfigManager() {
        this.configHandler = ConfigClassHandler.createBuilder(ModConfig.class).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(this.configPath).build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigManager getInstance() {
        if (instance != null) return instance;
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (instance != null) return instance;
            instance = new ConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void load() {
        this.lock.writeLock().lock();
        try {
            this.createConfigDirectoryIfNotExists();
            if (Files.exists(this.configPath, new LinkOption[0])) {
                try {
                    this.configHandler.load();
                    this.config = (ModConfig)this.configHandler.instance();
                    this.loaded = true;
                    Logger.info("Configuration loaded successfully from: " + String.valueOf(this.configPath));
                }
                catch (Exception e) {
                    Logger.error("Failed to load configuration, creating backup and using defaults", e);
                }
            } else {
                Logger.info("Configuration file not found, creating with defaults");
                this.createDefaultConfig();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void save() {
        this.lock.readLock().lock();
        try {
            if (!this.loaded) {
                Logger.warn("Cannot save configuration that hasn't been loaded");
                return;
            }
            this.configHandler.save();
            Logger.debug("Configuration saved successfully");
        }
        catch (Exception e) {
            Logger.error("Failed to save configuration", e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CompletableFuture<Void> saveAsync() {
        return CompletableFuture.runAsync(this::save);
    }

    public ModConfig getConfig() {
        this.lock.readLock().lock();
        try {
            if (!this.loaded) {
                Logger.warn("Configuration not loaded, returning new instance");
                ModConfig modConfig = new ModConfig();
                return modConfig;
            }
            ModConfig modConfig = this.config;
            return modConfig;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isLoaded() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.loaded;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    private void createDefaultConfig() {
        this.config = new ModConfig();
        this.loaded = true;
        this.save();
    }

    private void createConfigDirectoryIfNotExists() {
        Path configDir = this.configPath.getParent();
        if (!Files.exists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
                Logger.debug("Created config directory: " + String.valueOf(configDir));
            }
            catch (IOException e) {
                Logger.error("Failed to create config directory", e);
            }
        }
    }
}

