/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.config;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import wuemeli.utils.config.ModConfig;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class ConfigMigrationHelper {
    private static final Map<String, String> FIELD_MAPPING = new HashMap<String, String>();

    public static boolean migrateFromStaticFields(Class<?> oldMainClass, ModConfig newConfig) {
        if (oldMainClass == null || newConfig == null) {
            Logger.warn("Cannot migrate: null parameters provided");
            return false;
        }
        boolean migrationSuccessful = true;
        int migratedFields = 0;
        try {
            Field[] fields;
            for (Field field : fields = oldMainClass.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                String fieldName = field.getName();
                String configPath = FIELD_MAPPING.get(fieldName);
                if (configPath == null) {
                    Logger.debug("No mapping found for field: " + fieldName);
                    continue;
                }
                try {
                    field.setAccessible(true);
                    Object value = field.get(null);
                    if (ConfigMigrationHelper.setConfigValue(newConfig, configPath, value)) {
                        ++migratedFields;
                        Logger.debug("Migrated field: " + fieldName + " -> " + configPath);
                        continue;
                    }
                    Logger.warn("Failed to migrate field: " + fieldName);
                    migrationSuccessful = false;
                }
                catch (IllegalAccessException e) {
                    Logger.error("Cannot access field: " + fieldName, e);
                    migrationSuccessful = false;
                }
                catch (Exception e) {
                    Logger.error("Error migrating field: " + fieldName, e);
                    migrationSuccessful = false;
                }
            }
            Logger.info("Migration completed. Migrated " + migratedFields + " fields");
        }
        catch (Exception e) {
            Logger.error("Critical error during migration", e);
            return false;
        }
        return migrationSuccessful;
    }

    private static boolean setConfigValue(ModConfig config, String path, Object value) {
        if (config == null || path == null || value == null) {
            return false;
        }
        String[] parts = path.split("\\.");
        if (parts.length != 2) {
            Logger.warn("Invalid config path: " + path);
            return false;
        }
        String section = parts[0];
        String field = parts[1];
        try {
            Object sectionObject = ConfigMigrationHelper.getConfigSection(config, section);
            if (sectionObject == null) {
                Logger.warn("Unknown config section: " + section);
                return false;
            }
            Field targetField = sectionObject.getClass().getDeclaredField(field);
            targetField.setAccessible(true);
            Object convertedValue = ConfigMigrationHelper.convertValue(value, targetField.getType());
            targetField.set(sectionObject, convertedValue);
            return true;
        }
        catch (NoSuchFieldException e) {
            Logger.error("Field not found: " + path, e);
            return false;
        }
        catch (IllegalAccessException e) {
            Logger.error("Cannot access field: " + path, e);
            return false;
        }
        catch (Exception e) {
            Logger.error("Error setting config value: " + path, e);
            return false;
        }
    }

    private static Object getConfigSection(ModConfig config, String sectionName) {
        switch (sectionName) {
            case "general": {
                return config.general;
            }
            case "playerTabGlow": {
                return config.playerTabGlow;
            }
            case "customBrand": {
                return config.customBrand;
            }
            case "autoRespawn": {
                return config.autoRespawn;
            }
            case "congrater": {
                return config.congrater;
            }
            case "healthAlarm": {
                return config.healthAlarm;
            }
            case "effectAlarm": {
                return config.effectAlarm;
            }
            case "privateMessaging": {
                return config.privateMessaging;
            }
        }
        return null;
    }

    private static Object convertValue(Object value, Class<?> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (targetType == Boolean.TYPE && value instanceof Boolean) {
            return value;
        }
        if (targetType == Integer.TYPE && value instanceof Integer) {
            return value;
        }
        if (targetType == Boolean.class && value instanceof Boolean) {
            return value;
        }
        if (targetType == Integer.class && value instanceof Integer) {
            return value;
        }
        if (targetType == Color.class && value instanceof Color) {
            return value;
        }
        if (targetType == String.class) {
            return value.toString();
        }
        if (targetType.isEnum() && value.getClass().isEnum()) {
            try {
                return Enum.valueOf(targetType, ((Enum)value).name());
            }
            catch (IllegalArgumentException e) {
                Logger.warn("Cannot convert enum value: " + String.valueOf(value) + " to " + targetType.getSimpleName());
                return null;
            }
        }
        Logger.warn("No conversion available from " + value.getClass().getSimpleName() + " to " + targetType.getSimpleName());
        return value;
    }

    public static Map<String, Object> backupStaticFields(Class<?> mainClass) {
        HashMap<String, Object> backup = new HashMap<String, Object>();
        try {
            Field[] fields;
            for (Field field : fields = mainClass.getDeclaredFields()) {
                String fieldName;
                if (!Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || !FIELD_MAPPING.containsKey(fieldName = field.getName())) continue;
                try {
                    field.setAccessible(true);
                    Object value = field.get(null);
                    backup.put(fieldName, value);
                }
                catch (IllegalAccessException e) {
                    Logger.error("Cannot backup field: " + fieldName, e);
                }
            }
            Logger.info("Backed up " + backup.size() + " static fields");
        }
        catch (Exception e) {
            Logger.error("Error during backup", e);
        }
        return backup;
    }

    public static boolean validateMapping() {
        String[] expectedFields;
        boolean valid = true;
        for (String field : expectedFields = new String[]{"playerTabGlowEnabled", "playerTabGlowColor", "customBrandEnabled", "customBrand", "autoRespawnEnabled", "autoRespawnDelay", "congraterEnabled", "deathMessage", "killMessage", "sendDeathMessage", "sendKillMessage", "congraterMessageDelay", "healthAlarmEnabled", "healthAlarmThreshold", "healthAlarmSoundInterval", "effectAlarmEnabled", "effectAlarmThresholds", "effectAlarmSoundInterval", "privateMessagingEnabled", "alwaysFallbackToVanilla", "fallbackVanillaCommand", "fallbackCommandSyntax", "privateMessageIncomingFormat", "privateMessageOutgoingFormat", "logLevel", "cosmeticsEnabled", "particleTickInterval"}) {
            if (FIELD_MAPPING.containsKey(field)) continue;
            Logger.warn("Missing mapping for field: " + field);
            valid = false;
        }
        if (valid) {
            Logger.info("All field mappings validated successfully");
        }
        return valid;
    }

    static {
        FIELD_MAPPING.put("playerTabGlowEnabled", "playerTabGlow.enabled");
        FIELD_MAPPING.put("playerTabGlowColor", "playerTabGlow.color");
        FIELD_MAPPING.put("customBrandEnabled", "customBrand.enabled");
        FIELD_MAPPING.put("customBrand", "customBrand.brand");
        FIELD_MAPPING.put("autoRespawnEnabled", "autoRespawn.enabled");
        FIELD_MAPPING.put("autoRespawnDelay", "autoRespawn.delay");
        FIELD_MAPPING.put("congraterEnabled", "congrater.enabled");
        FIELD_MAPPING.put("deathMessage", "congrater.deathMessage");
        FIELD_MAPPING.put("killMessage", "congrater.killMessage");
        FIELD_MAPPING.put("sendDeathMessage", "congrater.sendDeathMessage");
        FIELD_MAPPING.put("sendKillMessage", "congrater.sendKillMessage");
        FIELD_MAPPING.put("congraterMessageDelay", "congrater.messageDelay");
        FIELD_MAPPING.put("healthAlarmEnabled", "healthAlarm.enabled");
        FIELD_MAPPING.put("healthAlarmThreshold", "healthAlarm.threshold");
        FIELD_MAPPING.put("healthAlarmSoundInterval", "healthAlarm.soundInterval");
        FIELD_MAPPING.put("effectAlarmEnabled", "effectAlarm.enabled");
        FIELD_MAPPING.put("effectAlarmThresholds", "effectAlarm.thresholds");
        FIELD_MAPPING.put("effectAlarmSoundInterval", "effectAlarm.soundInterval");
        FIELD_MAPPING.put("privateMessagingEnabled", "privateMessaging.enabled");
        FIELD_MAPPING.put("alwaysFallbackToVanilla", "privateMessaging.alwaysFallbackToVanilla");
        FIELD_MAPPING.put("fallbackVanillaCommand", "privateMessaging.fallbackVanillaCommand");
        FIELD_MAPPING.put("fallbackCommandSyntax", "privateMessaging.fallbackCommandSyntax");
        FIELD_MAPPING.put("privateMessageIncomingFormat", "privateMessaging.incomingFormat");
        FIELD_MAPPING.put("privateMessageOutgoingFormat", "privateMessaging.outgoingFormat");
        FIELD_MAPPING.put("logLevel", "general.logLevel");
        FIELD_MAPPING.put("cosmeticsEnabled", "general.cosmeticsEnabled");
        FIELD_MAPPING.put("particleTickInterval", "general.particleTickInterval");
    }
}

