/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.config;

import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import wuemeli.utils.config.ModConstants;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class ModConfig {
    @SerialEntry
    public GeneralConfig general = new GeneralConfig();
    @SerialEntry
    public PlayerTabGlowConfig playerTabGlow = new PlayerTabGlowConfig();
    @SerialEntry
    public CustomBrandConfig customBrand = new CustomBrandConfig();
    @SerialEntry
    public AutoRespawnConfig autoRespawn = new AutoRespawnConfig();
    @SerialEntry
    public CongraterConfig congrater = new CongraterConfig();
    @SerialEntry
    public HealthAlarmConfig healthAlarm = new HealthAlarmConfig();
    @SerialEntry
    public EffectAlarmConfig effectAlarm = new EffectAlarmConfig();
    @SerialEntry
    public PrivateMessagingConfig privateMessaging = new PrivateMessagingConfig();
    @SerialEntry
    public GlobalChatConfig globalChat = new GlobalChatConfig();

    @Environment(value=EnvType.CLIENT)
    public static class GeneralConfig {
        @SerialEntry
        public Logger.LogLevel logLevel = ModConstants.Defaults.LOG_LEVEL;
    }

    @Environment(value=EnvType.CLIENT)
    public static class PlayerTabGlowConfig {
        @SerialEntry
        public boolean enabled = false;
        @SerialEntry
        public Color color = ModConstants.Defaults.PLAYER_TAB_GLOW_COLOR;
    }

    @Environment(value=EnvType.CLIENT)
    public static class CustomBrandConfig {
        @SerialEntry
        public boolean enabled = false;
        @SerialEntry
        public String brand = "fabric";

        public void validate() {
            if (this.brand == null || this.brand.trim().isEmpty()) {
                this.brand = "fabric";
            }
            if (this.brand.length() > 64) {
                this.brand = this.brand.substring(0, 64);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class AutoRespawnConfig {
        @SerialEntry
        public boolean enabled = false;
        @SerialEntry
        public int delay = 1000;

        public void validate() {
            if (this.delay < 100) {
                this.delay = 100;
            }
            if (this.delay > 10000) {
                this.delay = 10000;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class CongraterConfig {
        @SerialEntry
        public boolean enabled = false;
        @SerialEntry
        public String deathMessage = "gg";
        @SerialEntry
        public String killMessage = "gg ez";
        @SerialEntry
        public boolean sendDeathMessage = true;
        @SerialEntry
        public boolean sendKillMessage = true;
        @SerialEntry
        public int messageDelay = 500;

        public void validate() {
            if (this.deathMessage == null) {
                this.deathMessage = "gg";
            }
            if (this.killMessage == null) {
                this.killMessage = "gg ez";
            }
            if (this.deathMessage.length() > 256) {
                this.deathMessage = this.deathMessage.substring(0, 256);
            }
            if (this.killMessage.length() > 256) {
                this.killMessage = this.killMessage.substring(0, 256);
            }
            if (this.messageDelay < 0) {
                this.messageDelay = 0;
            }
            if (this.messageDelay > 5000) {
                this.messageDelay = 5000;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class HealthAlarmConfig {
        @SerialEntry
        public boolean enabled = false;
        @SerialEntry
        public int threshold = 6;
        @SerialEntry
        public int soundInterval = 5;

        public void validate() {
            if (this.threshold < 1) {
                this.threshold = 1;
            }
            if (this.threshold > 20) {
                this.threshold = 20;
            }
            if (this.soundInterval < 1) {
                this.soundInterval = 1;
            }
            if (this.soundInterval > 60) {
                this.soundInterval = 60;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class EffectAlarmConfig {
        @SerialEntry
        public boolean enabled = false;
        @SerialEntry
        public int thresholds = 15;
        @SerialEntry
        public int soundInterval = 5;

        public void validate() {
            if (this.thresholds < 1) {
                this.thresholds = 1;
            }
            if (this.thresholds > 60) {
                this.thresholds = 60;
            }
            if (this.soundInterval < 1) {
                this.soundInterval = 1;
            }
            if (this.soundInterval > 60) {
                this.soundInterval = 60;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PrivateMessagingConfig {
        @SerialEntry
        public boolean enabled = true;
        @SerialEntry
        public boolean alwaysFallbackToVanilla = false;
        @SerialEntry
        public String fallbackVanillaCommand = "msg";
        @SerialEntry
        public String fallbackCommandSyntax = "{command} {player} {message}";
        @SerialEntry
        public String incomingFormat = "{sender} whispers to you: \u00a7r{message}";
        @SerialEntry
        public String outgoingFormat = "You whisper to {recipient}: \u00a7r{message}";

        public void validate() {
            if (this.fallbackVanillaCommand == null || this.fallbackVanillaCommand.trim().isEmpty()) {
                this.fallbackVanillaCommand = "msg";
            }
            if (this.fallbackCommandSyntax == null || this.fallbackCommandSyntax.trim().isEmpty()) {
                this.fallbackCommandSyntax = "{command} {player} {message}";
            }
            if (this.incomingFormat == null || this.incomingFormat.trim().isEmpty()) {
                this.incomingFormat = "{sender} whispers to you: \u00a7r{message}";
            }
            if (this.outgoingFormat == null || this.outgoingFormat.trim().isEmpty()) {
                this.outgoingFormat = "You whisper to {recipient}: \u00a7r{message}";
            }
            if (this.fallbackVanillaCommand.length() > 64) {
                this.fallbackVanillaCommand = this.fallbackVanillaCommand.substring(0, 64);
            }
            if (this.incomingFormat.length() > 256) {
                this.incomingFormat = this.incomingFormat.substring(0, 256);
            }
            if (this.outgoingFormat.length() > 256) {
                this.outgoingFormat = this.outgoingFormat.substring(0, 256);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class GlobalChatConfig {
        @SerialEntry
        public boolean enabled = false;
        @SerialEntry
        public String prefix = "\u00a78[\u00a76Global\u00a78]\u00a7r";
        @SerialEntry
        public String messageFormat = "{prefix} \u00a77{sender}\u00a7r: {message}";
        @SerialEntry
        public String ownMessageFormat = "{prefix} \u00a77You\u00a7r: {message}";

        public void validate() {
            if (this.prefix == null) {
                this.prefix = "\u00a78[\u00a76Global\u00a78]\u00a7r";
            }
            if (this.messageFormat == null || this.messageFormat.trim().isEmpty()) {
                this.messageFormat = "{prefix} \u00a77{sender}\u00a7r: {message}";
            }
            if (this.ownMessageFormat == null || this.ownMessageFormat.trim().isEmpty()) {
                this.ownMessageFormat = "{prefix} \u00a77You\u00a7r: {message}";
            }
            if (this.prefix.length() > 256) {
                this.prefix = this.prefix.substring(0, 256);
            }
            if (this.messageFormat.length() > 256) {
                this.messageFormat = this.messageFormat.substring(0, 256);
            }
            if (this.ownMessageFormat.length() > 256) {
                this.ownMessageFormat = this.ownMessageFormat.substring(0, 256);
            }
        }
    }
}

