/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.congrater;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_746;
import wuemeli.utils.config.ConfigManager;
import wuemeli.utils.config.ModConfig;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class Congrater {
    private static boolean wasDead = false;
    private static boolean messageScheduled = false;
    private static long deathTime = 0L;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            ConfigManager configManager = ConfigManager.getInstance();
            if (configManager == null || !configManager.isLoaded()) {
                return;
            }
            ModConfig config = configManager.getConfig();
            if (!config.congrater.enabled || client.field_1724 == null) {
                Congrater.resetState();
                return;
            }
            if (config.congrater.deathMessage != null && !config.congrater.deathMessage.isEmpty()) {
                boolean isDead = client.field_1724.method_29504();
                if (isDead && !wasDead && !messageScheduled) {
                    wasDead = true;
                    messageScheduled = true;
                    deathTime = System.currentTimeMillis();
                    Logger.debug("Death detected");
                } else if (isDead && messageScheduled && System.currentTimeMillis() - deathTime >= (long)config.congrater.messageDelay) {
                    Congrater.sendChatMessage(client.field_1724, config.congrater.deathMessage);
                    messageScheduled = false;
                    Logger.info("Death message sent");
                } else if (!isDead && wasDead) {
                    Congrater.resetState();
                }
            }
        });
    }

    private static void resetState() {
        wasDead = false;
        messageScheduled = false;
        deathTime = 0L;
    }

    public static void onPlayerKilled(String killerName) {
        ConfigManager configManager = ConfigManager.getInstance();
        if (configManager == null || !configManager.isLoaded()) {
            return;
        }
        ModConfig config = configManager.getConfig();
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || !config.congrater.enabled || config.congrater.killMessage == null || config.congrater.killMessage.isEmpty()) {
            return;
        }
        class_746 player = client.field_1724;
        if (player.method_5477().getString().equals(killerName)) {
            Logger.info("Player got a kill, sending kill message");
            Congrater.sendChatMessage(player, config.congrater.killMessage);
        }
    }

    private static void sendChatMessage(class_746 player, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        player.field_3944.method_45729(message);
    }
}

