/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.globalchat;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import wuemeli.utils.globalchat.GlobalChatManager;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class GlobalChatCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"poppy").then(ClientCommandManager.literal((String)"toggle").executes(GlobalChatCommand::toggleGlobalChat))).then(ClientCommandManager.literal((String)"gc").executes(GlobalChatCommand::sendGlobalMessage)));
    }

    private static int toggleGlobalChat(CommandContext<FabricClientCommandSource> context) {
        try {
            boolean newState = GlobalChatManager.toggleGlobalChat();
            String status = newState ? "\u00a7aenabled" : "\u00a7cdisabled";
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a76Global chat " + status + "\u00a7r")));
            if (newState && !GlobalChatManager.isReady()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7eNote: Global chat requires server connection and encryption keys"));
            }
            Logger.info("Global chat toggled via command: " + (newState ? "enabled" : "disabled"));
        }
        catch (Exception e) {
            Logger.error("Error toggling global chat via command", e);
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cError toggling global chat"));
        }
        return 1;
    }

    private static int sendGlobalMessage(CommandContext<FabricClientCommandSource> context) {
        try {
            String message = StringArgumentType.getString(context, (String)"message");
            if (!GlobalChatManager.isEnabled()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cGlobal chat is disabled. Use \u00a7e/wuemeli globalChat \u00a7cto enable it."));
                return 0;
            }
            if (!GlobalChatManager.isReady()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cGlobal chat is not available. Check your connection and try again."));
                return 0;
            }
            if (message.trim().isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cCannot send empty message to global chat"));
                return 0;
            }
            if (message.length() > 256) {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cMessage too long for global chat (max 256 characters)"));
                return 0;
            }
            GlobalChatManager.sendGlobalMessage(message);
            Logger.debug("Global chat message sent via command: " + message.substring(0, Math.min(50, message.length())));
        }
        catch (Exception e) {
            Logger.error("Error sending global chat message via command", e);
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)"\u00a7cError sending global chat message"));
        }
        return 1;
    }
}

